/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;

class TestNessieError {
    private static final ObjectMapper mapper = new ObjectMapper();

    TestNessieError() {
    }

    @Test
    void fullMessage() {
        ImmutableNessieError e = ImmutableNessieError.builder().message("message").errorCode(ErrorCode.UNKNOWN).status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).reason(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).serverStackTrace("foo.bar.InternalServerError\n\tat some.other.Class").build();
        Assertions.assertThat((String)e.getFullMessage()).isEqualTo(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase() + " (HTTP/" + Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() + "): message\nfoo.bar.InternalServerError\n\tat some.other.Class");
        e = ImmutableNessieError.builder().from((NessieError)e).clientProcessingException(new Exception("processingException")).build();
        Assertions.assertThat((String)e.getFullMessage()).startsWith((CharSequence)(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase() + " (HTTP/" + Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() + "): message\nfoo.bar.InternalServerError\n\tat some.other.Class\njava.lang.Exception: processingException\n\tat org.projectnessie.error.TestNessieError.fullMessage(TestNessieError.java:"));
    }

    @Test
    void jsonRoundTrip() throws JsonProcessingException {
        ImmutableNessieError e0 = ImmutableNessieError.builder().message("message").errorCode(ErrorCode.UNKNOWN).status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).reason(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).serverStackTrace("foo.bar.InternalServerError\n\tat some.other.Class").clientProcessingException(new Exception("processingException")).build();
        String json = mapper.writeValueAsString((Object)e0);
        NessieError e1 = (NessieError)mapper.readValue(json, NessieError.class);
        Assertions.assertThat((Throwable)e1.getClientProcessingException()).isNull();
        ImmutableNessieError e2 = ImmutableNessieError.builder().from((NessieError)e0).clientProcessingException(null).build();
        Assertions.assertThat((Object)e1).isEqualTo((Object)e2);
    }
}

