/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.projectnessie.api.params.DiffParams;

@Execution(value=ExecutionMode.CONCURRENT)
public class DiffParamsTest {
    @Test
    public void testBuilder() {
        DiffParams params = DiffParams.builder().fromRef("from").fromHashOnRef("fromHash").toRef("to").toHashOnRef("toHash").build();
        Assertions.assertThat((Object)params).extracting(new Function[]{DiffParams::getFromRef, DiffParams::getFromHashOnRef, DiffParams::getToRef, DiffParams::getToHashOnRef}).containsExactly(new Object[]{"from", "fromHash", "to", "toHash"});
        params = DiffParams.builder().fromRef("from").toRef("to").toHashOnRef("toHash").build();
        Assertions.assertThat((Object)params).extracting(new Function[]{DiffParams::getFromRef, DiffParams::getFromHashOnRef, DiffParams::getToRef, DiffParams::getToHashOnRef}).containsExactly(new Object[]{"from", null, "to", "toHash"});
        params = DiffParams.builder().fromRef("from").toRef("to").build();
        Assertions.assertThat((Object)params).extracting(new Function[]{DiffParams::getFromRef, DiffParams::getFromHashOnRef, DiffParams::getToRef, DiffParams::getToHashOnRef}).containsExactly(new Object[]{"from", null, "to", null});
    }

    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DiffParams.builder().fromRef("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build DiffParams, some of required attributes are not set [toRef]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DiffParams.builder().toRef("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build DiffParams, some of required attributes are not set [fromRef]");
    }
}

