/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;

@ParametersAreNonnullByDefault
@Generated(from="CommitMeta", generator="Immutables")
@Immutable
public final class ImmutableCommitMeta
extends CommitMeta {
    @Nullable
    private final String hash;
    @Nullable
    private final String committer;
    @Nullable
    private final String author;
    @Nullable
    private final String signedOffBy;
    private final String message;
    @Nullable
    private final Instant commitTime;
    @Nullable
    private final Instant authorTime;
    private final Map<String, String> properties;

    private ImmutableCommitMeta(@Nullable String hash, @Nullable String committer, @Nullable String author, @Nullable String signedOffBy, String message, @Nullable Instant commitTime, @Nullable Instant authorTime, Map<String, String> properties) {
        this.hash = hash;
        this.committer = committer;
        this.author = author;
        this.signedOffBy = signedOffBy;
        this.message = message;
        this.commitTime = commitTime;
        this.authorTime = authorTime;
        this.properties = properties;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="committer")
    @Nullable
    public String getCommitter() {
        return this.committer;
    }

    @Override
    @JsonProperty(value="author")
    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Override
    @JsonProperty(value="signedOffBy")
    @Nullable
    public String getSignedOffBy() {
        return this.signedOffBy;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="commitTime")
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    @Nullable
    public Instant getCommitTime() {
        return this.commitTime;
    }

    @Override
    @JsonProperty(value="authorTime")
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    @Nullable
    public Instant getAuthorTime() {
        return this.authorTime;
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public final ImmutableCommitMeta withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableCommitMeta(value, this.committer, this.author, this.signedOffBy, this.message, this.commitTime, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withCommitter(@Nullable String value) {
        if (Objects.equals(this.committer, value)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, value, this.author, this.signedOffBy, this.message, this.commitTime, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withAuthor(@Nullable String value) {
        if (Objects.equals(this.author, value)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.committer, value, this.signedOffBy, this.message, this.commitTime, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withSignedOffBy(@Nullable String value) {
        if (Objects.equals(this.signedOffBy, value)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.committer, this.author, value, this.message, this.commitTime, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.committer, this.author, this.signedOffBy, newValue, this.commitTime, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withCommitTime(@Nullable Instant value) {
        if (this.commitTime == value) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.committer, this.author, this.signedOffBy, this.message, value, this.authorTime, this.properties);
    }

    public final ImmutableCommitMeta withAuthorTime(@Nullable Instant value) {
        if (this.authorTime == value) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.committer, this.author, this.signedOffBy, this.message, this.commitTime, value, this.properties);
    }

    public final ImmutableCommitMeta withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableCommitMeta.createUnmodifiableMap(true, false, entries);
        return new ImmutableCommitMeta(this.hash, this.committer, this.author, this.signedOffBy, this.message, this.commitTime, this.authorTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitMeta && this.equalTo(0, (ImmutableCommitMeta)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitMeta another) {
        return Objects.equals(this.hash, another.hash) && Objects.equals(this.committer, another.committer) && Objects.equals(this.author, another.author) && Objects.equals(this.signedOffBy, another.signedOffBy) && this.message.equals(another.message) && Objects.equals(this.commitTime, another.commitTime) && Objects.equals(this.authorTime, another.authorTime) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.committer);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.signedOffBy);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.commitTime);
        h += (h << 5) + Objects.hashCode(this.authorTime);
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "CommitMeta{hash=" + this.hash + ", committer=" + this.committer + ", author=" + this.author + ", signedOffBy=" + this.signedOffBy + ", message=" + this.message + ", commitTime=" + this.commitTime + ", authorTime=" + this.authorTime + ", properties=" + this.properties + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitMeta fromJson(Json json) {
        Builder builder = ImmutableCommitMeta.builder();
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.committer != null) {
            builder.committer(json.committer);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.signedOffBy != null) {
            builder.signedOffBy(json.signedOffBy);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.commitTime != null) {
            builder.commitTime(json.commitTime);
        }
        if (json.authorTime != null) {
            builder.authorTime(json.authorTime);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        return builder.build();
    }

    public static ImmutableCommitMeta copyOf(CommitMeta instance) {
        if (instance instanceof ImmutableCommitMeta) {
            return (ImmutableCommitMeta)instance;
        }
        return ImmutableCommitMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CommitMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private long initBits = 1L;
        @Nullable
        private String hash;
        @Nullable
        private String committer;
        @Nullable
        private String author;
        @Nullable
        private String signedOffBy;
        @Nullable
        private String message;
        @Nullable
        private Instant commitTime;
        @Nullable
        private Instant authorTime;
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(CommitMeta instance) {
            Instant authorTimeValue;
            String signedOffByValue;
            String authorValue;
            String committerValue;
            Objects.requireNonNull(instance, "instance");
            String hashValue = instance.getHash();
            if (hashValue != null) {
                this.hash(hashValue);
            }
            if ((committerValue = instance.getCommitter()) != null) {
                this.committer(committerValue);
            }
            if ((authorValue = instance.getAuthor()) != null) {
                this.author(authorValue);
            }
            if ((signedOffByValue = instance.getSignedOffBy()) != null) {
                this.signedOffBy(signedOffByValue);
            }
            this.message(instance.getMessage());
            Instant commitTimeValue = instance.getCommitTime();
            if (commitTimeValue != null) {
                this.commitTime(commitTimeValue);
            }
            if ((authorTimeValue = instance.getAuthorTime()) != null) {
                this.authorTime(authorTimeValue);
            }
            this.putAllProperties(instance.getProperties());
            return this;
        }

        @JsonProperty(value="hash")
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="committer")
        public final Builder committer(@Nullable String committer) {
            this.committer = committer;
            return this;
        }

        @JsonProperty(value="author")
        public final Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        @JsonProperty(value="signedOffBy")
        public final Builder signedOffBy(@Nullable String signedOffBy) {
            this.signedOffBy = signedOffBy;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="commitTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder commitTime(@Nullable Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        @JsonProperty(value="authorTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder authorTime(@Nullable Instant authorTime) {
            this.authorTime = authorTime;
            return this;
        }

        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return this;
        }

        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return this;
        }

        @JsonProperty(value="properties")
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return this;
        }

        public ImmutableCommitMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitMeta(this.hash, this.committer, this.author, this.signedOffBy, this.message, this.commitTime, this.authorTime, ImmutableCommitMeta.createUnmodifiableMap(false, false, this.properties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build CommitMeta, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitMeta", generator="Immutables")
    static final class Json
    extends CommitMeta {
        @Nullable
        String hash;
        @Nullable
        String committer;
        @Nullable
        String author;
        @Nullable
        String signedOffBy;
        @Nullable
        String message;
        @Nullable
        Instant commitTime;
        @Nullable
        Instant authorTime;
        @Nullable
        Map<String, String> properties = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="committer")
        public void setCommitter(@Nullable String committer) {
            this.committer = committer;
        }

        @JsonProperty(value="author")
        public void setAuthor(@Nullable String author) {
            this.author = author;
        }

        @JsonProperty(value="signedOffBy")
        public void setSignedOffBy(@Nullable String signedOffBy) {
            this.signedOffBy = signedOffBy;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="commitTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setCommitTime(@Nullable Instant commitTime) {
            this.commitTime = commitTime;
        }

        @JsonProperty(value="authorTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setAuthorTime(@Nullable Instant authorTime) {
            this.authorTime = authorTime;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommitter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSignedOffBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCommitTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getAuthorTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

