/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.types.ContentTypes;

final class Util {
    public static final char ZERO_BYTE = '\u0000';
    public static final char DOT = '.';
    public static final char GROUP_SEPARATOR = '\u001d';
    public static final char REF_HASH_SEPARATOR = '@';
    public static final char URL_PATH_SEPARATOR = '/';
    public static final String DOT_STRING = ".";
    public static final String ZERO_BYTE_STRING = Character.toString('\u0000');
    public static final String GROUP_SEPARATOR_STRING = Character.toString('\u001d');

    private Util() {
    }

    public static List<String> fromPathString(String encoded) {
        return Arrays.stream(encoded.split("\\.")).map(x -> x.replace('\u001d', '.').replace('\u0000', '.')).collect(Collectors.toList());
    }

    public static String toPathString(List<String> elements) {
        return elements.stream().map(x -> x.replace('.', '\u001d').replace('\u0000', '\u001d')).collect(Collectors.joining(DOT_STRING));
    }

    public static String toPathStringRef(String name, String hash) {
        boolean separatorRequired;
        StringBuilder builder = new StringBuilder();
        boolean bl = separatorRequired = hash != null;
        if (name != null) {
            builder.append(name);
            separatorRequired |= name.indexOf(47) >= 0;
        }
        if (separatorRequired) {
            builder.append('@');
        }
        if (hash != null) {
            builder.append(hash);
        }
        return builder.toString();
    }

    public static Reference fromPathStringRef(@Nonnull String value, @Nonnull Reference.ReferenceType namedRefType) {
        String name = null;
        String hash = null;
        int hashIdx = value.indexOf(64);
        if (hashIdx > 0) {
            name = value.substring(0, hashIdx);
        }
        if (hashIdx < 0) {
            name = value;
        }
        if (hashIdx >= 0 && (hash = value.substring(hashIdx + 1)).isEmpty()) {
            hash = null;
        }
        if (name == null) {
            return Detached.of(hash);
        }
        switch (namedRefType) {
            case TAG: {
                return Tag.of(name, hash);
            }
            case BRANCH: {
                return Branch.of(name, hash);
            }
        }
        throw new IllegalArgumentException("Unsupported reference type: " + (Object)((Object)namedRefType));
    }

    static final class ContentTypeSerializer
    extends JsonSerializer<Content.Type> {
        ContentTypeSerializer() {
        }

        public void serialize(Content.Type value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.name());
            }
        }
    }

    static final class ContentTypeDeserializer
    extends JsonDeserializer<Content.Type> {
        ContentTypeDeserializer() {
        }

        public Content.Type deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = (String)p.readValueAs(String.class);
            return name != null ? ContentTypes.forName(name) : null;
        }
    }
}

