/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ContentsKey {
    private static final char ZERO_BYTE = '\u0000';
    private static final String ZERO_BYTE_STRING = Character.toString('\u0000');
    private final List<String> elements;

    private ContentsKey(List<String> elements) {
        this.elements = Collections.unmodifiableList(elements);
        this.validate();
    }

    public static ContentsKey of(String ... elements) {
        return new ContentsKey(Arrays.asList(elements));
    }

    @JsonCreator
    public static ContentsKey of(@JsonProperty(value="elements") List<String> elements) {
        return new ContentsKey(new ArrayList<String>(elements));
    }

    public List<String> getElements() {
        return this.elements;
    }

    private void validate() {
        for (String e : this.elements) {
            if (!e.contains(ZERO_BYTE_STRING)) continue;
            throw new IllegalArgumentException("A object key cannot contain a zero byte.");
        }
    }

    public static ContentsKey fromPathString(String encoded) {
        List<String> elements = Arrays.stream(encoded.split("\\.")).map(x -> x.replace('\u0000', '.')).collect(Collectors.toList());
        return new ContentsKey(elements);
    }

    public String toPathString() {
        String pathString = this.getElements().stream().map(x -> x.replace('.', '\u0000')).collect(Collectors.joining("."));
        return pathString;
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContentsKey)) {
            return false;
        }
        ContentsKey other = (ContentsKey)obj;
        return Objects.equals(this.elements, other.elements);
    }

    public String toString() {
        return this.elements.stream().collect(Collectors.joining("."));
    }
}

