/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.NessieExec;
import org.apache.spark.sql.execution.datasources.v2.NessieUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!\u0002\u0007\u000e\u0003\u0003a\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005s!)a\n\u0001C\u0001\u001f\")Q\u000b\u0001C)-\")q\r\u0001C!Q\")a\u000e\u0001C\u0005_\")a\u000e\u0001C\u0005u\"1a\u000e\u0001C\u0005\u0003\u001fAq!!\u000b\u0001\t\u0013\tYCA\bCCN,7\u000b[8x\u0019><W\t_3d\u0015\tqq\"\u0001\u0002we)\u0011\u0001#E\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0013'\u0005IQ\r_3dkRLwN\u001c\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u00035I!\u0001I\u0007\u0003\u00159+7o]5f\u000bb,7-\u0001\u0004pkR\u0004X\u000f\u001e\t\u0004G5\u0002dB\u0001\u0013+\u001d\t)\u0003&D\u0001'\u0015\t93$\u0001\u0004=e>|GOP\u0005\u0002S\u0005)1oY1mC&\u00111\u0006L\u0001\ba\u0006\u001c7.Y4f\u0015\u0005I\u0013B\u0001\u00180\u0005\r\u0019V-\u001d\u0006\u0003W1\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003kM\t\u0001bY1uC2L8\u000f^\u0005\u0003oI\u0012\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\r\t\u0014\u0018M\\2i!\rQ4(P\u0007\u0002Y%\u0011A\b\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\u0012eBA A!\t)C&\u0003\u0002BY\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tE&\u0001\bdkJ\u0014XM\u001c;DCR\fGn\\4\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015aB2bi\u0006dwn\u001a\u0006\u0003\u0017N\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u00055C%!D\"bi\u0006dwn\u001a)mk\u001eLg.\u0001\u0004=S:LGO\u0010\u000b\u0006!F\u00136\u000b\u0016\t\u0003=\u0001AQ!I\u0003A\u0002\tBQ\u0001O\u0003A\u0002eBQ!R\u0003A\u0002\u0019CQ!S\u0003A\u0002e\n1B];o\u0013:$XM\u001d8bYR\u0011q\u000b\u0018\t\u0004G5B\u0006CA-[\u001b\u0005!\u0014BA.5\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bu3\u0001\u0019\u00010\u0002\u0007\u0005\u0004\u0018\u000e\u0005\u0002`K6\t\u0001M\u0003\u0002^C*\u0011!mY\u0001\u0007G2LWM\u001c;\u000b\u0005\u0011L\u0012!\u00049s_*,7\r\u001e8fgNLW-\u0003\u0002gA\nYa*Z:tS\u0016\f\u0005/\u001b,2\u00031\u0019\u0018.\u001c9mKN#(/\u001b8h)\ti\u0014\u000eC\u0003k\u000f\u0001\u00071.A\u0005nCb4\u0015.\u001a7egB\u0011!\b\\\u0005\u0003[2\u00121!\u00138u\u0003\u001d\u0019wN\u001c<feR$\"\u0001\u001d=\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018!\u0002;za\u0016\u001c(BA;\u0016\u0003\u0019)hn]1gK&\u0011qO\u001d\u0002\u000b+R3\u0005h\u0015;sS:<\u0007\"B=\t\u0001\u0004i\u0014!B5oaV$HCA>\u007f!\tQD0\u0003\u0002~Y\t!Aj\u001c8h\u0011\u0015I\u0018\u00021\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001^5nK*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!aB%ogR\fg\u000e\u001e\u000b\u0005\u0003#\ti\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002N\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!aB'ba\u0012\u000bG/\u0019\u0005\u0007s*\u0001\r!a\b\u0011\r\u0005\u0005\u0012QE\u001f>\u001b\t\t\u0019C\u0003\u0003\u0002\u0018\u0005\u001d\u0011\u0002BA\u0014\u0003G\u00111!T1q\u00031\u0019wN\u001c<feRl\u0015\r]&W)\u0011\ti#a\r\u0011\u0007i\ny#C\u0002\u000221\u00121!\u00118z\u0011\u0019I8\u00021\u0001\u0002.\u0001")
public abstract class BaseShowLogExec
extends NessieExec {
    private final Option<String> branch;
    private final CatalogPlugin currentCatalog;
    private final Option<String> catalog;

    @Override
    public Seq<InternalRow> runInternal(NessieApiV1 api) {
        String refName = (String)this.branch.getOrElse((Function0 & Serializable & scala.Serializable)() -> NessieUtils$.MODULE$.getCurrentRef(api, $this.currentCatalog, $this.catalog).getName());
        Stream stream = StreamingUtil.getCommitLogStream((NessieApiV1)api, builder -> (GetCommitLogBuilder)builder.refName(refName), (OptionalInt)OptionalInt.empty());
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(stream.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convert(entry.getCommitMeta().getAuthor()), this.convert(entry.getCommitMeta().getCommitter()), this.convert(entry.getCommitMeta().getHash()), this.convert(entry.getCommitMeta().getMessage()), this.convert(entry.getCommitMeta().getSignedOffBy()), BoxesRunTime.boxToLong((long)this.convert(entry.getCommitMeta().getAuthorTime())), BoxesRunTime.boxToLong((long)this.convert(entry.getCommitMeta().getCommitTime())), this.convert(entry.getCommitMeta().getProperties())}))).toSeq();
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(14).append("ShowLogExec ").append(this.catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.currentCatalog.name())).append(" ").append(this.branch).append(" ").toString();
    }

    private UTF8String convert(String input) {
        return UTF8String.fromString((String)(input == null ? "" : input));
    }

    private long convert(Instant input) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, input);
    }

    private MapData convert(Map<String, String> input) {
        return ArrayBasedMapData$.MODULE$.apply(input, (Function1 & Serializable & scala.Serializable)x -> this.convertMapKV(x), (Function1 & Serializable & scala.Serializable)x -> this.convertMapKV(x));
    }

    private Object convertMapKV(Object input) {
        Object object = input;
        if (object instanceof String) {
            String string = (String)object;
            return this.convert(string);
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return BoxesRunTime.boxToLong((long)this.convert(instant));
        }
        return object;
    }

    public BaseShowLogExec(Seq<Attribute> output, Option<String> branch, CatalogPlugin currentCatalog, Option<String> catalog) {
        this.branch = branch;
        this.currentCatalog = currentCatalog;
        this.catalog = catalog;
        Option<String> x$1 = catalog;
        CatalogPlugin x$2 = currentCatalog;
        super(x$2, x$1);
    }
}

