/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.jgit;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.SystemReader;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.jgit.TreeBuilder;
import org.projectnessie.versioned.jgit.TwoWayMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitVersionStore<TABLE, METADATA, TABLE_TYPE extends Enum<TABLE_TYPE>>
implements VersionStore<TABLE, METADATA, TABLE_TYPE> {
    private static final Logger logger = LoggerFactory.getLogger(JGitVersionStore.class);
    private static final String SLASH = "/";
    private final Repository repository;
    private final StoreWorker<TABLE, METADATA, TABLE_TYPE> storeWorker;
    private final ObjectId emptyObject;

    @Inject
    public JGitVersionStore(Repository repository, StoreWorker<TABLE, METADATA, TABLE_TYPE> storeWorker) {
        ObjectId objectId;
        this.storeWorker = storeWorker;
        this.repository = repository;
        try {
            ObjectInserter oi = repository.newObjectInserter();
            objectId = oi.insert(3, new byte[]{0});
            oi.flush();
        }
        catch (IOException e) {
            objectId = null;
            logger.warn("Unable to insert empty object which is used as a sentinel for deletes. This is likely safe to ignore but could indicate a larger problem with the repository.", (Throwable)e);
        }
        this.emptyObject = objectId;
    }

    @Nonnull
    public Hash toHash(@Nonnull NamedRef ref) throws ReferenceNotFoundException {
        org.eclipse.jgit.lib.Ref jgitRef;
        block5: {
            this.repository.getRefDatabase().refresh();
            try {
                if (ref instanceof BranchName) {
                    jgitRef = this.repository.findRef("refs/heads/" + ref.getName());
                    break block5;
                }
                if (ref instanceof TagName) {
                    jgitRef = this.repository.findRef("refs/tags/" + ref.getName());
                    break block5;
                }
                throw new IllegalStateException(String.format("ref %s is not in allowed types", ref));
            }
            catch (IOException e) {
                throw new RuntimeException("Error talking to git repo", e);
            }
        }
        if (jgitRef == null) {
            throw new ReferenceNotFoundException(String.format("Ref %s was not found in the git database", ref));
        }
        return Hash.of((String)jgitRef.getObjectId().name());
    }

    public WithHash<Ref> toRef(String refOfUnknownType) throws ReferenceNotFoundException {
        try {
            org.eclipse.jgit.lib.Ref jgitRef = this.repository.findRef("refs/heads/" + refOfUnknownType);
            if (jgitRef != null) {
                return WithHash.of((Hash)Hash.of((String)jgitRef.getObjectId().name()), (Object)BranchName.of((String)refOfUnknownType));
            }
            jgitRef = this.repository.findRef("refs/tags/" + refOfUnknownType);
            if (jgitRef != null) {
                return WithHash.of((Hash)Hash.of((String)jgitRef.getObjectId().name()), (Object)TagName.of((String)refOfUnknownType));
            }
            try {
                ObjectId hash = this.repository.resolve(refOfUnknownType + "^{tree}");
                if (hash == null) {
                    throw ReferenceNotFoundException.forReference((String)refOfUnknownType);
                }
                return WithHash.of((Hash)Hash.of((String)refOfUnknownType), (Object)Hash.of((String)refOfUnknownType));
            }
            catch (IllegalArgumentException | AmbiguousObjectException | IncorrectObjectTypeException e) {
                throw new ReferenceNotFoundException(String.format("Unable to find the requested reference %s.", refOfUnknownType));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error talking to git repo", e);
        }
    }

    private void testExpectedHash(BranchName branch, Optional<Hash> expectedHash) throws ReferenceNotFoundException {
        if (expectedHash.isPresent()) {
            try {
                this.testLinearTransplantList((List<Hash>)ImmutableList.of((Object)expectedHash.get(), (Object)this.toHash((NamedRef)branch)));
            }
            catch (IllegalArgumentException e) {
                throw ReferenceNotFoundException.forReference((Ref)((Ref)expectedHash.get()));
            }
        }
    }

    public void commit(BranchName branch, Optional<Hash> expectedHash, METADATA metadata, List<Operation<TABLE>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        this.toHash((NamedRef)branch);
        try {
            this.testExpectedHash(branch, expectedHash);
            ObjectId commits = TreeBuilder.commitObjects(operations, this.repository, this.storeWorker.getValueSerializer(), this.emptyObject);
            ObjectId treeId = this.repository.resolve(expectedHash.map(Hash::asString).orElse(branch.getName()) + "^{tree}");
            if (treeId == null) {
                throw ReferenceNotFoundException.forReference((Ref)expectedHash.map(x -> x).orElse((Ref)branch));
            }
            ObjectId newTree = TreeBuilder.merge(treeId, commits, this.repository);
            List<String> unchanged = operations.stream().filter(e -> e instanceof Unchanged).map(Operation::getKey).map(JGitVersionStore::stringFromKey).collect(Collectors.toList());
            Optional<ObjectId> mergedTree = this.commitTreeWithTwoWayMerge(branch, expectedHash, newTree, unchanged);
            ObjectId currentCommitId = this.repository.resolve(branch.getName() + "^{commit}");
            ObjectId currentTreeId = this.repository.resolve(branch.getName() + "^{tree}");
            ObjectId mergedHash = mergedTree.orElseThrow(() -> ReferenceConflictException.forReference((NamedRef)branch, (Optional)expectedHash, Optional.of(currentCommitId).map(AnyObjectId::name).map(Hash::of)));
            this.commitTree(branch, mergedHash, Optional.of(currentCommitId).map(AnyObjectId::name).map(Hash::of), metadata, ObjectId.isEqual((AnyObjectId)currentTreeId, (AnyObjectId)mergedHash), false);
        }
        catch (IOException e2) {
            throw new RuntimeException("Unknown error", e2);
        }
    }

    private Optional<ObjectId> commitTreeWithTwoWayMerge(BranchName branch, Optional<Hash> expectedHash, ObjectId newTree, List<String> unchanged) throws IOException {
        ObjectId currentTreeId = this.repository.resolve(branch.getName() + "^{tree}");
        ObjectId expectedId = this.repository.resolve(expectedHash.map(Hash::asString).orElse(currentTreeId.name()) + "^{tree}");
        Optional<ObjectId> mergedTree = this.tryTwoWayMerge(currentTreeId, newTree, this.repository.newObjectInserter(), expectedId, unchanged);
        return mergedTree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testLinearTransplantList(List<Hash> sequenceToTransplant) throws ReferenceNotFoundException {
        try (RevWalk rw = new RevWalk(this.repository);){
            RevCommit start = null;
            for (Hash hash : sequenceToTransplant) {
                RevCommit commit;
                try {
                    ObjectId obj = this.repository.resolve(hash.asString() + "^{commit}");
                    commit = rw.parseCommit((AnyObjectId)obj);
                }
                catch (IOException | NullPointerException e) {
                    throw ReferenceNotFoundException.forReference((Ref)hash);
                }
                if (start == null) {
                    start = commit;
                    continue;
                }
                try {
                    if (!rw.isMergedInto(start, commit)) {
                        throw new IllegalArgumentException(String.format("Hash %s is not the ancestor for commit %s", start, hash));
                    }
                    start = commit;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Hash %s is not the ancestor for commit %s", start, hash));
                    return;
                }
            }
        }
    }

    public void transplant(BranchName targetBranch, Optional<Hash> expectedHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.testLinearTransplantList(sequenceToTransplant);
        try {
            ObjectId targetTreeId = this.repository.resolve(targetBranch.getName() + "^{tree}");
            if (targetTreeId == null) {
                throw ReferenceNotFoundException.forReference((Ref)expectedHash.map(x -> x).orElse((Ref)targetBranch));
            }
            this.testExpectedHash(targetBranch, expectedHash);
            ObjectId newTree = null;
            for (Hash hash : sequenceToTransplant) {
                ObjectId transplantTree = TreeBuilder.transplant(hash, this.repository);
                if (newTree == null) {
                    newTree = transplantTree;
                    continue;
                }
                newTree = TreeBuilder.merge(newTree, transplantTree, this.repository);
            }
            Optional<ObjectId> mergeTree = this.commitTreeWithTwoWayMerge(targetBranch, expectedHash, newTree, Collections.emptyList());
            ObjectId currentCommitId = this.repository.resolve(targetBranch.getName() + "^{commit}");
            ObjectId currentTreeId = this.repository.resolve(targetBranch.getName() + "^{tree}");
            if (!mergeTree.isPresent()) {
                throw ReferenceConflictException.forReference((NamedRef)targetBranch, expectedHash, Optional.of(currentCommitId).map(AnyObjectId::name).map(Hash::of));
            }
            for (Hash hash : sequenceToTransplant) {
                ObjectId transplantTree = TreeBuilder.merge(currentTreeId, TreeBuilder.transplant(hash, this.repository), this.repository);
                this.commitTree(targetBranch, transplantTree, Optional.of(currentCommitId).map(AnyObjectId::name).map(Hash::of), this.getCommit(hash), false, false);
                currentCommitId = this.repository.resolve(targetBranch.getName() + "^{commit}");
                currentTreeId = this.repository.resolve(targetBranch.getName() + "^{tree}");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            org.eclipse.jgit.lib.Ref ref = this.repository.findRef("refs/heads/" + toBranch.getName());
            if (ref == null) {
                throw ReferenceNotFoundException.forReference((Ref)expectedHash.map(x -> x).orElse((Ref)toBranch));
            }
            ObjectId newCommitId = this.repository.resolve(fromHash.asString() + "^{commit}");
            if (newCommitId == null) {
                throw ReferenceNotFoundException.forReference((Ref)fromHash);
            }
            RevCommit newCommit = RevCommit.parse((byte[])this.repository.getObjectDatabase().open((AnyObjectId)newCommitId).getBytes());
            try (RevWalk walk = new RevWalk(this.repository);){
                ObjectId headId = ref.getObjectId();
                String headName = ref.getName();
                RevCommit headCommit = walk.lookupCommit((AnyObjectId)headId);
                RevCommit upstream = walk.lookupCommit((AnyObjectId)newCommit.getId());
                if (walk.isMergedInto(upstream, headCommit)) {
                    return;
                }
                if (walk.isMergedInto(headCommit, upstream)) {
                    RefUpdate rup = this.repository.updateRef(headName);
                    rup.setNewObjectId((AnyObjectId)newCommit);
                    expectedHash.map(Hash::asString).map(ObjectId::fromString).ifPresent(arg_0 -> ((RefUpdate)rup).setExpectedOldObjectId(arg_0));
                    RefUpdate.Result res = rup.forceUpdate();
                    switch (res) {
                        case FAST_FORWARD: 
                        case FORCED: 
                        case NO_CHANGE: {
                            return;
                        }
                    }
                    throw new IOException("failed update");
                }
                List<RevCommit> pickList = this.calculatePickList(newCommit, headCommit);
                this.transplant(toBranch, expectedHash, pickList.stream().map(AnyObjectId::name).map(Hash::of).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    private List<RevCommit> calculatePickList(RevCommit headCommit, RevCommit upstreamCommit) throws IOException {
        Iterable commitsToUse;
        try (Git git = new Git(this.repository);){
            LogCommand cmd = git.log().addRange((AnyObjectId)upstreamCommit, (AnyObjectId)headCommit);
            commitsToUse = cmd.call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        ArrayList<RevCommit> cherryPickList = new ArrayList<RevCommit>();
        for (RevCommit commit : commitsToUse) {
            if (commit.getParentCount() != 1) continue;
            cherryPickList.add(commit);
        }
        Collections.reverse(cherryPickList);
        return cherryPickList;
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        Hash existingHash = this.toHash(ref);
        if (expectedHash.isPresent() && !existingHash.equals((Object)expectedHash.get())) {
            throw new ReferenceConflictException(String.format("expected hash %s does not match current hash %s", expectedHash, existingHash));
        }
        try {
            this.updateRef(ref, targetHash, expectedHash, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    public void create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        if (!targetHash.isPresent() && ref instanceof TagName) {
            throw new IllegalArgumentException("You must provide a target hash to create a tag.");
        }
        try {
            this.toHash(ref);
            throw new ReferenceAlreadyExistsException(String.format("ref %s already exists", ref));
        }
        catch (ReferenceNotFoundException referenceNotFoundException) {
            try {
                if (!targetHash.isPresent()) {
                    TreeFormatter formatter = new TreeFormatter();
                    ObjectInserter inserter = this.repository.newObjectInserter();
                    ObjectId newTreeId = inserter.insert(formatter);
                    inserter.flush();
                    this.commitTree((BranchName)ref, newTreeId, Optional.empty(), null, false, true);
                } else {
                    ObjectId target = this.repository.resolve(targetHash.get().asString());
                    RefUpdate createBranch = this.repository.updateRef((ref instanceof TagName ? "refs/tags/" : "refs/heads/") + ref.getName());
                    createBranch.setNewObjectId((AnyObjectId)target);
                    RefUpdate.Result result = createBranch.update();
                    if (result.equals((Object)RefUpdate.Result.REJECTED_MISSING_OBJECT)) {
                        throw ReferenceNotFoundException.forReference((Ref)((Ref)targetHash.get()));
                    }
                    if (!result.equals((Object)RefUpdate.Result.NEW)) {
                        throw new IllegalStateException(String.format("result did not complete for create branch on %s with state %s", ref, result));
                    }
                }
            }
            catch (IOException | ReferenceConflictException e) {
                throw new RuntimeException(String.format("Unknown error while creating %s", ref), e);
            }
            return;
        }
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.toHash(ref);
        try {
            RefUpdate update = this.repository.updateRef((ref instanceof TagName ? "refs/tags/" : "refs/heads/") + ref.getName());
            Optional<ObjectId> objectId = JGitVersionStore.fromHash(ref, hash);
            if (objectId.isPresent() && !ObjectId.isEqual((AnyObjectId)update.getRef().getObjectId(), (AnyObjectId)((AnyObjectId)objectId.get()))) {
                throw ReferenceConflictException.forReference((NamedRef)ref, hash, Optional.empty());
            }
            update.setForceUpdate(true);
            objectId.ifPresent(arg_0 -> ((RefUpdate)update).setExpectedOldObjectId(arg_0));
            RefUpdate.Result deleteResult = update.delete();
            if (deleteResult.equals((Object)RefUpdate.Result.REJECTED_MISSING_OBJECT)) {
                throw ReferenceNotFoundException.forReference((Ref)((Ref)hash.get()));
            }
            if (!deleteResult.equals((Object)RefUpdate.Result.FORCED)) {
                throw ReferenceConflictException.forReference((NamedRef)ref, hash, Optional.empty());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    public Stream<WithHash<NamedRef>> getNamedRefs() {
        try {
            Stream<WithHash> branches = this.repository.getRefDatabase().getRefsByPrefix("refs/heads/").stream().map(r -> WithHash.of((Hash)Hash.of((String)r.getObjectId().name()), (Object)BranchName.of((String)r.getName().replace("refs/heads/", ""))));
            Stream<WithHash> tags = this.repository.getRefDatabase().getRefsByPrefix("refs/tags/").stream().map(r -> WithHash.of((Hash)Hash.of((String)r.getObjectId().name()), (Object)TagName.of((String)r.getName().replace("refs/tags/", ""))));
            return Stream.concat(branches, tags);
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    public Stream<WithHash<METADATA>> getCommits(Ref ref) throws ReferenceNotFoundException {
        String hashName = JGitVersionStore.refName(ref);
        try {
            ObjectId objectId = this.repository.resolve(hashName);
            if (objectId == null) {
                throw new ReferenceNotFoundException(String.format("Ref %s not found", ref));
            }
            RevWalk walk = new RevWalk(this.repository);
            walk.markStart(this.repository.parseCommit((AnyObjectId)objectId));
            Serializer serializer = this.storeWorker.getMetadataSerializer();
            return StreamSupport.stream(JGitVersionStore.skipLastElement(walk.spliterator()), false).map(r -> {
                Hash hash = Hash.of((String)r.name());
                Object metadata = serializer.fromBytes(ByteString.copyFrom((String)r.getFullMessage(), (Charset)StandardCharsets.UTF_8));
                return WithHash.of((Hash)hash, (Object)metadata);
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error", e);
        }
    }

    private METADATA getCommit(Hash hash) throws IOException {
        RevCommit r = this.repository.parseCommit((AnyObjectId)ObjectId.fromString((String)hash.asString()));
        Serializer serializer = this.storeWorker.getMetadataSerializer();
        Object metadata = serializer.fromBytes(ByteString.copyFrom((String)r.getFullMessage(), (Charset)StandardCharsets.UTF_8));
        return (METADATA)metadata;
    }

    public Stream<WithType<Key, TABLE_TYPE>> getKeys(Ref ref) {
        Stream<WithType<Key, TABLE_TYPE>> stream;
        final TreeWalk treeWalk = new TreeWalk(this.repository);
        try {
            ObjectId treeId = this.repository.resolve(JGitVersionStore.refName(ref) + "^{tree}");
            treeWalk.addTree((AnyObjectId)treeId);
            treeWalk.setRecursive(true);
            Iterator<TreeWalk> iterator = new Iterator<TreeWalk>(){

                @Override
                public boolean hasNext() {
                    try {
                        return treeWalk.next();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unknown error whilst iterating", e);
                    }
                }

                @Override
                public TreeWalk next() {
                    return treeWalk;
                }
            };
            stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).map(tw -> {
                try {
                    Key key = JGitVersionStore.keyFromUrlString(treeWalk.getPathString());
                    ByteString table = JGitVersionStore.getTable(treeWalk, this.repository);
                    Enum payload = this.storeWorker.getValueSerializer().getType(this.storeWorker.getValueSerializer().fromBytes(table));
                    return WithType.of((Enum)payload, (Object)key);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unknown error whilst iterating", e);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    treeWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unknown error", e);
            }
        }
        treeWalk.close();
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TABLE getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        String hashName = JGitVersionStore.refName(ref);
        String table = JGitVersionStore.stringFromKey(key);
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            ObjectId treeId = this.repository.resolve(hashName + "^{tree}");
            treeWalk.addTree((AnyObjectId)treeId);
            treeWalk.setRecursive(true);
            treeWalk.setFilter((TreeFilter)PathFilter.create((String)table));
            if (!treeWalk.next()) return null;
            ByteString bytes = JGitVersionStore.getTable(treeWalk, this.repository);
            Object object = this.storeWorker.getValueSerializer().fromBytes(bytes);
            return (TABLE)object;
        }
        catch (IOException e) {
            throw new ReferenceNotFoundException(String.format("reference for ref %s and key %s not found", ref, key), (Throwable)e);
        }
    }

    public List<Optional<TABLE>> getValues(Ref ref, List<Key> key) {
        String hashName = JGitVersionStore.refName(ref);
        Map<String, Key> keys = key.stream().collect(Collectors.toMap(JGitVersionStore::stringFromKey, k -> k));
        HashMap<Key, Object> tables = new HashMap<Key, Object>();
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            ObjectId treeId = this.repository.resolve(hashName + "^{tree}");
            treeWalk.addTree((AnyObjectId)treeId);
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                if (!keys.containsKey(treeWalk.getPathString())) continue;
                ByteString bytes = JGitVersionStore.getTable(treeWalk, this.repository);
                tables.put(keys.get(treeWalk.getPathString()), this.storeWorker.getValueSerializer().fromBytes(bytes));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown jgit error", e);
        }
        return key.stream().map(k -> Optional.ofNullable(tables.get(k))).collect(Collectors.toList());
    }

    public VersionStore.Collector collectGarbage() {
        throw new IllegalStateException("Not yet implemented.");
    }

    private void commitTree(BranchName branch, ObjectId newTree, Optional<Hash> expectedHash, METADATA metadata, boolean force, boolean empty) throws IOException, ReferenceConflictException {
        ObjectInserter inserter = this.repository.newObjectInserter();
        CommitBuilder commitBuilder = this.fromUser(metadata, empty);
        commitBuilder.setTreeId((AnyObjectId)newTree);
        ObjectId parentId = JGitVersionStore.fromHash((NamedRef)branch, expectedHash).orElse(this.repository.resolve("refs/heads/" + branch.getName()));
        if (parentId != null) {
            commitBuilder.setParentId((AnyObjectId)parentId);
        }
        ObjectId newCommitId = inserter.insert(commitBuilder);
        inserter.flush();
        this.updateRef((NamedRef)branch, newCommitId, expectedHash, force);
    }

    private void updateRef(NamedRef ref, Hash targetHash, Optional<Hash> expectedHash, boolean force) throws IOException, ReferenceConflictException, ReferenceNotFoundException {
        ObjectId target = this.repository.resolve(targetHash.asString());
        if (target == null) {
            throw ReferenceNotFoundException.forReference((Ref)ref);
        }
        this.updateRef(ref, target, expectedHash, force);
    }

    private void updateRef(NamedRef ref, ObjectId target, Optional<Hash> expectedHash, boolean force) throws IOException, ReferenceConflictException {
        RefUpdate.Result result;
        RefUpdate updateBranch = this.repository.updateRef((ref instanceof TagName ? "refs/tags/" : "refs/heads/") + ref.getName());
        updateBranch.setNewObjectId((AnyObjectId)target);
        JGitVersionStore.fromHash(ref, expectedHash).ifPresent(arg_0 -> ((RefUpdate)updateBranch).setExpectedOldObjectId(arg_0));
        RefUpdate.Result result2 = result = force ? updateBranch.forceUpdate() : updateBranch.update();
        if (!(result.equals((Object)RefUpdate.Result.NEW) || result.equals((Object)RefUpdate.Result.FAST_FORWARD) || result.equals((Object)RefUpdate.Result.FORCED))) {
            throw new ReferenceConflictException(String.format("result did not complete for update ref on %s with state %s", ref, result));
        }
    }

    private Optional<ObjectId> tryTwoWayMerge(ObjectId treeId, ObjectId newTreeId, ObjectInserter inserter, ObjectId version, List<String> unchanged) throws IOException {
        inserter.flush();
        TwoWayMerger merger = new TwoWayMerger(this.repository, unchanged);
        merger.setBase((AnyObjectId)version);
        boolean ok = merger.merge(new AnyObjectId[]{treeId, newTreeId});
        return ok ? Optional.of(merger.getResultTreeId()) : Optional.empty();
    }

    private CommitBuilder fromUser(METADATA commitMeta, boolean empty) {
        PersonIdent person;
        CommitBuilder commitBuilder = new CommitBuilder();
        long updateTime = empty ? 0L : ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli();
        try {
            UserConfig config = (UserConfig)SystemReader.getInstance().getUserConfig().get(UserConfig.KEY);
            person = new PersonIdent(config.getAuthorName(), config.getAuthorEmail(), updateTime, 0);
        }
        catch (IOException | ConfigInvalidException e) {
            person = new PersonIdent(System.getProperty("user.name"), "me@example.com");
        }
        if (commitMeta != null) {
            commitBuilder.setMessage(this.storeWorker.getMetadataSerializer().toBytes(commitMeta).toStringUtf8());
        } else {
            commitBuilder.setMessage("none");
        }
        commitBuilder.setAuthor(person);
        commitBuilder.setCommitter(person);
        return commitBuilder;
    }

    private static Optional<ObjectId> fromHash(NamedRef ref, Optional<Hash> s) throws ReferenceConflictException {
        try {
            return s.map(Hash::asString).map(ObjectId::fromString);
        }
        catch (InvalidObjectIdException e) {
            throw ReferenceConflictException.forReference((NamedRef)ref, s, Optional.empty(), (Throwable)e);
        }
    }

    private static <T> Spliterator<T> skipLastElement(final Spliterator<T> src) {
        final ArrayDeque pending = new ArrayDeque(1);
        return new Spliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                boolean succeed = true;
                while (pending.size() < 2 && succeed) {
                    succeed = src.tryAdvance(pending::add);
                }
                if (pending.size() > 1) {
                    action.accept(pending.remove());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return src.estimateSize() - 1L;
            }

            @Override
            public int characteristics() {
                return src.characteristics();
            }
        };
    }

    static String stringFromKey(Key key) {
        return key.getElements().stream().map(k -> {
            try {
                return URLEncoder.encode(k, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("Unable to encode key %s", key), e);
            }
        }).collect(Collectors.joining(SLASH));
    }

    static Key keyFromUrlString(String path) {
        return Key.of((String[])((String[])StreamSupport.stream(Arrays.spliterator(path.split(SLASH)), false).map(x -> {
            try {
                return URLDecoder.decode(x, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(String.format("Unable to decode string %s", x), e);
            }
        }).toArray(String[]::new)));
    }

    private static String refName(Ref ref) {
        String hashName;
        if (ref instanceof BranchName) {
            hashName = ((BranchName)ref).getName();
        } else if (ref instanceof TagName) {
            hashName = ((TagName)ref).getName();
        } else if (ref instanceof Hash) {
            hashName = ((Hash)ref).asString();
        } else {
            throw new IllegalStateException(String.format("unknown ref type: %s", ref));
        }
        return hashName;
    }

    private static ByteString getTable(TreeWalk treeWalk, Repository repository) throws IOException {
        return JGitVersionStore.getTable(treeWalk, repository, 0);
    }

    private static ByteString getTable(TreeWalk treeWalk, Repository repository, int id) throws IOException {
        ObjectId objectId = treeWalk.getObjectId(id);
        ObjectLoader loader = repository.open((AnyObjectId)objectId);
        byte[] object = loader.getBytes();
        return ByteString.copyFrom((byte[])object);
    }

    public Stream<Diff<TABLE>> getDiffs(Ref from, Ref to) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

