/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.jgit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.jgit.JGitVersionStore;

public class TreeBuilder {
    public static <TABLE, TABLE_VALUE extends Enum<TABLE_VALUE>> ObjectId commitObjects(List<Operation<TABLE>> ops, Repository repository, SerializerWithPayload<TABLE, TABLE_VALUE> serializer, ObjectId emptyObjectId) throws IOException {
        ObjectInserter inserter = repository.newObjectInserter();
        DirCache dc = DirCache.newInCore();
        DirCacheBuilder builder = dc.builder();
        for (Operation<TABLE> op : ops) {
            FileMode fileMode;
            ObjectId objectId;
            if (op instanceof Unchanged) continue;
            if (op instanceof Delete) {
                objectId = emptyObjectId;
                fileMode = FileMode.GITLINK;
            } else if (op instanceof Put) {
                byte[] data = serializer.toBytes(((Put)op).getValue()).toByteArray();
                objectId = inserter.insert(3, data);
                fileMode = FileMode.REGULAR_FILE;
            } else {
                throw new IllegalStateException(String.format("unknown operation type %s", op));
            }
            String name = JGitVersionStore.stringFromKey(op.getKey());
            DirCacheEntry dce = new DirCacheEntry(name);
            dce.setObjectId((AnyObjectId)objectId);
            dce.setFileMode(fileMode);
            builder.add(dce);
        }
        builder.finish();
        ObjectId objectId = dc.writeTree(inserter);
        inserter.flush();
        return objectId;
    }

    public static ObjectId merge(ObjectId currentTree, ObjectId newTree, Repository repository) throws IOException {
        NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(repository);
        treeWalk.addTree((AnyObjectId)currentTree);
        treeWalk.addTree((AnyObjectId)newTree);
        treeWalk.setRecursive(false);
        DirCache dc = DirCache.newInCore();
        DirCacheBuilder builder = dc.builder();
        TreeBuilder.diff((TreeWalk)treeWalk, builder);
        builder.finish();
        ObjectInserter inserter = repository.newObjectInserter();
        ObjectId objectId = dc.writeTree(inserter);
        inserter.flush();
        return objectId;
    }

    public static ObjectId transplant(Hash hash, Repository repository) throws IOException, ReferenceNotFoundException {
        ObjectId treeId = repository.resolve(hash.asString() + "^{tree}");
        if (treeId == null) {
            throw ReferenceNotFoundException.forReference((Ref)hash);
        }
        RevCommit commit = RevCommit.parse((byte[])repository.open((AnyObjectId)repository.resolve(hash.asString() + "^{commit}")).getBytes());
        String parentTreeName = commit.getParent(0).name();
        ObjectId parentTree = repository.resolve(parentTreeName + "^{tree}");
        return TreeBuilder.merge(parentTree, treeId, repository);
    }

    private static void diff(TreeWalk treeWalk, DirCacheBuilder builder) throws IOException {
        while (treeWalk.next()) {
            DirCacheEntry dce;
            ObjectId current = treeWalk.getObjectId(0);
            ObjectId next = treeWalk.getObjectId(1);
            if (treeWalk.isSubtree()) {
                if (ObjectId.isEqual((AnyObjectId)next, (AnyObjectId)ObjectId.zeroId())) {
                    builder.addTree(treeWalk.getRawPath(), 0, treeWalk.getObjectReader(), (AnyObjectId)treeWalk.getObjectId(0));
                    continue;
                }
                if (ObjectId.isEqual((AnyObjectId)current, (AnyObjectId)ObjectId.zeroId())) {
                    builder.addTree(treeWalk.getRawPath(), 0, treeWalk.getObjectReader(), (AnyObjectId)treeWalk.getObjectId(1));
                    continue;
                }
                if (treeWalk.idEqual(0, 1)) continue;
                treeWalk.enterSubtree();
                continue;
            }
            if (ObjectId.isEqual((AnyObjectId)next, (AnyObjectId)ObjectId.zeroId()) && treeWalk.idEqual(0, 1)) continue;
            if (ObjectId.isEqual((AnyObjectId)next, (AnyObjectId)ObjectId.zeroId())) {
                dce = new DirCacheEntry(treeWalk.getRawPath());
                dce.setObjectId((AnyObjectId)treeWalk.getObjectId(0));
                dce.setFileMode(treeWalk.getFileMode(0));
                builder.add(dce);
                continue;
            }
            if (!ObjectId.isEqual((AnyObjectId)current, (AnyObjectId)ObjectId.zeroId()) && treeWalk.idEqual(0, 1)) continue;
            dce = new DirCacheEntry(treeWalk.getRawPath());
            if (treeWalk.getFileMode(1).equals(FileMode.GITLINK)) {
                dce.setObjectId((AnyObjectId)ObjectId.zeroId());
            } else {
                dce.setObjectId((AnyObjectId)treeWalk.getObjectId(1));
            }
            dce.setFileMode(treeWalk.getFileMode(1));
            builder.add(dce);
        }
    }

    private static List<String> testRead(ObjectId objectId, Repository repository) throws IOException {
        TreeWalk tw = new TreeWalk(repository);
        tw.setRecursive(true);
        tw.addTree((AnyObjectId)objectId);
        ArrayList<String> fields = new ArrayList<String>();
        while (tw.next()) {
            fields.add(tw.getPathString());
        }
        return fields;
    }

    private static Map<String, String> testReadAll(ObjectId objectId, Repository repository) throws IOException {
        TreeWalk tw = new TreeWalk(repository);
        tw.setRecursive(true);
        tw.addTree((AnyObjectId)objectId);
        HashMap<String, String> fields = new HashMap<String, String>();
        while (tw.next()) {
            fields.put(tw.getPathString(), new String(repository.open((AnyObjectId)tw.getObjectId(0)).getBytes()));
        }
        return fields;
    }
}

