/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.jgit;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;

class TwoWayMerger
extends ThreeWayMerger {
    private static final int T_BASE = 0;
    private static final int T_OURS = 1;
    private static final int T_THEIRS = 2;
    private final NameConflictTreeWalk tw;
    private final Set<String> unchanged;
    private final DirCache cache;
    private DirCacheBuilder builder;
    private ObjectId resultTree;

    TwoWayMerger(Repository local, List<String> unchanged) {
        super(local);
        this.tw = new NameConflictTreeWalk(local, this.reader);
        this.unchanged = new HashSet<String>(unchanged);
        this.cache = DirCache.newInCore();
    }

    protected boolean mergeImpl() throws IOException {
        this.tw.addTree(this.mergeBase());
        this.tw.addTree((AnyObjectId)this.sourceTrees[0]);
        this.tw.addTree((AnyObjectId)this.sourceTrees[1]);
        boolean hasConflict = false;
        this.builder = this.cache.builder();
        while (this.tw.next()) {
            if (this.tw.idEqual(1, 2) && this.tw.idEqual(0, 1)) {
                this.add(1, 0);
                continue;
            }
            if (this.unchanged.contains(this.tw.getPathString()) && !this.tw.idEqual(0, 1)) {
                this.add(0, 1);
                hasConflict = true;
                continue;
            }
            if (this.tw.isSubtree()) {
                this.tw.enterSubtree();
                continue;
            }
            if (!this.tw.idEqual(1, 2)) {
                if (this.tw.idEqual(0, 1)) {
                    if (ObjectId.zeroId().equals((AnyObjectId)this.tw.getObjectId(2)) && !FileMode.GITLINK.equals(this.tw.getRawMode(2))) {
                        this.add(1, 0);
                        continue;
                    }
                    this.add(2, 0);
                    continue;
                }
                if (this.tw.idEqual(0, 2)) {
                    this.add(1, 0);
                    continue;
                }
                this.add(0, 1);
                hasConflict = true;
                continue;
            }
            this.add(0, 1);
            hasConflict = true;
        }
        this.builder.finish();
        this.builder = null;
        if (hasConflict) {
            return false;
        }
        try {
            ObjectInserter odi = this.getObjectInserter();
            this.resultTree = this.cache.writeTree(odi);
            odi.flush();
            return true;
        }
        catch (UnmergedPathException upe) {
            this.resultTree = null;
            return false;
        }
    }

    private void add(int tree, int stage) throws IOException {
        AbstractTreeIterator i = this.getTree(tree);
        if (i != null) {
            if (FileMode.TREE.equals(this.tw.getRawMode(tree))) {
                this.builder.addTree(this.tw.getRawPath(), stage, this.reader, (AnyObjectId)this.tw.getObjectId(tree));
            } else if (!FileMode.GITLINK.equals(this.tw.getRawMode(tree))) {
                DirCacheEntry e = new DirCacheEntry(this.tw.getRawPath(), stage);
                e.setObjectIdFromRaw(i.idBuffer(), i.idOffset());
                e.setFileMode(this.tw.getFileMode(tree));
                this.builder.add(e);
            }
        }
    }

    private AbstractTreeIterator getTree(int tree) {
        return this.tw.getTree(tree, AbstractTreeIterator.class);
    }

    public ObjectId getResultTreeId() {
        return this.resultTree;
    }
}

