/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import org.projectnessie.versioned.transfer.ImmutableImportResult;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.files.ImportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

abstract class ImportCommon {
    final ImportFileSupplier importFiles;
    final TransferTypes.ExportMeta exportMeta;
    final NessieImporter importer;

    ImportCommon(TransferTypes.ExportMeta exportMeta, NessieImporter importer) {
        this.importFiles = importer.importFileSupplier();
        this.exportMeta = exportMeta;
        this.importer = importer;
    }

    ImportResult importRepo() throws IOException {
        TransferTypes.HeadsAndForks headsAndForks = this.importer.loadHeadsAndForks();
        this.importer.progressListener().progress(ProgressEvent.START_PREPARE);
        this.prepareRepository();
        this.importer.progressListener().progress(ProgressEvent.END_PREPARE);
        this.importer.progressListener().progress(ProgressEvent.START_COMMITS);
        long commitCount = this.importCommits();
        this.importer.progressListener().progress(ProgressEvent.END_COMMITS);
        this.importer.progressListener().progress(ProgressEvent.START_NAMED_REFERENCES);
        long namedReferenceCount = this.importNamedReferences();
        this.importer.progressListener().progress(ProgressEvent.END_NAMED_REFERENCES);
        this.importer.progressListener().progress(ProgressEvent.FINISHED);
        return ImmutableImportResult.builder().exportMeta(this.exportMeta).headsAndForks(headsAndForks).importedCommitCount(commitCount).importedReferenceCount(namedReferenceCount).build();
    }

    abstract void prepareRepository() throws IOException;

    abstract long importNamedReferences() throws IOException;

    abstract long importCommits() throws IOException;
}

