/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.CommitMetaSerializer;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.transfer.BatchWriter;
import org.projectnessie.versioned.transfer.ImportCommon;
import org.projectnessie.versioned.transfer.NessieImporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ImportDatabaseAdapter
extends ImportCommon {
    ImportDatabaseAdapter(TransferTypes.ExportMeta exportMeta, NessieImporter importer) {
        super(exportMeta, importer);
        Preconditions.checkState((exportMeta.getVersion() == TransferTypes.ExportVersion.V1 ? 1 : 0) != 0, (String)"This Nessie-version version does not support importing a %s (%s) export", (Object)exportMeta.getVersion().name(), (int)exportMeta.getVersionValue());
    }

    @Override
    void prepareRepository() {
        DatabaseAdapter databaseAdapter = Objects.requireNonNull(this.importer.databaseAdapter());
        databaseAdapter.eraseRepo();
        databaseAdapter.initializeRepo("main");
        try {
            databaseAdapter.delete((NamedRef)BranchName.of((String)"main"), Optional.empty());
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    long importNamedReferences() throws IOException {
        long namedReferenceCount = 0L;
        for (String fileName : this.exportMeta.getNamedReferencesFilesList()) {
            InputStream input = this.importFiles.newFileInput(fileName);
            try {
                TransferTypes.NamedReference namedReference;
                while ((namedReference = TransferTypes.NamedReference.parseDelimitedFrom((InputStream)input)) != null) {
                    TagName ref;
                    switch (namedReference.getRefType()) {
                        case Tag: {
                            ref = TagName.of((String)namedReference.getName());
                            break;
                        }
                        case Branch: {
                            ref = BranchName.of((String)namedReference.getName());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown reference type " + namedReference);
                        }
                    }
                    try {
                        Objects.requireNonNull(this.importer.databaseAdapter()).create((NamedRef)ref, Hash.of((ByteString)namedReference.getCommitId()));
                    }
                    catch (ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    ++namedReferenceCount;
                    this.importer.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
                }
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return namedReferenceCount;
    }

    @Override
    long importCommits() throws IOException {
        long commitCount = 0L;
        int keyListDistance = Objects.requireNonNull(this.importer.databaseAdapter()).getConfig().getKeyListDistance();
        try (BatchWriter<CommitLogEntry> commitBatchWriter = BatchWriter.commitBatchWriter(this.importer.commitBatchSize(), this.importer.databaseAdapter());
             BatchWriter<ContentAttachment> attachmentsBatchWriter = BatchWriter.attachmentsBatchWriter(this.importer.attachmentBatchSize(), this.importer.databaseAdapter());){
            for (String fileName : this.exportMeta.getCommitsFilesList()) {
                InputStream input = this.importFiles.newFileInput(fileName);
                try {
                    TransferTypes.Commit commit;
                    while ((commit = TransferTypes.Commit.parseDelimitedFrom((InputStream)input)) != null) {
                        ByteString metadata;
                        try (InputStream in = commit.getMetadata().newInput();){
                            metadata = CommitMetaSerializer.METADATA_SERIALIZER.toBytes((Object)((CommitMeta)this.importer.objectMapper().readValue(in, CommitMeta.class)));
                        }
                        ImmutableCommitLogEntry.Builder logEntry = ImmutableCommitLogEntry.builder().createdTime(commit.getCreatedTimeMicros()).commitSeq(commit.getCommitSequence()).hash(Hash.of((ByteString)commit.getCommitId())).metadata(metadata).keyListDistance((int)(commit.getCommitSequence() % (long)keyListDistance)).addParents(Hash.of((ByteString)commit.getParentCommitId()));
                        commit.getAdditionalParentsList().forEach(ap -> logEntry.addAdditionalParents(Hash.of((ByteString)ap)));
                        commit.getOperationsList().forEach(op -> {
                            Key key = Key.of((List)op.getContentKeyList());
                            switch (op.getOperationType()) {
                                case Delete: {
                                    logEntry.addDeletes(key);
                                    break;
                                }
                                case Put: {
                                    try (InputStream inValue = op.getValue().newInput();){
                                        Content content = (Content)this.importer.objectMapper().readValue(inValue, Content.class);
                                        ByteString onRef = this.importer.storeWorker().toStoreOnReferenceState(content, attachmentsBatchWriter::add);
                                        logEntry.addPuts(KeyWithBytes.of((Key)key, (ContentId)ContentId.of((String)op.getContentId()), (byte)((byte)op.getPayload()), (ByteString)onRef));
                                        break;
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown operation type " + op);
                                }
                            }
                        });
                        commitBatchWriter.add((CommitLogEntry)logEntry.build());
                        ++commitCount;
                        this.importer.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
        return commitCount;
    }
}

