/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.caching;

import java.util.Arrays;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.caching.Caching;

public class Config {
    private Options<Caching.CreateOption> options;
    ConfigurationBuilder builder = new ConfigurationBuilder();
    static final Equivalence EQUIVALENCE = new Equivalence();
    static final GenericTransactionManagerLookup TM_LOOKUP = new GenericTransactionManagerLookup();

    public static Configuration uration(Options<Caching.CreateOption> options) {
        Configuration c = (Configuration)options.get((Object)Caching.CreateOption.CONFIGURATION);
        return c != null && options.size() == 1 ? c : Config.builder(options).build();
    }

    public static ConfigurationBuilder builder(Options<Caching.CreateOption> options) {
        return new Config(options).builder;
    }

    Config(Options<Caching.CreateOption> options) {
        this.options = options;
        this.builder.dataContainer().keyEquivalence((org.infinispan.commons.equivalence.Equivalence)EQUIVALENCE);
        this.read();
        this.mode();
        this.evict();
        this.expire();
        this.transact();
        this.persist();
    }

    void read() {
        Configuration c = (Configuration)this.options.get((Object)Caching.CreateOption.CONFIGURATION);
        if (c != null) {
            this.builder.read(c);
        }
    }

    void mode() {
        String m = this.options.getString((Object)Caching.CreateOption.MODE);
        if (m != null) {
            this.builder.clustering().cacheMode(CacheMode.valueOf((String)m.toUpperCase()));
        }
    }

    void evict() {
        this.builder.eviction().strategy(EvictionStrategy.valueOf((String)this.options.getString((Object)Caching.CreateOption.EVICTION).toUpperCase())).maxEntries(this.options.getInt((Object)Caching.CreateOption.MAX_ENTRIES).intValue());
    }

    void expire() {
        this.builder.expiration().maxIdle(this.options.getLong((Object)Caching.CreateOption.IDLE).longValue()).lifespan(this.options.getLong((Object)Caching.CreateOption.TTL).longValue());
    }

    void transact() {
        if (this.options.getBoolean((Object)Caching.CreateOption.TRANSACTIONAL).booleanValue()) {
            LockingMode mode = LockingMode.valueOf((String)this.options.getString((Object)Caching.CreateOption.LOCKING).toUpperCase());
            this.builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)TM_LOOKUP).lockingMode(mode).recovery().versioning().enabled(mode == LockingMode.OPTIMISTIC).scheme(VersioningScheme.SIMPLE).locking().isolationLevel(mode == LockingMode.OPTIMISTIC ? IsolationLevel.REPEATABLE_READ : IsolationLevel.READ_COMMITTED).writeSkewCheck(mode == LockingMode.OPTIMISTIC);
        } else {
            this.builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        }
    }

    void persist() {
        Object v = this.options.get((Object)Caching.CreateOption.PERSIST);
        if (v instanceof Boolean && ((Boolean)v).booleanValue()) {
            this.builder.persistence().addSingleFileStore();
        }
        if (v instanceof String) {
            this.builder.persistence().addSingleFileStore().location(v.toString());
        }
    }

    static class Equivalence
    implements org.infinispan.commons.equivalence.Equivalence<Object> {
        Equivalence() {
        }

        private static boolean isByteArray(Object obj) {
            return byte[].class == obj.getClass();
        }

        public int hashCode(Object obj) {
            if (Equivalence.isByteArray(obj)) {
                return 41 + Arrays.hashCode((byte[])obj);
            }
            return obj.hashCode();
        }

        public boolean equals(Object obj, Object otherObj) {
            if (obj == otherObj) {
                return true;
            }
            if (obj == null || otherObj == null) {
                return false;
            }
            if (Equivalence.isByteArray(obj) && Equivalence.isByteArray(otherObj)) {
                return Arrays.equals((byte[])obj, (byte[])otherObj);
            }
            return obj.equals(otherObj);
        }

        public String toString(Object obj) {
            if (Equivalence.isByteArray(obj)) {
                return Arrays.toString((byte[])obj);
            }
            return obj.toString();
        }

        public boolean isComparable(Object obj) {
            return obj instanceof Comparable;
        }

        public int compare(Object obj, Object otherObj) {
            return ((Comparable)obj).compareTo(otherObj);
        }
    }
}

