/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.caching;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.caching.CacheWithCodec;
import org.projectodd.wunderboss.caching.CacheWithExpiration;
import org.projectodd.wunderboss.caching.Caching;
import org.projectodd.wunderboss.caching.Config;
import org.projectodd.wunderboss.codecs.Codec;

public class InfinispanCaching
implements Caching {
    private final String name;
    protected final Options options;
    protected EmbeddedCacheManager manager;
    protected static final Logger log = Logger.getLogger(Caching.class);

    public InfinispanCaching(String name, Options<Caching.CreateOption> options) {
        this.name = name;
        this.options = options;
    }

    public synchronized void start() throws Exception {
        this.manager().start();
    }

    public synchronized void stop() throws Exception {
        this.manager().stop();
    }

    public boolean isRunning() {
        return this.manager().getStatus().allowInvocations();
    }

    public String name() {
        return this.name;
    }

    @Override
    public Cache find(String name) {
        Cache result = null;
        if (this.manager().isRunning(name) && !(result = this.manager().getCache(name)).getStatus().allowInvocations()) {
            result.start();
        }
        return result;
    }

    @Override
    public Cache findOrCreate(String name, Map<Caching.CreateOption, Object> options) {
        Cache result = this.find(name);
        if (result == null) {
            this.manager().defineConfiguration(name, Config.uration(this.validate(options)));
            log.info((Object)("Creating cache: " + name));
            result = this.manager().getCache(name);
        }
        return result;
    }

    @Override
    public boolean stop(String name) {
        EmbeddedCacheManager mgr = this.manager();
        boolean before = mgr.isRunning(name);
        mgr.removeCache(name);
        return before != mgr.isRunning(name);
    }

    @Override
    public Cache withCodec(Cache cache, Codec codec) {
        return codec == null ? cache : new CacheWithCodec(cache, codec);
    }

    @Override
    public Cache withExpiration(Cache cache, long ttl, long idle) {
        return new CacheWithExpiration(cache, ttl, idle);
    }

    public synchronized EmbeddedCacheManager manager() {
        if (this.manager == null) {
            this.manager = new DefaultCacheManager(Config.uration((Options<Caching.CreateOption>)this.options));
        }
        return this.manager;
    }

    protected Options<Caching.CreateOption> validate(Map<Caching.CreateOption, Object> options) {
        Options result = new Options(options);
        String mode = result.getString((Object)Caching.CreateOption.MODE);
        if (mode != null && !"LOCAL".equalsIgnoreCase(mode)) {
            log.warn((Object)"Requested mode only available in a cluster, setting to LOCAL");
            result.put((Object)Caching.CreateOption.MODE, (Object)"LOCAL");
        }
        return result;
    }
}

