/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import prompto.code.BaseCodeStore;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.Library;
import prompto.code.Module;
import prompto.code.ModuleStatus;
import prompto.code.QueryableCodeStore;
import prompto.codefactory.ModuleProcess;
import prompto.codefactory.SampleImporter;
import prompto.config.CodeFactoryConfiguration;
import prompto.config.ICodeFactoryConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IPortRangeConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.ITargetConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.server.AppServer;
import prompto.server.DataServlet;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.utils.CmdLineParser;
import prompto.utils.Logger;
import prompto.utils.ResourceUtils;

public class Application {
    static Logger logger = new Logger();
    static ICodeFactoryConfiguration config;

    public static void main(String[] args) throws Throwable {
        Application.main(args, null);
    }

    public static void main(String[] args, Mode runtimeMode) throws Throwable {
        ICodeFactoryConfiguration config = Application.loadConfiguration(args);
        config = Application.adjustConfiguration(config, runtimeMode);
        Application.main(config);
    }

    public static void main(ICodeFactoryConfiguration config) throws Throwable {
        Application.config = config;
        AppServer.main((IServerConfiguration)config, Application::init);
    }

    public static ICodeFactoryConfiguration loadConfiguration(String[] args) throws Exception {
        Map argsMap = CmdLineParser.read((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs((Map)argsMap);
        CodeFactoryConfiguration config = new CodeFactoryConfiguration(reader, argsMap);
        return (ICodeFactoryConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class, BaseCodeStore.class}));
    }

    public static ICodeFactoryConfiguration adjustConfiguration(ICodeFactoryConfiguration config, Mode runtimeMode) throws Exception {
        config = (ICodeFactoryConfiguration)config.withServerAboutToStartMethod("serverAboutToStart").withHttpConfiguration(config.getHttpConfiguration().withWelcomePage("/projects/index.page").withSendsXAuthorization(true)).withApplicationName("CodeFactory").withApplicationVersion(PromptoVersion.LATEST).withResourceURLs(Application.getResourceURLs());
        if (runtimeMode != null) {
            config = (ICodeFactoryConfiguration)config.withRuntimeMode(runtimeMode);
        }
        return config;
    }

    private static void init(ICodeFactoryConfiguration config) {
        Application.initDataServletStores(config);
        Application.initModuleProcessPortRange(config);
    }

    private static void initModuleProcessPortRange(ICodeFactoryConfiguration config) {
        try {
            IPortRangeConfiguration portRange;
            ITargetConfiguration target = config.getTargetConfiguration();
            if (target != null && (portRange = target.getPortRangeConfiguration()) != null) {
                logger.info(() -> "Target port range is " + portRange.getMinPort() + " to " + portRange.getMaxPort());
                ModuleProcess.portRangeConfiguration = portRange;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void initDataServletStores(ICodeFactoryConfiguration config) {
        try {
            HashMap<String, IStore> stores = new HashMap<String, IStore>();
            IStore store = Application.fetchLoginStore(config);
            if (store != null) {
                stores.put("LOGIN", store);
            }
            if ((store = DataStore.getInstance()) != null) {
                stores.put("APPS", store);
            }
            if ((store = Application.readTargetStoreConfiguration(config)) != null) {
                stores.put("DATA", store);
            }
            DataServlet.setStores(stores);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static IStore readTargetStoreConfiguration(ICodeFactoryConfiguration config) throws Throwable {
        ITargetConfiguration target = config.getTargetConfiguration();
        return target == null ? null : Application.newStore(target.getDataStoreConfiguration());
    }

    public static IStore fetchLoginStore(ICodeFactoryConfiguration config) throws Throwable {
        IAuthenticationConfiguration auth = config.getHttpConfiguration().getAuthenticationConfiguration();
        return auth == null ? null : Application.fetchLoginStore(auth);
    }

    private static IStore fetchLoginStore(IAuthenticationConfiguration config) throws Throwable {
        IAuthenticationSourceConfiguration source = config.getAuthenticationSourceConfiguration();
        if (source instanceof IStoredAuthenticationSourceConfiguration) {
            return Application.newStore(((IStoredAuthenticationSourceConfiguration)source).getStoreConfiguration());
        }
        return null;
    }

    private static IStore newStore(IStoreConfiguration config) throws Throwable {
        if (config == null) {
            return null;
        }
        IStoreFactory factory = IStoreFactory.newStoreFactory((String)config.getFactory());
        return factory.newStore(config);
    }

    private static URL[] getResourceURLs() {
        Collection urls = Libraries.getPromptoLibraries((Class[])new Class[]{BaseCodeStore.class, Application.class});
        return urls.toArray(new URL[urls.size()]);
    }

    public static void createLibraries() {
        try {
            ICodeStore codeStore = Application.codeStoreUsingDataStore();
            Application.createResourceLibraries(codeStore, "thesaurus/", "react-bootstrap-3/", "react-file-uploader/");
            if (Application.isSeedDataStore()) {
                Application.createSeedLibraries(codeStore);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createResourceLibraries(ICodeStore codeStore, String ... resources) throws Exception {
        for (String resource : resources) {
            Application.createResourceLibrary(codeStore, resource);
        }
    }

    private static void createResourceLibrary(ICodeStore codeStore, String resource) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("libraries/" + resource);
        Application.doImportModule(codeStore, url);
    }

    private static ICodeStore codeStoreUsingDataStore() {
        ICodeStore runtime = ImmutableCodeStore.bootstrapRuntime(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class}));
        return new QueryableCodeStore(DataStore.getInstance(), runtime, null, null, null, new URL[0]);
    }

    private static void doImportModule(ICodeStore codeStore, URL url) throws Exception {
        SampleImporter importer = new SampleImporter(url);
        importer.importModule(codeStore);
    }

    public static void importSamples(String root) throws IOException {
        Collection samples = ResourceUtils.listResourcesAt((String)root, null);
        samples.forEach(Application::importSample);
    }

    public static void importSample(String name) {
        Application.importSample(Thread.currentThread().getContextClassLoader().getResource(name));
    }

    public static void importSample(URL sample) {
        try {
            ICodeStore codeStore = Application.codeStoreUsingDataStore();
            Application.doImportModule(codeStore, sample);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createSeedLibraries(ICodeStore codeStore) throws Exception {
        PromptoVersion version = PromptoVersion.parse((String)"1.0.0.0");
        Application.createSeedLibrary(codeStore, "CodeStore", "Code store model", version, "libraries/CodeStore.pec", new Dependency[0]);
        Application.createSeedLibrary(codeStore, "AppStore", "App store model", version, "libraries/AppStore.pec", new Dependency("CodeStore", version));
    }

    private static void createSeedLibrary(ICodeStore codeStore, String name, String description, PromptoVersion version, String resource, Dependency ... dependencies) throws Exception {
        Library library = new Library();
        library.setName(name);
        library.setDescription(description);
        library.setVersion(version);
        library.setModuleStatus(ModuleStatus.PROVIDED);
        if (dependencies != null && dependencies.length > 0) {
            library.setDependencies(Arrays.asList(dependencies));
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        SampleImporter importer = new SampleImporter((Module)library, url);
        importer.importModule(codeStore);
    }

    private static boolean isSeedDataStore() {
        return config.getDataStoreConfiguration().getDbName().equals("tools");
    }
}

