/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import prompto.code.Batch;
import prompto.code.Dependency;
import prompto.code.Module;
import prompto.code.ModuleStatus;
import prompto.code.Service;
import prompto.code.WebLibrary;
import prompto.intrinsic.PromptoVersion;

public class ModulePopulator {
    public static ModulePopulator forType(Module module) throws Exception {
        String className = ModulePopulator.class.getName() + "$" + module.getType().getModuleClass().getSimpleName() + "Populator";
        Class<?> klass = Class.forName(className);
        return (ModulePopulator)klass.newInstance();
    }

    public void populate(Module module, JsonNode descriptor) {
        module.setName(this.readText(descriptor, "name"));
        module.setVersion(PromptoVersion.parse((String)this.readText(descriptor, "version")));
        module.setDescription(this.readText(descriptor, "description"));
        String value = this.readText(descriptor, "moduleStatus");
        ModuleStatus moduleStatus = value == null ? ModuleStatus.PROVIDED : ModuleStatus.valueOf((String)value);
        module.setModuleStatus(moduleStatus);
        JsonNode dependencies = descriptor.get("dependencies");
        if (dependencies != null) {
            module.setDependencies(this.populateDependencies(dependencies));
        }
    }

    protected String readText(JsonNode descriptor, String fieldName) {
        JsonNode child = descriptor.get(fieldName);
        if (child == null) {
            return null;
        }
        return child.asText();
    }

    protected List<Dependency> populateDependencies(JsonNode descriptor) {
        ArrayList<Dependency> items = new ArrayList<Dependency>();
        for (JsonNode node : descriptor) {
            Dependency item = new Dependency();
            item.setName(this.readText(node, "name"));
            item.setVersion(PromptoVersion.parse((String)this.readText(node, "version")));
            items.add(item);
        }
        return items;
    }

    static class WebSitePopulator
    extends ServicePopulator {
        WebSitePopulator() {
        }
    }

    static class ServicePopulator
    extends ModulePopulator {
        ServicePopulator() {
        }

        @Override
        public void populate(Module module, JsonNode descriptor) {
            super.populate(module, descriptor);
            ((Service)module).setServerAboutToStartMethod(this.readText(descriptor, "serverAboutToStartMethod"));
        }
    }

    static class BatchPopulator
    extends ApplicationPopulator {
        BatchPopulator() {
        }

        @Override
        public void populate(Module module, JsonNode descriptor) {
            super.populate(module, descriptor);
            ((Batch)module).setStartMethod(this.readText(descriptor, "startMethod"));
        }
    }

    static abstract class ApplicationPopulator
    extends ModulePopulator {
        ApplicationPopulator() {
        }
    }

    static class WebLibraryPopulator
    extends LibraryPopulator {
        WebLibraryPopulator() {
        }

        @Override
        public void populate(Module module, JsonNode descriptor) {
            super.populate(module, descriptor);
            WebLibrary library = (WebLibrary)module;
            library.setWidgetLibrary(this.readText(descriptor, "widgetLibrary"));
            library.setHtmlEngine(this.readText(descriptor, "htmlEngine"));
            library.setUIFramework(this.readText(descriptor, "uiFramework"));
            this.setResource(descriptor, "nativeResource", library.getName(), arg_0 -> ((WebLibrary)library).setNativeResource(arg_0));
            this.setResource(descriptor, "stubResource", library.getName(), arg_0 -> ((WebLibrary)library).setStubResource(arg_0));
        }

        void setResource(JsonNode descriptor, String fieldName, String moduleName, Consumer<String> setter) {
            String resourceName = this.readText(descriptor, fieldName);
            if (resourceName != null) {
                String fullName = moduleName.toLowerCase().replaceAll(" ", "-") + "/" + resourceName;
                setter.accept(fullName);
            }
        }
    }

    static class ThesaurusPopulator
    extends LibraryPopulator {
        ThesaurusPopulator() {
        }
    }

    static class LibraryPopulator
    extends ModulePopulator {
        LibraryPopulator() {
        }
    }
}

