/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.codefactory.YamlConfigBuilder;
import prompto.config.IPortRangeConfiguration;
import prompto.config.StoredRecordConfigurationReader;
import prompto.config.auth.CodeStoreAuthenticationConfiguration;
import prompto.runtime.Mode;
import prompto.server.AppServer;
import prompto.server.PromptoServlet;
import prompto.store.DataStore;
import prompto.store.IStored;
import prompto.utils.Logger;
import prompto.utils.SocketUtils;
import prompto.value.IValue;

public class ModuleProcess {
    static Logger logger = new Logger();
    static Map<Object, ModuleProcess> modules = new HashMap<Object, ModuleProcess>();
    static IPortRangeConfiguration portRangeConfiguration = IPortRangeConfiguration.ANY_PORT;
    IStored stored;
    boolean debug;
    int port;
    Process process;
    private static final Pattern splitter;
    private static Set<String> relevantArgFullNames;
    private static List<String> relevantArgStartNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDownAll() {
        logger.info(() -> "Shutting down module servers...");
        Map<Object, ModuleProcess> map = modules;
        synchronized (map) {
            ArrayList<ModuleProcess> values = new ArrayList<ModuleProcess>(modules.values());
            modules.clear();
            values.forEach(m -> m.shutDown());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown(Object dbId) {
        Map<Object, ModuleProcess> map = modules;
        synchronized (map) {
            try {
                ModuleProcess module;
                if (dbId instanceof IValue) {
                    dbId = ((IValue)dbId).getStorableData();
                }
                if ((module = modules.remove(dbId)) != null) {
                    module.shutDown();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long launchIfNeeded(Object dbId, String action) {
        Map<Object, ModuleProcess> map = modules;
        synchronized (map) {
            try {
                ModuleProcess module;
                if (dbId instanceof IValue) {
                    dbId = ((IValue)dbId).getStorableData();
                }
                if ((module = modules.get(dbId)) != null && !module.process.isAlive()) {
                    module = null;
                }
                if ("READ".equals(action)) {
                    return module == null ? new Long(0L) : new Long(module.port);
                }
                boolean debug = "DEBUG".equals(action);
                if (module != null && debug != module.isDebug()) {
                    ModuleProcess.shutDown(dbId);
                    module = null;
                }
                if (module != null && !module.process.isAlive()) {
                    module = null;
                }
                if (module == null) {
                    module = ModuleProcess.createModuleProcess(dbId, debug);
                    if (module != null) {
                        modules.put(dbId, module);
                    } else {
                        logger.warn(() -> "Remote server failed to start!");
                        return -1L;
                    }
                }
                return new Long(module.port);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return -1L;
            }
        }
    }

    private static ModuleProcess createModuleProcess(Object dbId, boolean debug) throws Throwable {
        IStored stored = DataStore.getInstance().fetchUnique(dbId);
        if (stored == null) {
            return null;
        }
        ModuleProcess module = new ModuleProcess(stored, debug);
        module.start();
        return module.process.isAlive() ? module : null;
    }

    public ModuleProcess(IStored stored, boolean debug) {
        this.stored = stored;
        this.debug = debug;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void start() throws Throwable {
        this.port = SocketUtils.findAvailablePortInRange((int)portRangeConfiguration.getMinPort(), (int)portRangeConfiguration.getMaxPort());
        String[] args = this.buildCommandLineArgs();
        ProcessBuilder builder = new ProcessBuilder(args).redirectError(ProcessBuilder.Redirect.INHERIT).directory(Files.createTempDirectory("prompto-" + this.getModuleName() + "-", new FileAttribute[0]).toFile());
        this.process = OutStream.waitForServerReadiness(builder);
    }

    String getModuleName() {
        return this.stored.getData("name").toString();
    }

    String getModuleVersion() {
        return this.stored.getData("version").toString();
    }

    String getStartMethod() {
        Object value = this.stored.getData("startMethod");
        return value == null ? null : value.toString();
    }

    String getServerAboutToStartMethod() {
        Object value = this.stored.getData("serverAboutToStartMethod");
        return value == null ? null : value.toString();
    }

    public void shutDown() {
        try {
            this.process.destroyForcibly();
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String[] buildCommandLineArgs() throws Throwable {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("java");
        String debugPort = System.getenv("PROMPTO_DEBUG_TARGET_PORT");
        if (debugPort != null && !debugPort.isEmpty()) {
            cmds.add("-Xdebug");
            cmds.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
        }
        this.addClassPathArgs(cmds);
        cmds.add(AppServer.class.getName());
        this.addPromptoArgs(cmds);
        return cmds.toArray(new String[cmds.size()]);
    }

    private void addPromptoArgs(List<String> args) throws Throwable {
        if (this.isYamlConfig()) {
            this.addPromptoYamlConfigArgs(args);
        } else {
            this.addPromptoCommandLineArgs(args);
        }
    }

    private void addPromptoCommandLineArgs(List<String> cmds) {
        this.addRelevantCmdLineArgs(cmds);
        this.addSpecificCmdLineArgs(cmds);
    }

    private void addSpecificCmdLineArgs(List<String> cmds) {
        cmds.add("-http-port");
        cmds.add(String.valueOf(this.port));
        cmds.add("-applicationName");
        cmds.add(this.getModuleName());
        cmds.add("-applicationVersion");
        cmds.add(this.getModuleVersion());
        String origin = (String)PromptoServlet.REGISTERED_ORIGIN.get();
        if (origin != null) {
            cmds.add("-http-allowedOrigins");
            cmds.add(origin);
            cmds.add("-http-allowsXAuthorization");
            cmds.add("true");
        }
    }

    private boolean isYamlConfig() {
        String cmdLine = System.getProperty("sun.java.command").toString();
        return cmdLine.contains("-yamlConfigFile");
    }

    private void addPromptoYamlConfigArgs(List<String> cmds) throws Throwable {
        File targetFile = this.createTempYamlFile();
        cmds.add("-yamlConfigFile");
        cmds.add(targetFile.getAbsolutePath());
        YamlConfigBuilder builder = new YamlConfigBuilder(this, this.locateYamlConfigFile(), targetFile);
        builder.build();
    }

    private boolean hasAuthenticationSettings() {
        return this.stored.hasData("authenticationSettings");
    }

    YamlMapping authenticationSettingsToYaml() throws Throwable {
        if (this.hasAuthenticationSettings()) {
            StoredRecordConfigurationReader reader = new StoredRecordConfigurationReader(DataStore.getInstance(), this.stored);
            CodeStoreAuthenticationConfiguration config = new CodeStoreAuthenticationConfiguration(reader);
            return config.toYaml(Mode.DEVELOPMENT);
        }
        return null;
    }

    private File createTempYamlFile() throws IOException {
        return File.createTempFile("config-", ".yml");
    }

    File locateYamlConfigFile() throws Exception {
        String location = ModuleProcess.locateYamlConfigFilePath();
        return new File(location);
    }

    private void addClassPathArgs(List<String> cmds) throws URISyntaxException {
        if (this.isRunningFromJar()) {
            this.addServerJarArgs(cmds);
        } else {
            this.addImplicitClassPathArgs(cmds);
        }
    }

    private boolean isRunningFromJar() {
        String[] args = System.getProperty("sun.java.command").split(" ");
        return args[0].toLowerCase().endsWith(".jar");
    }

    private void addImplicitClassPathArgs(List<String> cmds) {
        cmds.add("-cp");
        String classPaths = Stream.of(System.getProperty("java.class.path").toString().split(":")).filter(s -> !s.startsWith(this.getClass().getPackage().getName())).collect(Collectors.joining(":"));
        cmds.add(classPaths);
    }

    private void addServerJarArgs(List<String> cmds) throws URISyntaxException {
        URL thisJar = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File parent = Paths.get(thisJar.toURI()).getParent().toFile();
        for (File file : parent.listFiles()) {
            String name = file.getName();
            if (!name.startsWith("Server-") || !name.endsWith(".jar") || name.contains("-tests.")) continue;
            cmds.add("-jar");
            cmds.add(file.getAbsolutePath());
            return;
        }
        throw new IllegalStateException("Could not locate Server jar in " + System.getProperty("user.dir") + "!");
    }

    private static String locateYamlConfigFilePath() {
        return ModuleProcess.extractCmdLineArgument("-yamlConfigFile");
    }

    public static String extractCmdLineArgument(String argument) {
        return ModuleProcess.extractCmdLineArgument(System.getProperty("sun.java.command"), argument);
    }

    public static String extractCmdLineArgument(String cmdLine, String argument) {
        Matcher matcher = splitter.matcher(cmdLine);
        while (matcher.find()) {
            String key = matcher.group();
            if (!argument.equals(key) || !matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    private void addRelevantCmdLineArgs(List<String> cmds) {
        String cmdLine = System.getProperty("sun.java.command").toString();
        Matcher matcher = splitter.matcher(cmdLine);
        while (matcher.find()) {
            String key = matcher.group();
            if (!this.isRelevantCmdLineArg(key) || !matcher.find()) continue;
            cmds.add(key);
            cmds.add(matcher.group());
        }
    }

    private boolean isRelevantCmdLineArg(String key) {
        if (relevantArgFullNames.contains(key)) {
            return true;
        }
        return relevantArgStartNames.stream().anyMatch(key::startsWith);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ModuleProcess::shutDownAll));
        splitter = Pattern.compile("[^\\s]*\"(\\\\+\"|[^\"])*?\"|[^\\s]*'(\\\\+'|[^'])*?'|(\\\\\\s|[^\\s])+", 8);
        relevantArgFullNames = new HashSet<String>(Arrays.asList("-addOnURLs"));
        relevantArgStartNames = Arrays.asList("-codeStore-", "-dataStore-");
    }

    static class OutStream {
        ProcessBuilder builder;
        Process process;

        static Process waitForServerReadiness(ProcessBuilder builder) throws IOException, InterruptedException {
            OutStream out = new OutStream(builder);
            out.waitForServerReadiness();
            out.startForwarding();
            return out.process;
        }

        OutStream(ProcessBuilder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Process waitForServerReadiness() throws InterruptedException, IOException {
            logger.info(() -> "Starting: " + this.builder.command().toString());
            Object ready = new Object();
            this.process = this.builder.start();
            Thread reader = new Thread(() -> {
                try {
                    this.readLoop((data, size) -> {
                        System.out.write((byte[])data, 0, (int)size);
                        return new String((byte[])data, 0, (int)size).contains("Web server successfully started on port ");
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                finally {
                    Object object2 = ready;
                    synchronized (object2) {
                        ready.notify();
                    }
                }
            });
            reader.start();
            Object object = ready;
            synchronized (object) {
                ready.wait();
            }
            return this.process;
        }

        void startForwarding() {
            Thread reader = new Thread(() -> {
                try {
                    this.readLoop((data, size) -> {
                        System.out.write((byte[])data, 0, (int)size);
                        return false;
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            });
            reader.start();
        }

        private void readLoop(BiFunction<byte[], Integer, Boolean> hook) throws IOException {
            int read;
            InputStream input = this.process.getInputStream();
            byte[] data = new byte[65536];
            while (this.process.isAlive() && (read = input.read(data)) >= 0 && (read <= 0 || !hook.apply(data, read).booleanValue())) {
            }
        }
    }
}

