/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.TextResource;
import prompto.code.WebLibrary;
import prompto.codefactory.ModulePopulator;
import prompto.intrinsic.PromptoVersion;
import prompto.utils.Logger;
import prompto.utils.StreamUtils;
import prompto.value.ImageValue;

public class SampleImporter {
    static Logger logger = new Logger();
    Module module;
    PromptoVersion migrateFrom;
    URL imageResource;
    URL codeResource;
    URL nativeResource;
    URL stubResource;

    public SampleImporter(Module module, URL codeResource) {
        this.module = module;
        this.codeResource = codeResource;
    }

    public SampleImporter(String resourcePath) {
        this(Thread.currentThread().getContextClassLoader().getResource(resourcePath));
    }

    public SampleImporter(URL url) {
        try {
            JsonNode descriptor = this.readDescriptor(url);
            Module module = this.newModule(descriptor);
            this.populateModule(module, descriptor);
            this.populateResources(url, descriptor);
            this.populateMigrateFrom(descriptor);
            this.module = module;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void populateMigrateFrom(JsonNode descriptor) {
        if (descriptor.get("migrateFrom") != null) {
            this.migrateFrom = PromptoVersion.parse((String)descriptor.get("migrateFrom").asText());
        }
    }

    private void populateResources(URL url, JsonNode descriptor) throws MalformedURLException {
        if (descriptor.get("imageResource") != null) {
            this.imageResource = new URL(url, descriptor.get("imageResource").asText());
        }
        if (descriptor.get("codeResource") != null) {
            this.codeResource = new URL(url, descriptor.get("codeResource").asText());
        }
        if (descriptor.get("nativeResource") != null) {
            this.nativeResource = new URL(url, descriptor.get("nativeResource").asText());
        }
        if (descriptor.get("stubResource") != null) {
            this.stubResource = new URL(url, descriptor.get("stubResource").asText());
        }
    }

    private void populateModule(Module module, JsonNode descriptor) throws Exception {
        ModulePopulator populator = ModulePopulator.forType(module);
        populator.populate(module, descriptor);
    }

    private Module newModule(JsonNode descriptor) throws InstantiationException, IllegalAccessException {
        String typeName = descriptor.get("type").asText();
        ModuleType type = ModuleType.valueOf((String)typeName);
        return (Module)type.getModuleClass().newInstance();
    }

    private JsonNode readDescriptor(URL path) throws JsonProcessingException, IOException {
        URL json = new URL(path, "module.json");
        try (InputStream input = json.openStream();){
            JsonNode jsonNode = new ObjectMapper().readTree(input);
            return jsonNode;
        }
    }

    public boolean importModule(ICodeStore codeStore) throws Exception {
        Module existing = codeStore.fetchModule(this.module.getType(), this.module.getName(), this.module.getVersion());
        if (existing != null) {
            return false;
        }
        this.createModule(codeStore);
        List<Module> toMigrate = this.fetchModulesToMigrate(codeStore);
        return this.migrateModules(codeStore, toMigrate);
    }

    private List<Module> fetchModulesToMigrate(ICodeStore codeStore) {
        if (this.migrateFrom == null) {
            return null;
        }
        return StreamSupport.stream(codeStore.fetchAllModules().spliterator(), false).filter(m -> m.getName().equals(this.module.getName())).filter(m -> m.getVersion().asInt() >= this.migrateFrom.asInt()).filter(m -> m.getVersion().asInt() < this.module.getVersion().asInt()).collect(Collectors.toList());
    }

    private boolean migrateModules(ICodeStore codeStore, List<Module> toMigrate) throws Exception {
        if (toMigrate != null) {
            for (Module existing : toMigrate) {
                this.updateDependencies(codeStore, existing.getVersion());
                codeStore.dropModule(existing);
            }
        }
        return true;
    }

    private void updateDependencies(ICodeStore codeStore, PromptoVersion minVersion) {
        StreamSupport.stream(codeStore.fetchAllModules().spliterator(), false).filter(m -> m.hasDependency(this.module.getName())).forEach(m -> {
            Dependency d = m.getDependency(this.module.getName());
            if (d.getVersion().asInt() >= minVersion.asInt() && d.getVersion().asInt() < this.module.getVersion().asInt()) {
                d.setVersion(this.module.getVersion());
                codeStore.storeDependency(d);
            }
        });
    }

    private void createModule(ICodeStore codeStore) throws Exception {
        logger.info(() -> "Importing module: " + this.module.getName() + " - " + this.module.getVersion());
        if (this.imageResource != null) {
            this.module.setImage(ImageValue.fromURL((URL)this.imageResource).getStorableData());
        }
        codeStore.storeModule(this.module);
        if (this.codeResource != null) {
            this.storeAssociatedCode(codeStore);
        }
        if (this.module instanceof WebLibrary) {
            if (this.nativeResource != null) {
                this.storeResource(codeStore, this.nativeResource);
            }
            if (this.stubResource != null) {
                this.storeResource(codeStore, this.stubResource);
            }
        }
    }

    private void storeAssociatedCode(ICodeStore codeStore) throws Exception {
        ImmutableCodeStore rcs = new ImmutableCodeStore(null, this.module.getType(), this.codeResource, this.module.getVersion());
        codeStore.storeDeclarations(rcs.getDeclarations(), rcs.getModuleDialect(), this.module.getVersion(), this.module.getDbId());
    }

    private void storeResource(ICodeStore codeStore, URL resourceUrl) throws Exception {
        this.initializeJarFileSystem(resourceUrl.toURI());
        String fileName = Paths.get(resourceUrl.toURI()).getFileName().toString();
        String fullName = this.module.getName().toLowerCase().replaceAll(" ", "-") + "/" + fileName;
        TextResource resource = new TextResource();
        resource.setMimeType("text/javascript");
        resource.setName(fullName);
        resource.setVersion(PromptoVersion.LATEST);
        resource.setLastModified(OffsetDateTime.now());
        resource.setBody(StreamUtils.readString((URL)resourceUrl));
        codeStore.storeResource((Resource)resource, this.module.getDbId());
    }

    private void initializeJarFileSystem(URI uri) throws IOException {
        if ("jar".equals(uri.getScheme())) {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                try {
                    provider.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    provider.newFileSystem(uri, Collections.emptyMap());
                }
            }
        }
    }
}

