/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import prompto.utils.Logger;

public abstract class JvmLocator {
    static Logger logger = new Logger();

    public static String locateJava17() {
        String jvmDir = JvmLocator.locateJdkDir("17");
        if (jvmDir == null) {
            return "java";
        }
        return JvmLocator.locateJvmExe(jvmDir);
    }

    private static String locateJdkDir(String majorVersion) {
        File jvms = JvmLocator.locateJvmsDir();
        Optional<String> jvm = Stream.of(jvms.list()).filter(s -> s.contains("jdk-" + majorVersion + ".")).filter(s -> JvmLocator.minorNumberOf(majorVersion, s) != null).filter(s -> JvmLocator.fixNumberOf(majorVersion, s) != null).sorted((s1, s2) -> {
            String n2;
            String n1 = JvmLocator.minorNumberOf(majorVersion, s1);
            if (Objects.equals(n1, n2 = JvmLocator.minorNumberOf(majorVersion, s2))) {
                n1 = JvmLocator.fixNumberOf(majorVersion, s1);
                n2 = JvmLocator.fixNumberOf(majorVersion, s2);
            }
            return Integer.compareUnsigned(Integer.parseInt(n2), Integer.parseInt(n1));
        }).findFirst();
        if (jvm.isPresent()) {
            return jvms.getAbsolutePath() + "/" + jvm.get();
        }
        return null;
    }

    private static String fullVersionOf(String s) {
        int idx = s.indexOf("openjdk");
        if (idx >= 0) {
            return s.substring(idx + 7);
        }
        idx = s.indexOf("jdk");
        if (idx < 0) {
            return null;
        }
        return s.substring(idx + 3);
    }

    public static String minorNumberOf(String majorVersion, String s) {
        logger.info(() -> "Locating minor number in " + s);
        String number = JvmLocator.fullVersionOf(s);
        int idx = number.indexOf(majorVersion + ".");
        if (idx < 0) {
            return null;
        }
        if (Character.isDigit((number = number.substring(idx + 3)).charAt(0))) {
            idx = number.indexOf(".");
            return idx < 0 ? number : number.substring(0, number.indexOf(46));
        }
        return null;
    }

    public static String fixNumberOf(String majorVersion, String s) {
        logger.info(() -> "Locating fix number in " + s);
        String number = JvmLocator.fullVersionOf(s);
        int idx = number.indexOf(majorVersion + ".");
        if (idx < 0) {
            return null;
        }
        if ((idx = (number = number.substring(idx + 3)).indexOf(".")) < 0) {
            return null;
        }
        number = number.substring(idx + 1);
        idx = number.indexOf(".");
        if (Character.isDigit(number.charAt(0))) {
            idx = number.indexOf(".");
            return idx < 0 ? number : number.substring(0, number.indexOf(46));
        }
        return null;
    }

    private static File locateJvmsDir() {
        File file = JvmLocator.locateJavaHomeDir();
        if (file != null && file.exists()) {
            return file;
        }
        file = JvmLocator.locatedOracleJdksDir();
        if (file != null && file.exists()) {
            return file;
        }
        file = JvmLocator.locateOpenJdksDir();
        if (file != null && file.exists()) {
            return file;
        }
        file = JvmLocator.locateMacOSXJdksDir();
        if (file != null && file.exists()) {
            return file;
        }
        throw new RuntimeException("Unable to locate JVMs dir");
    }

    private static File locateMacOSXJdksDir() {
        return new File("/Library/java/JavaVirtualMachines/");
    }

    private static File locateOpenJdksDir() {
        return new File("/usr/lib/jvm/");
    }

    private static File locatedOracleJdksDir() {
        return new File("/usr/java/");
    }

    private static File locateJavaHomeDir() {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            return new File(javaHome).toPath().getParent().toFile();
        }
        return null;
    }

    private static String locateJvmExe(String jvmDir) {
        File dirFile = new File(jvmDir);
        File embedded = new File(dirFile, "Contents/Home");
        if (embedded.exists()) {
            dirFile = embedded;
        }
        if ((embedded = new File(dirFile, "jre")).exists()) {
            dirFile = embedded;
        }
        return new File(dirFile, "bin/java").getAbsolutePath();
    }
}

