/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.function.Supplier;
import prompto.config.IConfigurationReader;
import prompto.config.IPortRangeConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.ITargetConfiguration;
import prompto.config.PortRangeConfiguration;

public class TargetConfiguration
implements ITargetConfiguration {
    IConfigurationReader reader;
    Supplier<IStoreConfiguration> dataStoreConfiguration;
    Supplier<IPortRangeConfiguration> portRangeConfiguration;

    public TargetConfiguration(IConfigurationReader reader) {
        this.reader = reader;
        this.dataStoreConfiguration = () -> reader.readStoreConfiguration("dataStore");
        this.portRangeConfiguration = () -> this.readPortRangeConfiguration();
    }

    private IPortRangeConfiguration readPortRangeConfiguration() {
        IConfigurationReader child = this.reader.getObject("portRange");
        return child == null ? IPortRangeConfiguration.ANY_PORT : new PortRangeConfiguration(child);
    }

    @Override
    public IStoreConfiguration getDataStoreConfiguration() {
        return this.dataStoreConfiguration == null ? null : this.dataStoreConfiguration.get();
    }

    @Override
    public IPortRangeConfiguration getPortRangeConfiguration() {
        return this.portRangeConfiguration == null ? null : this.portRangeConfiguration.get();
    }
}

