/*
 * Decompiled with CFR 0.152.
 */
package prompto.imports;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.TextResource;
import prompto.code.WebLibrary;
import prompto.imports.URLWithMimeType;
import prompto.imports.populator.ModulePopulator;
import prompto.intrinsic.PromptoVersion;
import prompto.utils.Logger;
import prompto.utils.StreamUtils;
import prompto.utils.URLUtils;
import prompto.value.ImageValue;

public class SampleImporter {
    static Logger logger = new Logger();
    Module module;
    PromptoVersion migrateFrom;
    URL imageResource;
    URL codeResource;
    URL stubResource;
    List<URLWithMimeType> javaScripts;
    List<URLWithMimeType> styleSheets;
    List<URLWithMimeType> resources;

    public SampleImporter(Module module, URL codeResource) {
        this.module = module;
        this.codeResource = codeResource;
    }

    public SampleImporter(String resourcePath) {
        this(Thread.currentThread().getContextClassLoader().getResource(resourcePath));
    }

    public SampleImporter(URL url) {
        try {
            JsonNode descriptor = this.readDescriptor(url);
            Module module = this.newModule(descriptor);
            this.populateModule(module, descriptor);
            this.populateResources(url, descriptor);
            this.populateMigrateFrom(descriptor);
            this.module = module;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void populateMigrateFrom(JsonNode descriptor) {
        if (descriptor.get("migrateFrom") != null) {
            this.migrateFrom = PromptoVersion.parse((String)descriptor.get("migrateFrom").asText());
        }
    }

    private void populateResources(URL moduleUrl, JsonNode descriptor) {
        URL nativeResource;
        this.imageResource = this.makeResourceUrlFromField(moduleUrl, descriptor, "imageResource");
        this.codeResource = this.makeResourceUrlFromField(moduleUrl, descriptor, "codeResource");
        this.stubResource = this.makeResourceUrlFromField(moduleUrl, descriptor, "stubResource");
        this.javaScripts = this.makeResourceUrlsWithMimeType(descriptor, "javaScripts", node -> this.makeResourceUrlWithMimeTypeFromTextualNode(moduleUrl, (JsonNode)node, "text/javascript"));
        if (this.javaScripts == null && (nativeResource = this.makeResourceUrlFromField(moduleUrl, descriptor, "nativeResource")) != null) {
            this.javaScripts = Collections.singletonList(new URLWithMimeType(nativeResource, "text/javascript"));
        }
        this.styleSheets = this.makeResourceUrlsWithMimeType(descriptor, "styleSheets", node -> this.makeResourceUrlWithMimeTypeFromTextualNode(moduleUrl, (JsonNode)node, "text/css"));
        this.resources = this.makeResourceUrlsWithMimeType(descriptor, "resources", node -> this.makeResourceUrlWithMimeTypeFromObjectNode(moduleUrl, (JsonNode)node));
    }

    private URL makeResourceUrlFromField(URL moduleUrl, JsonNode descriptor, String name) {
        JsonNode node = descriptor.get(name);
        if (node == null || !node.isTextual()) {
            return null;
        }
        return this.makeResourceUrlFromString(moduleUrl, node.asText());
    }

    private URL makeResourceUrlFromString(URL moduleUrl, String value) {
        try {
            if (value.startsWith("http")) {
                return new URL(value);
            }
            return new URL(moduleUrl, value);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URLWithMimeType> makeResourceUrlsWithMimeType(JsonNode descriptor, String name, Function<JsonNode, URLWithMimeType> supplier) {
        JsonNode node = descriptor.get(name);
        if (node == null || !node.isArray()) {
            return null;
        }
        return StreamSupport.stream(((ArrayNode)node).spliterator(), false).map(supplier).collect(Collectors.toList());
    }

    private URLWithMimeType makeResourceUrlWithMimeTypeFromTextualNode(URL moduleUrl, JsonNode node, String mimeType) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        URL url = this.makeResourceUrlFromString(moduleUrl, node.asText());
        return new URLWithMimeType(url, mimeType);
    }

    private URLWithMimeType makeResourceUrlWithMimeTypeFromObjectNode(URL moduleUrl, JsonNode node) {
        JsonNode mimeType;
        if (node != null && node.isObject() && (mimeType = node.get("mimeType")) != null && mimeType.isTextual()) {
            URL url = this.makeResourceUrlFromField(moduleUrl, node, "url");
            return new URLWithMimeType(url, mimeType.asText());
        }
        return null;
    }

    private void populateModule(Module module, JsonNode descriptor) throws Exception {
        ModulePopulator populator = ModulePopulator.forType(module);
        populator.populate(module, descriptor);
    }

    private Module newModule(JsonNode descriptor) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String typeName = descriptor.get("type").asText();
        ModuleType type = ModuleType.valueOf((String)typeName);
        return (Module)type.getModuleClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private JsonNode readDescriptor(URL path) throws JsonProcessingException, IOException {
        URL json = new URL(path, "module.json");
        try (InputStream input = json.openStream();){
            JsonNode jsonNode = new ObjectMapper().readTree(input);
            return jsonNode;
        }
    }

    public boolean importModule(ICodeStore codeStore) throws Exception {
        Module existing = codeStore.fetchVersionedModule(this.module.getType(), this.module.getName(), this.module.getVersion());
        if (existing != null) {
            return false;
        }
        this.createModule(codeStore);
        List<Module> toMigrate = this.fetchModulesToMigrate(codeStore);
        return this.migrateModules(codeStore, toMigrate);
    }

    private List<Module> fetchModulesToMigrate(ICodeStore codeStore) {
        if (this.migrateFrom == null) {
            return null;
        }
        return StreamSupport.stream(codeStore.fetchAllModules().spliterator(), false).filter(m -> m.getName().equals(this.module.getName())).filter(m -> m.getVersion().asInt() >= this.migrateFrom.asInt()).filter(m -> m.getVersion().asInt() < this.module.getVersion().asInt()).collect(Collectors.toList());
    }

    private boolean migrateModules(ICodeStore codeStore, List<Module> toMigrate) throws Exception {
        if (toMigrate != null) {
            for (Module existing : toMigrate) {
                this.updateDependencies(codeStore, existing.getVersion());
                codeStore.dropModule(existing);
            }
        }
        return true;
    }

    private void updateDependencies(ICodeStore codeStore, PromptoVersion minVersion) {
        StreamSupport.stream(codeStore.fetchAllModules().spliterator(), false).filter(m -> m.hasDependency(this.module.getName())).forEach(m -> {
            Dependency d = m.getDependency(this.module.getName());
            if (d.getVersion().asInt() >= minVersion.asInt() && d.getVersion().asInt() < this.module.getVersion().asInt()) {
                d.setVersion(this.module.getVersion());
                codeStore.storeDependency(d);
            }
        });
    }

    private void createModule(ICodeStore codeStore) throws Exception {
        logger.info(() -> "Importing module: " + this.module.getName() + " - " + this.module.getVersion());
        if (this.imageResource != null) {
            this.module.setImage(ImageValue.fromURL((URL)this.imageResource).getStorableData());
        }
        codeStore.storeModule(this.module);
        if (this.codeResource != null) {
            this.storeAssociatedCode(codeStore);
        }
        if (this.module instanceof WebLibrary) {
            if (this.stubResource != null && this.isLocalResource(this.stubResource)) {
                this.storeTextResource(codeStore, this.stubResource, "text/javascript");
            }
            if (this.javaScripts != null) {
                this.javaScripts.forEach(res -> this.storeTextResource(codeStore, (URLWithMimeType)res));
            }
            if (this.styleSheets != null) {
                this.styleSheets.forEach(res -> this.storeTextResource(codeStore, (URLWithMimeType)res));
            }
            if (this.resources != null) {
                this.resources.forEach(res -> this.storeTextResource(codeStore, (URLWithMimeType)res));
            }
        }
    }

    private void storeAssociatedCode(ICodeStore codeStore) throws Exception {
        ImmutableCodeStore rcs = new ImmutableCodeStore(null, this.module.getType(), this.codeResource, this.module.getVersion());
        codeStore.storeDeclarations(rcs.getDeclarations(), rcs.getModuleDialect(), (Object)this.module.getDbId());
    }

    private void storeTextResource(ICodeStore codeStore, URLWithMimeType res) {
        try {
            if (this.isLocalResource(res.getUrl())) {
                this.storeTextResource(codeStore, res.getUrl(), res.getMimeType());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isLocalResource(URL resource) throws URISyntaxException {
        if ("file".equals(resource.getProtocol())) {
            return Paths.get(resource.toURI()).toFile().exists();
        }
        return "jar".equals(resource.getProtocol());
    }

    private void storeTextResource(ICodeStore codeStore, URL resourceUrl, String mimeType) throws IOException {
        String fileName = URLUtils.extractFileName((URL)resourceUrl);
        String fullName = this.module.getName().toLowerCase().replaceAll(" ", "-") + "/" + fileName;
        TextResource resource = new TextResource();
        resource.setMimeType(mimeType);
        resource.setName(fullName);
        resource.setLastModified(OffsetDateTime.now());
        resource.setBody(StreamUtils.readString((URL)resourceUrl));
        codeStore.storeResource((Resource)resource, (Object)this.module.getDbId());
    }
}

