/*
 * Decompiled with CFR 0.152.
 */
package prompto.imports.populator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.code.Dependency;
import prompto.code.Module;
import prompto.code.ModuleStatus;
import prompto.intrinsic.PromptoVersion;

public class ModulePopulator {
    public static ModulePopulator forType(Module module) throws Exception {
        String packageName = ModulePopulator.class.getPackage().getName();
        String className = module.getType().getModuleClass().getSimpleName() + "Populator";
        Class<?> klass = Class.forName(packageName + "." + className);
        return (ModulePopulator)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void populate(Module module, JsonNode descriptor) {
        module.setName(this.readText(descriptor, "name"));
        module.setVersion(PromptoVersion.parse((String)this.readText(descriptor, "version")));
        module.setDescription(this.readText(descriptor, "description"));
        String value = this.readText(descriptor, "moduleStatus");
        ModuleStatus moduleStatus = value == null ? ModuleStatus.PROVIDED : ModuleStatus.valueOf((String)value);
        module.setModuleStatus(moduleStatus);
        JsonNode dependencies = descriptor.get("dependencies");
        if (dependencies != null) {
            module.setDependencies(this.populateDependencies(dependencies));
        }
    }

    protected String readText(JsonNode descriptor, String fieldName) {
        JsonNode child = descriptor.get(fieldName);
        if (child == null || !child.isTextual()) {
            return null;
        }
        return child.asText();
    }

    protected List<String> readTextArray(JsonNode descriptor, String fieldName) {
        JsonNode child = descriptor.get(fieldName);
        if (child == null || !child.isArray()) {
            return null;
        }
        return StreamSupport.stream(((ArrayNode)child).spliterator(), false).filter(node -> node.isTextual()).map(node -> node.asText()).collect(Collectors.toList());
    }

    protected List<Dependency> populateDependencies(JsonNode descriptor) {
        ArrayList<Dependency> items = new ArrayList<Dependency>();
        for (JsonNode node : descriptor) {
            Dependency item = new Dependency();
            item.setName(this.readText(node, "name"));
            item.setVersion(PromptoVersion.parse((String)this.readText(node, "version")));
            items.add(item);
        }
        return items;
    }
}

