/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import prompto.cloud.Cloud;
import prompto.code.BaseCodeStore;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.Library;
import prompto.code.Module;
import prompto.code.ModuleStatus;
import prompto.code.MutableCodeStore;
import prompto.codefactory.FactoryUpgrader;
import prompto.codefactory.ModuleProcess;
import prompto.compiler.PromptoClassLoader;
import prompto.config.CodeFactoryConfiguration;
import prompto.config.ICodeFactoryConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IPortRangeConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.ITargetConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.declaration.CategoryDeclaration;
import prompto.grammar.Identifier;
import prompto.imports.SampleImporter;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.server.AppServer;
import prompto.server.DataServlet;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.memory.MemStore;
import prompto.utils.CmdLineParser;
import prompto.utils.Logger;
import prompto.utils.ResourceUtils;

public class Application {
    static Logger logger = new Logger();
    static ICodeFactoryConfiguration config;

    public static void main(String[] args) throws Throwable {
        Application.main(args, null);
    }

    public static void main(String[] args, Mode runtimeMode) throws Throwable {
        ICodeFactoryConfiguration config = Application.loadConfiguration(args);
        config = Application.adjustConfiguration(config, runtimeMode);
        Application.main(config);
    }

    public static void main(ICodeFactoryConfiguration config) throws Throwable {
        Application.config = config;
        AppServer.main((IServerConfiguration)config, Application::serverPrepared, null, null, Application::afterStart);
    }

    public static ICodeFactoryConfiguration loadConfiguration(String[] args) throws Exception {
        Map argsMap = CmdLineParser.read((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs((Map)argsMap);
        CodeFactoryConfiguration config = new CodeFactoryConfiguration(reader, argsMap);
        return (ICodeFactoryConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class, BaseCodeStore.class}));
    }

    public static ICodeFactoryConfiguration adjustConfiguration(ICodeFactoryConfiguration config, Mode runtimeMode) throws Exception {
        config = (ICodeFactoryConfiguration)config.withServerAboutToStartMethod("serverAboutToStart").withHttpConfiguration(config.getHttpConfiguration().withWelcomePage("/projects/index.page").withSendsXAuthorization(true)).withApplicationName("CodeFactory").withApplicationVersion(PromptoVersion.LATEST).withResourceURLs(Application.getResourceURLs());
        if (runtimeMode != null) {
            config = (ICodeFactoryConfiguration)config.withRuntimeMode(runtimeMode);
        }
        return config;
    }

    private static void serverPrepared() {
        Application.installCloudJARsIfRequired();
        Application.upgradeFactoryIfRequired();
        Application.migrateDataModelIfRequired();
    }

    private static void installCloudJARsIfRequired() {
        try {
            logger.info(() -> "Installing cloud jars...");
            for (Cloud cloud : Cloud.values()) {
                if (cloud.isInClassPath()) continue;
                logger.info(() -> "Installing cloud jars for " + cloud.name() + "...");
                AppServer.installCloudJARs((Cloud)cloud);
                if (cloud.isInClassPath()) continue;
                throw new RuntimeException("Failed to install cloud jars for " + cloud.name());
            }
        }
        catch (Throwable t) {
            logger.error(() -> "While installing cloud jars", t);
            throw new RuntimeException(t);
        }
    }

    private static void upgradeFactoryIfRequired() {
        FactoryUpgrader upgrader = new FactoryUpgrader();
        boolean didUpgrade = upgrader.upgradeIfRequired();
        if (didUpgrade) {
            try {
                PromptoClassLoader.uninitialize();
                ICodeStore codeStore = Standalone.initializeCodeStore((IRuntimeConfiguration)config);
                IStore dataStore = Standalone.initializeDataStore((IRuntimeConfiguration)config);
                Standalone.synchronizeSchema((ICodeStore)codeStore, (IStore)dataStore);
            }
            catch (Throwable t) {
                logger.error(() -> "While rebootstrapping after upgrade", t);
                throw new RuntimeException(t);
            }
        }
    }

    private static void migrateDataModelIfRequired() {
        Application.migrateStuffsToResourcesIfRequired();
        Application.migrateClickEventsToMouseEventsIfRequired();
        Application.migrateProjectsIfRequired();
    }

    private static void migrateProjectsIfRequired() {
        ICodeStore codeStore = Application.codeStoreUsingDataStore("ProjectMigrator", PromptoVersion.LATEST);
        codeStore.upgradeIfRequired();
    }

    private static void migrateClickEventsToMouseEventsIfRequired() {
        IStore dataStore;
        IStore codeStore = Application.storeFromCodeStore();
        if (Application.isMigratableStore(codeStore) && Application.isMigratingClickEventsToMouseEventsRequired(codeStore)) {
            Application.migrateClickEventsToMouseEvents(codeStore);
        }
        if (Application.isMigratableStore(dataStore = DataStore.getInstance()) && Application.isMigratingClickEventsToMouseEventsRequired(codeStore)) {
            Application.migrateClickEventsToMouseEvents(dataStore);
        }
    }

    private static void migrateClickEventsToMouseEvents(IStore store) {
        AttributeInfo BODY = new AttributeInfo("body", Family.TEXT, false, null);
        IQueryBuilder builder = store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Declaration").verify(BODY, IQueryBuilder.MatchOp.CONTAINS, (Object)"ClickEvent").and();
        StreamSupport.stream(store.fetchMany(builder.build()).spliterator(), false).forEach(stored -> {
            Object body = stored.getData("body");
            if (body instanceof String) {
                body = ((String)body).replaceAll("ClickEvent", "MouseEvent");
                IStorable storable = store.newStorable(stored.getCategories(), IStorable.IDbIdFactory.of(() -> stored.getDbId(), null, () -> true));
                storable.setData("body", body);
                store.store(storable);
            }
        });
    }

    private static boolean isMigratingClickEventsToMouseEventsRequired(IStore codeStore) {
        PromptoVersion version = FactoryUpgrader.fetchStoredFactoryVersion(codeStore);
        return version == null || version.compareTo(PromptoVersion.parse((String)"0.1.29")) < 0;
    }

    private static void migrateStuffsToResourcesIfRequired() {
        IStore dataStore;
        IStore codeStore = Application.storeFromCodeStore();
        if (Application.isMigratableStore(codeStore) && Application.isMigratingStuffsToResourcesRequired(codeStore, codeStore)) {
            Application.migrateStuffsToResources(codeStore);
        }
        if (Application.isMigratableStore(dataStore = DataStore.getInstance()) && Application.isMigratingStuffsToResourcesRequired(codeStore, dataStore)) {
            Application.migrateStuffsToResources(dataStore);
        }
    }

    private static boolean isMigratableStore(IStore store) {
        return store != null && !(store instanceof MemStore);
    }

    static IStore storeFromCodeStore() {
        ICodeStore codeStore = ICodeStore.getInstance();
        if (codeStore instanceof MutableCodeStore) {
            return ((MutableCodeStore)codeStore).getStore();
        }
        return null;
    }

    private static boolean isMigratingStuffsToResourcesRequired(IStore codeStore, IStore dataStore) {
        IQueryBuilder builder = dataStore.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Stuff");
        IStored stored = dataStore.fetchOne(builder.build());
        if (stored == null) {
            return false;
        }
        builder = codeStore.newQueryBuilder().verify(AttributeInfo.NAME, IQueryBuilder.MatchOp.EQUALS, (Object)"NamedResource");
        stored = codeStore.fetchOne(builder.build());
        return stored != null;
    }

    private static void migrateStuffsToResources(IStore store) {
        logger.info(() -> "Migrating Stuff records to Resource records...");
        IQueryBuilder builder = store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Stuff");
        IStoredIterable stuffs = store.fetchMany(builder.build());
        logger.info(() -> "Found " + stuffs.count() + " Stuff records to migrate");
        for (IStored stuff : stuffs) {
            Application.migrateStuffToResource(store, stuff);
        }
        logger.info(() -> "Done migrating Stuff records");
    }

    private static void migrateStuffToResource(IStore store, final IStored stuff) {
        String[] oldCategories = stuff.getCategories();
        String category = oldCategories[oldCategories.length - 1];
        Context context = ApplicationContext.get();
        CategoryDeclaration decl = (CategoryDeclaration)context.getRegisteredDeclaration(CategoryDeclaration.class, new Identifier(category));
        List newCategories = decl.collectCategories(context);
        IStorable storable = store.newStorable(newCategories, new IStorable.IDbIdFactory(){

            public void accept(PromptoDbId t) {
            }

            public PromptoDbId get() {
                return stuff.getDbId();
            }

            public boolean isUpdate() {
                return true;
            }
        });
        storable.setData("category", (Object)newCategories);
        store.store(storable);
    }

    private static void afterStart(ICodeFactoryConfiguration config) {
        Application.initDataServletStores(config);
        Application.initModuleProcessPortRange(config);
    }

    private static void initModuleProcessPortRange(ICodeFactoryConfiguration config) {
        try {
            IPortRangeConfiguration portRange;
            ITargetConfiguration target = config.getTargetConfiguration();
            if (target != null && (portRange = target.getPortRangeConfiguration()) != null) {
                logger.info(() -> "Target port range is " + portRange.getMinPort() + " to " + portRange.getMaxPort());
                ModuleProcess.portRangeConfiguration = portRange;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void initDataServletStores(ICodeFactoryConfiguration config) {
        try {
            HashMap<String, IStore> stores = new HashMap<String, IStore>();
            IStore store = Application.fetchLoginStore(config);
            if (store != null) {
                stores.put("LOGIN", store);
            }
            if ((store = DataStore.getInstance()) != null) {
                stores.put("APPS", store);
            }
            if ((store = Application.readTargetStoreConfiguration(config)) != null) {
                stores.put("DATA", store);
            }
            DataServlet.setStores(stores);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static IStore readTargetStoreConfiguration(ICodeFactoryConfiguration config) throws Throwable {
        ITargetConfiguration target = config.getTargetConfiguration();
        return target == null ? null : Application.newStore(target.getDataStoreConfiguration());
    }

    public static IStore fetchLoginStore(ICodeFactoryConfiguration config) throws Throwable {
        IAuthenticationConfiguration auth = config.getHttpConfiguration().getAuthenticationConfiguration();
        return auth == null ? null : Application.fetchLoginStore(auth);
    }

    private static IStore fetchLoginStore(IAuthenticationConfiguration config) throws Throwable {
        IAuthenticationSourceConfiguration source = config.getAuthenticationSourceConfiguration();
        if (source instanceof IStoredAuthenticationSourceConfiguration) {
            return Application.newStore(((IStoredAuthenticationSourceConfiguration)source).getStoreConfiguration());
        }
        return null;
    }

    private static IStore newStore(IStoreConfiguration config) throws Throwable {
        if (config == null) {
            return null;
        }
        IStoreFactory factory = IStoreFactory.newStoreFactory((String)config.getFactory());
        return factory.newStore(config);
    }

    private static URL[] getResourceURLs() {
        Collection urls = Libraries.getPromptoLibraries((Class[])new Class[]{BaseCodeStore.class, Application.class});
        return urls.toArray(new URL[urls.size()]);
    }

    public static void createLibraries() {
        try {
            ICodeStore codeStore = Application.codeStoreUsingDataStore("LibraryCreator", PromptoVersion.LATEST);
            Application.createResourceLibraries(codeStore, "thesaurus/", "react-file-uploader/", "react-bootstrap-3/", "react-bootstrap-4/");
            if (Application.isSeedDataStore()) {
                Application.createResourceLibraries(codeStore, "resource-editors/");
                Application.createSeedLibraries(codeStore);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createResourceLibraries(ICodeStore codeStore, String ... resources) throws Exception {
        for (String resource : resources) {
            Application.createResourceLibrary(codeStore, resource);
        }
    }

    private static void createResourceLibrary(ICodeStore codeStore, String resource) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("libraries/" + resource);
        Application.doImportModule(codeStore, url);
    }

    private static ICodeStore codeStoreUsingDataStore(String application, PromptoVersion version) {
        ICodeStore runtime = ImmutableCodeStore.bootstrapRuntime(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class}));
        return new MutableCodeStore(DataStore.getInstance(), runtime, application, version, null, new URL[0]);
    }

    private static void doImportModule(ICodeStore codeStore, URL url) throws Exception {
        SampleImporter importer = new SampleImporter(url);
        importer.importModule(codeStore);
    }

    public static void importSamples(String root) throws IOException {
        Collection samples = ResourceUtils.listResourcesAt((String)root, null);
        samples.forEach(Application::importSample);
    }

    public static void importSample(String name) {
        Application.importSample(Thread.currentThread().getContextClassLoader().getResource(name));
    }

    public static void importSample(URL sample) {
        try {
            ICodeStore codeStore = Application.codeStoreUsingDataStore("SampleImporter", PromptoVersion.LATEST);
            Application.doImportModule(codeStore, sample);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createSeedLibraries(ICodeStore codeStore) throws Exception {
        PromptoVersion version = PromptoVersion.parse((String)"1.0.0.0");
        Application.createSeedLibrary(codeStore, "CodeStore", "Code store model", version, "libraries/CodeStore.pec", new Dependency[0]);
        Application.createSeedLibrary(codeStore, "AppStore", "App store model", version, "libraries/AppStore.pec", new Dependency("CodeStore", version));
    }

    private static void createSeedLibrary(ICodeStore codeStore, String name, String description, PromptoVersion version, String resource, Dependency ... dependencies) throws Exception {
        Library library = new Library();
        library.setName(name);
        library.setDescription(description);
        library.setVersion(version);
        library.setModuleStatus(ModuleStatus.PROVIDED);
        if (dependencies != null && dependencies.length > 0) {
            library.setDependencies(Arrays.asList(dependencies));
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        SampleImporter importer = new SampleImporter((Module)library, url);
        importer.importModule(codeStore);
    }

    private static boolean isSeedDataStore() {
        HashSet<String> names = new HashSet<String>(Arrays.asList("tools", "factory-dev"));
        IStoreConfiguration sfg = config.getDataStoreConfiguration();
        return sfg == null ? false : names.contains(sfg.getDbName().toLowerCase());
    }
}

