/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import prompto.codefactory.Application;
import prompto.config.mongo.IMongoStoreConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.store.IStore;
import prompto.store.mongo.MongoStore;
import prompto.utils.JsonUtils;
import prompto.utils.Logger;
import prompto.utils.TarUtils;

public class FactoryUpgrader {
    static Logger logger = new Logger();
    static final String CODE_FACTORY_PREFIX = "/CodeFactory-";

    public boolean upgradeIfRequired() {
        if (FactoryUpgrader.isUpgradeToThisJarVersionRequired()) {
            try {
                FactoryUpgrader.upgradeToThisJarVersion();
                return true;
            }
            catch (Throwable t) {
                logger.error(() -> "Failed to upgrade factory", t);
            }
        } else if (this.isUpgradeToEnvVariableVersionRequired()) {
            try {
                this.upgradeToEnvVariableVersion();
                return true;
            }
            catch (Throwable t) {
                logger.error(() -> "Failed to upgrade factory", t);
            }
        }
        return false;
    }

    private void upgradeToEnvVariableVersion() throws Exception {
        logger.info(() -> "upgradeToEnvVariableVersion");
        PromptoVersion version = this.getEnvVariableFactoryVersion();
        FactoryUpgrader.upgradeTo(version);
    }

    private static void upgradeToThisJarVersion() throws Exception {
        logger.info(() -> "upgradeToThisJarVersion");
        PromptoVersion version = FactoryUpgrader.getThisJarFactoryVersion();
        FactoryUpgrader.upgradeTo(version);
    }

    static void upgradeTo(PromptoVersion version) throws Exception {
        logger.info(() -> "Upgrading factory to " + version.toString());
        Path tarGzPath = FactoryUpgrader.downloadPromptoCode(version);
        Path tarPath = TarUtils.ungz((Path)tarGzPath, (Path)new File(tarGzPath.getParent().toFile(), "factory.tar").toPath());
        Path dirPath = TarUtils.untar((Path)tarPath, (Path)new File(tarGzPath.getParent().toFile(), "factory").toPath());
        FactoryUpgrader.importPromptoCode(dirPath);
        FactoryUpgrader.storeFactoryVersion(version);
    }

    static PromptoVersion fetchStoredFactoryVersion(IStore store) {
        try {
            Map config = store.fetchConfiguration("FactoryConfiguration");
            Object version = config == null ? null : (Object)config.get("version");
            return version == null ? null : PromptoVersion.parse((String)version.toString());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void storeFactoryVersion(PromptoVersion version) {
        try {
            IStore store = Application.storeFromCodeStore();
            HashMap<String, String> config = store.fetchConfiguration("FactoryConfiguration");
            if (config == null) {
                config = new HashMap<String, String>();
            }
            config.put("version", version.toString());
            store.storeConfiguration("FactoryConfiguration", config);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void importPromptoCode(Path dirPath) throws Exception {
        String uri = FactoryUpgrader.getFactoryMongoUri();
        String dbName = FactoryUpgrader.getFactoryDbName();
        File dbDir = new File(dirPath.toFile(), dbName);
        if (!dbDir.exists()) {
            File srcDir = new File(dirPath.toFile(), "FACTORY-SEED");
            srcDir.renameTo(dbDir);
        }
        String tool = FactoryUpgrader.locateMongoRestoreTool();
        String[] args = new String[]{tool, "--uri", uri, "--dir", dbDir.getAbsolutePath(), "--drop"};
        ProcessBuilder builder = new ProcessBuilder(args).inheritIO();
        Process process = builder.start();
        int error = process.waitFor();
        if (error != 0) {
            throw new RuntimeException("mongorestore failed with error " + error);
        }
    }

    private static String locateMongoRestoreTool() {
        String[] paths;
        for (String path : paths = new String[]{"/usr/local/bin/", "/usr/bin/", "/usr/sbin/"}) {
            if (!new File(path + "mongorestore").exists()) continue;
            return path + "mongorestore";
        }
        throw new RuntimeException("Could not locate mongorestore");
    }

    private static String getFactoryMongoUri() {
        if (Application.config.getCodeStoreConfiguration() instanceof IMongoStoreConfiguration) {
            return MongoStore.uriFromConfig((IMongoStoreConfiguration)((IMongoStoreConfiguration)Application.config.getCodeStoreConfiguration()));
        }
        return null;
    }

    private static String getFactoryDbName() {
        return Application.config.getCodeStoreConfiguration().getDbName();
    }

    private static Path downloadPromptoCode(PromptoVersion version) throws IOException {
        Path dir = Files.createTempDirectory("prompto", new FileAttribute[0]);
        Path archive = new File(dir.toFile(), "factory.tar.gz").toPath();
        String url = FactoryUpgrader.fetchPromptoCodeDownloadUrl(version);
        try (InputStream input = new URL(url).openStream();){
            Files.copy(input, archive, StandardCopyOption.REPLACE_EXISTING);
            Path path = archive;
            return path;
        }
    }

    static String fetchPromptoCodeDownloadUrl(PromptoVersion version) throws IOException {
        JsonNode release = FactoryUpgrader.fetchFactoryRelease(version);
        JsonNode assets = release.get("assets");
        if (assets == null || !assets.isArray()) {
            throw new IOException("Could not parse release data");
        }
        return StreamSupport.stream(assets.spliterator(), false).filter(node -> node.has("name") && "factory.tar.gz".equals(node.get("name").asText())).map(node -> node.get("browser_download_url").asText()).findFirst().orElse(null);
    }

    static JsonNode fetchFactoryRelease(PromptoVersion version) throws IOException {
        URL url = new URL("https://api.github.com/repos/prompto/prompto-factory/releases/tags/" + version.toString());
        URLConnection connection = url.openConnection();
        try (InputStream input = connection.getInputStream();){
            JsonNode jsonNode = JsonUtils.parseInput((InputStream)input);
            return jsonNode;
        }
    }

    private boolean isUpgradeToEnvVariableVersionRequired() {
        boolean isMongo;
        PromptoVersion envVersion = this.getEnvVariableFactoryVersion();
        if (envVersion != null && (isMongo = Application.config.getCodeStoreConfiguration() instanceof IMongoStoreConfiguration)) {
            PromptoVersion storedVersion = FactoryUpgrader.getStoredFactoryVersion();
            return storedVersion == null || envVersion.compareTo(storedVersion) > 0;
        }
        return false;
    }

    private PromptoVersion getEnvVariableFactoryVersion() {
        String version = System.getenv("UPGRADE_FACTORY_VERSION");
        if (version == null || version.isEmpty()) {
            return null;
        }
        return PromptoVersion.parse((String)version);
    }

    private static boolean isUpgradeToThisJarVersionRequired() {
        PromptoVersion storedVersion = FactoryUpgrader.getStoredFactoryVersion();
        logger.info(() -> "StoredFactoryVersion is " + storedVersion);
        PromptoVersion latestVersion = FactoryUpgrader.getThisJarFactoryVersion();
        logger.info(() -> "ThisFactoryVersion is " + latestVersion);
        boolean isMongo = Application.config.getCodeStoreConfiguration() instanceof IMongoStoreConfiguration;
        boolean required = isMongo && latestVersion != null && (storedVersion == null || latestVersion.compareTo(storedVersion) > 0);
        logger.info(() -> "Factory upgrade " + (required ? "" : "not ") + "required, stored version is " + storedVersion + ", this version is " + latestVersion);
        return required;
    }

    static PromptoVersion getStoredFactoryVersion() {
        try {
            IStore store = Application.storeFromCodeStore();
            Map config = store.fetchConfiguration("FactoryConfiguration");
            if (config != null) {
                return PromptoVersion.parse((String)((String)config.get("version")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static PromptoVersion getThisJarFactoryVersion() {
        Object className = FactoryUpgrader.class.getCanonicalName();
        className = ((String)className).replace('.', '/') + ".class";
        ClassLoader loader = FactoryUpgrader.class.getClassLoader();
        URL classURL = loader.getResource((String)className);
        if (classURL == null) {
            return null;
        }
        String fullPath = classURL.toString();
        int idx = fullPath.indexOf(CODE_FACTORY_PREFIX);
        if (idx < 0) {
            return null;
        }
        if ((idx = (fullPath = fullPath.substring(idx + CODE_FACTORY_PREFIX.length())).indexOf(".jar")) < 0) {
            return null;
        }
        fullPath = fullPath.substring(0, idx);
        return PromptoVersion.parse((String)fullPath);
    }
}

