/*
 * Decompiled with CFR 0.152.
 */
package prompto.codefactory;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlDocumentReader;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.esotericsoftware.yamlbeans.document.YamlScalar;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import prompto.codefactory.ModuleProcess;
import prompto.debug.HttpServletDebugRequestListenerFactory;
import prompto.debug.WebSocketDebugEventAdapterFactory;
import prompto.runtime.Mode;
import prompto.server.PromptoServlet;
import prompto.utils.Logger;

public class YamlConfigBuilder {
    static Logger logger = new Logger();
    ModuleProcess process;
    File source;
    File target;

    public YamlConfigBuilder(ModuleProcess process, File source, File target) {
        this.process = process;
        this.source = source;
        this.target = target;
    }

    public void build() throws Throwable {
        try (FileReader reader = new FileReader(this.source);){
            YamlDocument currentYaml = new YamlDocumentReader((Reader)reader).read();
            this.writeSpecificYamlEntries(currentYaml);
            logger.info(() -> "Writing yaml config to " + this.target.getAbsolutePath());
            try (FileWriter writer = new FileWriter(this.target);){
                YamlConfig config = new YamlConfig();
                config.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
                config.writeConfig.setAutoAnchor(false);
                YamlWriter targetYaml = new YamlWriter((Writer)writer, config);
                targetYaml.write((Object)currentYaml);
            }
        }
    }

    private void writeSpecificYamlEntries(YamlDocument document) throws Throwable {
        document.setEntry("applicationName", this.process.getModuleName());
        document.setEntry("applicationVersion", this.process.getModuleVersion());
        document.setEntry("runtimeMode", Mode.DEVELOPMENT.name());
        document.deleteEntry("webSiteRoot");
        document.deleteEntry("startMethod");
        String method = this.process.getStartMethod();
        if (method != null) {
            document.setEntry("startMethod", method);
        }
        document.deleteEntry("serverAboutToStart");
        method = this.process.getServerAboutToStartMethod();
        if (method != null) {
            document.setEntry("serverAboutToStart", method);
        }
        this.writeCodeStoreYamlEntries(document);
        this.writeDataStoreYamlEntries(document);
        this.writeHttpYamlEntries(document);
        this.writeDebugYamlEntries(document);
        document.deleteEntry("target");
    }

    private void writeCodeStoreYamlEntries(YamlDocument document) throws YamlException {
        YamlEntry entry = document.getEntry("dataStore");
        document.setEntry("codeStore", entry.getValue());
        document.deleteEntry("dataStore");
    }

    private void writeDataStoreYamlEntries(YamlDocument document) throws YamlException {
        YamlEntry entry = document.getEntry("target");
        if (entry != null) {
            YamlMapping target = (YamlMapping)entry.getValue();
            entry = target.getEntry("dataStore");
            document.setEntry("dataStore", entry.getValue());
        }
    }

    private void writeHttpYamlEntries(YamlDocument document) throws Throwable {
        YamlMapping auth;
        YamlElement value;
        YamlEntry entry = document.getEntry("http");
        YamlMapping http = (YamlMapping)entry.getValue();
        http.setEntry("port", (Number)this.process.getPort());
        entry = http.getEntry("protocol");
        if (entry != null && (value = entry.getValue()) instanceof YamlScalar) {
            this.process.setProtocol(((YamlScalar)value).getValue());
        }
        if (this.process.getWelcomePage() != null) {
            http.setEntry("welcomePage", this.process.getWelcomePage());
        }
        if (this.process.getSiteMap() != null) {
            http.setEntry("siteMap", this.process.getSiteMap());
        }
        http.deleteEntry("redirectFrom");
        http.deleteEntry("sendsXAuthorization");
        http.deleteEntry("authentication");
        String origins = (String)PromptoServlet.REGISTERED_ORIGINS.get();
        if (origins != null) {
            http.setEntry("allowedOrigins", origins);
            http.setEntry("allowsXAuthorization", true);
        }
        if ((auth = this.process.authenticationSettingsToYaml()) != null) {
            http.setEntry("authentication", (YamlElement)auth);
        }
    }

    private void writeDebugYamlEntries(YamlDocument document) throws YamlException {
        if (this.process.isDebug()) {
            YamlMapping eventAdapter = new YamlMapping();
            eventAdapter.setEntry("factory", WebSocketDebugEventAdapterFactory.class.getName());
            YamlMapping requestListener = new YamlMapping();
            requestListener.setEntry("factory", HttpServletDebugRequestListenerFactory.class.getName());
            YamlMapping debugger = new YamlMapping();
            debugger.setEntry("eventAdapter", (YamlElement)eventAdapter);
            debugger.setEntry("requestListener", (YamlElement)requestListener);
            document.setEntry("debugger", (YamlElement)debugger);
        }
    }
}

