/*
 * Decompiled with CFR 0.152.
 */
package prompto.imports.populator;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.code.Module;
import prompto.code.WebLibrary;
import prompto.imports.populator.LibraryPopulator;

class WebLibraryPopulator
extends LibraryPopulator {
    WebLibraryPopulator() {
    }

    @Override
    public void populate(Module module, JsonNode descriptor) {
        super.populate(module, descriptor);
        WebLibrary library = (WebLibrary)module;
        library.setWidgetLibrary(this.readText(descriptor, "widgetLibrary"));
        library.setHtmlEngine(this.readText(descriptor, "htmlEngine"));
        library.setUiFramework(this.readText(descriptor, "uiFramework"));
        this.populateStubResource(descriptor, library);
        this.populateJavaScripts(descriptor, library);
        this.populateStyleSheets(descriptor, library);
        this.populateResources(descriptor, library);
    }

    void populateStubResource(JsonNode descriptor, WebLibrary library) {
        String resourceName = this.readText(descriptor, "stubResource");
        if (resourceName != null) {
            library.setStubResource(this.makeResourceURL(library, resourceName));
        }
    }

    void populateJavaScripts(JsonNode descriptor, WebLibrary library) {
        List<String> values = this.readTextArray(descriptor, "javaScripts");
        if (values != null && !values.isEmpty()) {
            values = values.stream().map(url -> this.makeResourceURL(library, (String)url)).collect(Collectors.toList());
            library.setJavaScripts(values);
        } else {
            String nativeResource = this.readText(descriptor, "nativeResource");
            if (nativeResource instanceof String) {
                library.setJavaScripts(Collections.singletonList(this.makeResourceURL(library, nativeResource)));
            }
        }
    }

    void populateStyleSheets(JsonNode descriptor, WebLibrary library) {
        List<String> values = this.readTextArray(descriptor, "styleSheets");
        if (values != null && !values.isEmpty()) {
            values = values.stream().map(url -> this.makeResourceURL(library, (String)url)).collect(Collectors.toList());
            library.setStyleSheets(values);
        }
    }

    void populateResources(JsonNode descriptor, WebLibrary library) {
        JsonNode node = descriptor.get("resources");
        if (node != null && node.isArray() && node.size() > 0) {
            List values = StreamSupport.stream(node.spliterator(), false).map(child -> child.get("url")).filter(Objects::nonNull).filter(JsonNode::isTextual).map(JsonNode::asText).map(url -> this.makeResourceURL(library, (String)url)).collect(Collectors.toList());
            library.setResources(values);
        }
    }

    private String makeResourceURL(WebLibrary library, String localUrl) {
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        return library.getResourcePrefix() + "/" + localUrl;
    }
}

