/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prompto.code.AppStoreBootstrapper;
import prompto.code.BaseCodeStore;
import prompto.code.BinaryResource;
import prompto.code.CodeStoreBootstrapper;
import prompto.code.ICodeStore;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.TextResource;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.AndExpression;
import prompto.expression.EqualsExpression;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.EqOp;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.grammar.OrderByClause;
import prompto.grammar.OrderByClauseList;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoVersion;
import prompto.literal.TextLiteral;
import prompto.literal.VersionLiteral;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.type.CategoryType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.StringUtils;

public class QueryableCodeStore
extends BaseCodeStore {
    static final Logger logger = new Logger();
    IStore store;
    String application;
    PromptoVersion version;
    Context context;
    boolean storeExternals = false;
    static ThreadLocal<Map<String, Iterable<IDeclaration>>> registering = new ThreadLocal<Map<String, Iterable<IDeclaration>>>(){

        @Override
        protected Map<String, Iterable<IDeclaration>> initialValue() {
            return new HashMap<String, Iterable<IDeclaration>>();
        }
    };
    private static Set<String> uniqueDecls = new HashSet<String>(Arrays.asList(IDeclaration.DeclarationType.ATTRIBUTE.name(), IDeclaration.DeclarationType.CATEGORY.name(), IDeclaration.DeclarationType.TEST.name()));

    public QueryableCodeStore(IStore store, ICodeStore runtime, String application, PromptoVersion version, URL[] addOns, URL ... resourceNames) throws PromptoError {
        super(null);
        this.store = store;
        this.application = application;
        this.version = version;
        this.context = CodeStoreBootstrapper.bootstrap(store, runtime);
        this.next = AppStoreBootstrapper.bootstrap(store, runtime, application, version, addOns, resourceNames);
    }

    public IStore getStore() {
        return this.store;
    }

    public void setStore(IStore store) {
        this.store = store;
    }

    public void collectStorables(List<IStorable> list, IDeclaration declaration, Dialect dialect, PromptoVersion version, Object moduleId) {
        if (declaration instanceof Context.MethodDeclarationMap) {
            for (IDeclaration method : ((Context.MethodDeclarationMap)declaration).values()) {
                this.collectStorables(list, method, dialect, version, moduleId);
            }
        } else {
            String typeName = StringUtils.capitalizeFirst((String)declaration.getDeclarationType().name()) + "Declaration";
            List<String> categories = Arrays.asList("Stuff", "Declaration", typeName);
            IStorable storable = this.populateDeclarationStorable(categories, declaration, dialect, version, moduleId);
            list.add(storable);
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.WEBSITE;
    }

    public Dialect getModuleDialect() {
        return null;
    }

    public String getModuleName() {
        return this.application;
    }

    public PromptoVersion getModuleVersion() {
        return this.version;
    }

    public void storeResource(Resource resource, Object moduleId) {
        IStorable storable = resource.toStorable(this.store);
        if (moduleId != null) {
            storable.setData("module", moduleId);
        }
        this.store.store(null, Collections.singletonList(storable));
    }

    public void storeModule(Module module) throws PromptoError {
        Context context = Context.newGlobalContext();
        ArrayList storables = new ArrayList();
        module.toStorables(context, this.store, storables);
        this.store.store(null, storables);
    }

    private Object storeDeclarationModule(IDeclaration decl) throws PromptoError {
        ICodeStore origin = decl.getOrigin();
        List<String> categories = Arrays.asList("Module", origin.getModuleType().getCategory().getTypeName());
        IStorable storable = this.store.newStorable(categories, null);
        storable.setData("name", (Object)origin.getModuleName());
        storable.setData("version", (Object)origin.getModuleVersion());
        this.store.store(storable);
        return storable.getOrCreateDbId();
    }

    public <T extends Module> T fetchModule(ModuleType type, String name, PromptoVersion version) throws PromptoError {
        try {
            IStored stored = this.fetchOneNamedInStore(type.getCategory(), version, name);
            if (stored == null) {
                return null;
            }
            Module module = (Module)type.getModuleClass().newInstance();
            module.fromStored(stored);
            return (T)module;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Resource fetchSpecificResource(String name, PromptoVersion version) {
        try {
            IStored stored = this.fetchOneInStore(new CategoryType(new Identifier("Resource")), version, "name", name);
            if (stored == null) {
                return null;
            }
            return this.readResource(stored);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Resource readResource(IStored stored) {
        TextResource resource = null;
        String mimeType = (String)stored.getData("mimeType");
        if (mimeType.startsWith("text/")) {
            resource = new TextResource();
            resource.setBody((String)stored.getData("body"));
        } else {
            resource = new BinaryResource();
            ((BinaryResource)resource).setData((PromptoBinary)stored.getData("data"));
        }
        resource.setMimeType(mimeType);
        resource.setName((String)stored.getData("name"));
        resource.setVersion((PromptoVersion)stored.getData("version"));
        Long value = (Long)stored.getData("timeStamp");
        if (value != null) {
            resource.setLastModified(OffsetDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC));
        }
        return resource;
    }

    private IDeclaration getRegisteringSymbol(String name) {
        return registering.get().values().stream().map(i -> StreamSupport.stream(i.spliterator(), false)).flatMap(Function.identity()).filter(d -> d instanceof IEnumeratedDeclaration).map(d -> (IEnumeratedDeclaration)d).filter(e -> e.hasSymbol(name)).findFirst().orElse(null);
    }

    private Iterable<IDeclaration> getRegisteringDeclarations(String name) {
        return registering.get().get(name);
    }

    private void setRegisteringDeclarations(String name, Iterable<IDeclaration> decl) {
        registering.get().put(name, decl);
    }

    private void clearRegisteringDeclarations(String name) {
        registering.get().remove(name);
    }

    @Override
    public Collection<String> fetchDeclarationNames() {
        return super.fetchDeclarationNames();
    }

    @Override
    public Iterable<IDeclaration> fetchSpecificDeclarations(String name, PromptoVersion version) throws PromptoError {
        Iterable<IDeclaration> decls = this.fetchDeclarationsInStore(name, version);
        if (decls != null) {
            return decls;
        }
        if (this.storeExternals) {
            return this.fetchAndStoreExternalSpecificDeclarations(name, version);
        }
        return super.fetchSpecificDeclarations(name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Iterable<IDeclaration> fetchAndStoreExternalSpecificDeclarations(String name, PromptoVersion version2) {
        QueryableCodeStore queryableCodeStore = this;
        synchronized (queryableCodeStore) {
            Iterable<IDeclaration> decls = this.fetchDeclarationsInStore(name, this.version);
            if (decls != null) {
                return decls;
            }
            decls = this.getRegisteringDeclarations(name);
            if (decls != null) {
                return decls;
            }
            decls = super.fetchSpecificDeclarations(name, this.version);
            if (this.store != null && decls != null && decls.iterator().hasNext()) {
                this.setRegisteringDeclarations(name, decls);
                decls = this.storeDeclarations(decls);
                this.clearRegisteringDeclarations(name);
                this.store.flush();
            }
            return decls;
        }
    }

    @Override
    public IDeclaration fetchSpecificSymbol(String name, PromptoVersion version) throws PromptoError {
        Iterable<IDeclaration> decls = this.fetchSymbolsInStore(name, version);
        if (decls != null && decls.iterator().hasNext()) {
            return decls.iterator().next();
        }
        if (this.storeExternals) {
            return this.fetchAndStoreExternalSpecificSymbol(name, version);
        }
        return super.fetchSpecificSymbol(name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IDeclaration fetchAndStoreExternalSpecificSymbol(String name, PromptoVersion version2) {
        QueryableCodeStore queryableCodeStore = this;
        synchronized (queryableCodeStore) {
            Iterable<IDeclaration> decls = this.fetchSymbolsInStore(name, this.version);
            if (decls != null && decls.iterator().hasNext()) {
                return decls.iterator().next();
            }
            IDeclaration decl = this.getRegisteringSymbol(name);
            if (decl == null) {
                decl = super.fetchSpecificSymbol(name, this.version);
                if (this.store != null && decl != null) {
                    this.setRegisteringDeclarations(decl.getName(), Collections.singletonList(decl));
                    decls = this.storeDeclarations(Collections.singletonList(decl));
                    this.clearRegisteringDeclarations(decl.getName());
                    this.store.flush();
                    decl = decls.iterator().next();
                }
            }
            return decl;
        }
    }

    private Iterable<IDeclaration> fetchSymbolsInStore(String name, PromptoVersion version) {
        IStoredIterable iterable = this.fetchStoredDeclarationsBySymbol(name, version);
        if (iterable.iterator().hasNext()) {
            final Iterator iterator = iterable.iterator();
            return () -> new Iterator<IDeclaration>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public IDeclaration next() {
                    return QueryableCodeStore.this.parseDeclaration((IStored)iterator.next());
                }
            };
        }
        return null;
    }

    private IStoredIterable fetchStoredDeclarationsBySymbol(String name, PromptoVersion version) {
        IQueryBuilder builder = this.store.newQueryBuilder();
        builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.CONTAINS, (Object)"EnumeratedDeclaration");
        builder.verify(AttributeInfo.SYMBOLS, IQueryBuilder.MatchOp.CONTAINS, (Object)name);
        builder.and();
        if (PromptoVersion.LATEST.equals((Object)version)) {
            IdentifierList names = IdentifierList.parse((String)"prototype,version");
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            return this.fetchDistinct(stored);
        }
        return this.store.fetchMany(builder.build());
    }

    private Iterable<IDeclaration> storeDeclarations(Iterable<IDeclaration> decls) throws PromptoError {
        Iterator<IDeclaration> iter = decls.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        IDeclaration decl = iter.next();
        ICodeStore origin = decl.getOrigin();
        if (origin == null) {
            throw new InternalError("Cannot store declaration with no origin!");
        }
        Object moduleId = this.fetchDeclarationModuleDbId(decl);
        if (moduleId == null) {
            moduleId = this.storeDeclarationModule(decl);
        }
        this.storeDeclarations(decls, origin.getModuleDialect(), origin.getModuleVersion(), moduleId);
        return decls;
    }

    public void storeDeclarations(Iterable<IDeclaration> declarations, Dialect dialect, PromptoVersion version, Object moduleId) throws PromptoError {
        ArrayList list = new ArrayList();
        declarations.forEach(decl -> this.collectStorables(list, (IDeclaration)decl, dialect, version, moduleId));
        this.store.store(null, list);
    }

    private Object fetchDeclarationModuleDbId(IDeclaration decl) throws PromptoError {
        ICodeStore origin = decl.getOrigin();
        IStored stored = this.fetchOneNamedInStore(origin.getModuleType().getCategory(), origin.getModuleVersion(), origin.getModuleName());
        if (stored == null) {
            return null;
        }
        return stored.getDbId();
    }

    private IStorable populateDeclarationStorable(List<String> categories, IDeclaration decl, Dialect dialect, PromptoVersion version, Object moduleId) {
        IStorable storable = this.store.newStorable(categories, null);
        try {
            storable.setData("name", (Object)decl.getId().toString());
            storable.setData("version", (Object)version);
            if (decl instanceof IMethodDeclaration) {
                String proto = ((IMethodDeclaration)decl).getProto();
                storable.setData("prototype", (Object)proto);
            }
            storable.setData("dialect", (Object)dialect.name());
            CodeWriter writer = new CodeWriter(dialect, this.context);
            decl.toDialect(writer);
            String content = writer.toString();
            storable.setData("body", (Object)content);
            storable.setData("module", moduleId);
            if (decl instanceof IEnumeratedDeclaration) {
                List symbols = ((IEnumeratedDeclaration)decl).getSymbolsList().stream().map(INamed::getName).collect(Collectors.toList());
                storable.setData("symbols", symbols);
            }
            if (decl.isStorable()) {
                storable.setData("storable", (Object)true);
            }
            return storable;
        }
        catch (PromptoError e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<IDeclaration> fetchDeclarationsInStore(String name, PromptoVersion version) {
        if (this.store == null) {
            return null;
        }
        try {
            CategoryType category = new CategoryType(new Identifier("Declaration"));
            IStoredIterable iterable = this.fetchManyNamedInStore(name, category, version);
            if (iterable.iterator().hasNext()) {
                final Iterator iterator = iterable.iterator();
                return () -> new Iterator<IDeclaration>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public IDeclaration next() {
                        return QueryableCodeStore.this.parseDeclaration((IStored)iterator.next());
                    }
                };
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IStoredIterable fetchManyNamedInStore(String name, CategoryType type, PromptoVersion version) throws PromptoError {
        return this.fetchManyInStore(type, version, "name", name);
    }

    private IStoredIterable fetchManyInStore(CategoryType type, PromptoVersion version, String attribute, String value) throws PromptoError {
        IQueryBuilder builder = this.store.newQueryBuilder();
        if (uniqueDecls.contains(type.toString().toUpperCase())) {
            builder.first(Long.valueOf(1L)).last(Long.valueOf(1L));
        }
        AttributeInfo info = AttributeInfo.CATEGORY;
        builder.verify(info, IQueryBuilder.MatchOp.CONTAINS, (Object)type.getTypeName());
        IPredicateExpression filter = this.buildFilter(version, attribute, value);
        filter.interpretQuery(this.context, builder);
        builder.and();
        if (PromptoVersion.LATEST.equals((Object)version)) {
            IdentifierList names = new IdentifierList(new String[]{"prototype", "version"});
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            return this.fetchDistinct(stored);
        }
        return this.store.fetchMany(builder.build());
    }

    private IStored fetchOneNamedInStore(CategoryType type, PromptoVersion version, String name) throws PromptoError {
        return this.fetchOneInStore(type, version, "name", name);
    }

    private IStored fetchOneInStore(CategoryType type, PromptoVersion version, String attribute, String value) throws PromptoError {
        IQueryBuilder builder = this.store.newQueryBuilder();
        AttributeInfo info = AttributeInfo.CATEGORY;
        builder.verify(info, IQueryBuilder.MatchOp.CONTAINS, (Object)type.getTypeName());
        IPredicateExpression filter = this.buildFilter(version, attribute, value);
        filter.interpretQuery(this.context, builder);
        builder.and();
        if (PromptoVersion.LATEST.equals((Object)version)) {
            IdentifierList names = new IdentifierList("version");
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            builder.first(Long.valueOf(1L)).last(Long.valueOf(1L));
            IStoredIterable iterable = this.store.fetchMany(builder.build());
            Iterator stored = iterable.iterator();
            return stored.hasNext() ? (IStored)stored.next() : null;
        }
        return this.store.fetchOne(builder.build());
    }

    @Override
    public void collectStorableAttributes(Map<String, AttributeDeclaration> map) throws PromptoError {
        super.collectStorableAttributes(map);
        if (this.store != null) {
            IQueryBuilder builder = this.store.newQueryBuilder();
            AttributeInfo info = AttributeInfo.CATEGORY;
            builder.verify(info, IQueryBuilder.MatchOp.CONTAINS, (Object)"AttributeDeclaration");
            info = AttributeInfo.STORABLE;
            builder.verify(info, IQueryBuilder.MatchOp.EQUALS, (Object)true);
            builder.and();
            IStoredIterable iterable = this.store.fetchMany(builder.build());
            Iterator stored = iterable.iterator();
            while (stored.hasNext()) {
                AttributeDeclaration attr = (AttributeDeclaration)this.parseDeclaration((IStored)stored.next());
                map.put(attr.getName(), attr);
            }
        }
    }

    private IStoredIterable fetchDistinct(IStoredIterable iterable) {
        final ArrayList<IStored> distinct = new ArrayList<IStored>();
        Object lastName = null;
        Object lastProto = null;
        for (IStored stored : iterable) {
            Object thisName = stored.getData("name");
            Object thisProto = stored.getData("prototype");
            if (Objects.equals(thisName, lastName) && Objects.equals(thisProto, lastProto)) continue;
            distinct.add(stored);
            lastName = thisName;
            lastProto = thisProto;
        }
        return new IStoredIterable(){

            public Iterator<IStored> iterator() {
                return distinct.iterator();
            }

            public long count() {
                return distinct.size();
            }

            public long totalCount() {
                return distinct.size();
            }
        };
    }

    private IPredicateExpression buildFilter(PromptoVersion version, String attribute, String value) {
        UnresolvedIdentifier left = new UnresolvedIdentifier(new Identifier(attribute));
        TextLiteral right = new TextLiteral("'" + value + "'");
        EqualsExpression filter = new EqualsExpression((IExpression)left, EqOp.EQUALS, (IExpression)right);
        if (!PromptoVersion.LATEST.equals((Object)version)) {
            left = new UnresolvedIdentifier(new Identifier("version"));
            right = new VersionLiteral("'v" + version.toString() + "'");
            EqualsExpression condition = new EqualsExpression((IExpression)left, EqOp.EQUALS, (IExpression)right);
            filter = new AndExpression((IExpression)filter, (IExpression)condition);
        }
        return filter;
    }

    private <T extends IDeclaration> T parseDeclaration(IStored stored) {
        if (stored == null) {
            return null;
        }
        try {
            Dialect dialect = Dialect.valueOf((String)((String)stored.getData("dialect")));
            String body = (String)stored.getData("body");
            ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes());
            DeclarationList decls = ICodeStore.parse((Dialect)dialect, (String)"__store__", (InputStream)input);
            return (T)(decls.isEmpty() ? null : (IDeclaration)decls.get(0));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

