/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.Module;
import prompto.code.Resource;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.ICodeSection;
import prompto.parser.ISection;

public abstract class BaseCodeStore
implements ICodeStore {
    ICodeStore next;

    protected BaseCodeStore(ICodeStore next) {
        this.next = next;
    }

    public ICodeStore getNext() {
        return this.next;
    }

    public void setNext(ICodeStore next) {
        this.next = next;
    }

    public ICodeSection findCodeSection(ISection section) {
        return this.next == null ? null : this.next.findCodeSection(section);
    }

    public Collection<String> fetchDeclarationNames() {
        return this.next == null ? Collections.emptyList() : this.next.fetchDeclarationNames();
    }

    public Iterable<IDeclaration> fetchDeclarations(String name) throws PromptoError {
        return this.next == null ? null : this.next.fetchDeclarations(name);
    }

    public Collection<CategoryDeclaration> fetchDerivedCategoryDeclarations(Identifier id) {
        return this.next == null ? Collections.emptyList() : this.next.fetchDerivedCategoryDeclarations(id);
    }

    public NativeCategoryDeclaration fetchLatestNativeCategoryDeclarationWithJavaBinding(String typeName) {
        return this.next == null ? null : this.next.fetchLatestNativeCategoryDeclarationWithJavaBinding(typeName);
    }

    public Resource fetchResource(String path) throws PromptoError {
        return this.next == null ? null : this.next.fetchResource(path);
    }

    public final Iterable<Resource> fetchResourcesWithMimeTypes(String ... mimeTypes) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        this.doFetchLatestResourcesWithMimeTypes(resources, new HashSet<String>(Arrays.asList(mimeTypes)));
        return resources;
    }

    protected abstract void doFetchLatestResourcesWithMimeTypes(List<Resource> var1, Set<String> var2);

    public IDeclaration fetchLatestSymbol(String name) throws PromptoError {
        IDeclaration decl = super.fetchLatestSymbol(name);
        return decl != null ? decl : (this.next == null ? null : this.next.fetchLatestSymbol(name));
    }

    public IDeclaration fetchVersionedSymbol(String name, PromptoVersion version) throws PromptoError {
        return this.next == null ? null : this.next.fetchVersionedSymbol(name, version);
    }

    public void collectStorableAttributes(Map<String, AttributeDeclaration> columns) throws PromptoError {
        if (this.next != null) {
            this.next.collectStorableAttributes(columns);
        }
    }

    public void setMainModule(String name, PromptoVersion version) {
        if (name != null && version != null) {
            this.registerModule(name, version);
        }
    }

    private void registerModule(String name, PromptoVersion version) {
        Module module = this.fetchModule(name, version);
        if (module != null) {
            try {
                ICodeStore.addModuleDbId((Object)module.getDbId());
                if (module.getDependencies() != null) {
                    module.getDependencies().forEach(this::registerModule);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerModule(Dependency dependency) {
        this.registerModule(dependency.getName(), dependency.getVersion());
    }

    protected abstract Module fetchModule(String var1, PromptoVersion var2);

    public void upgradeIfRequired() {
        if (this.next != null) {
            this.next.upgradeIfRequired();
        }
    }
}

