/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.store.IStore;
import prompto.type.BlobType;
import prompto.type.BooleanType;
import prompto.type.DateTimeType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.TextType;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.TypeUtils;

public class CodeStoreBootstrapper {
    static final Logger logger = new Logger();
    Context context = Context.newGlobalsContext();
    ICodeStore next;
    IStore store;
    static final Set<String> reserved = new HashSet<String>(Arrays.asList("dbId", "category", "storable", "module"));

    public static Context bootstrap(IStore store, ICodeStore runtime) throws PromptoError {
        logger.info(() -> "Initializing code store...");
        CodeStoreBootstrapper bs = new CodeStoreBootstrapper(store, runtime);
        bs.bootstrap();
        return bs.context;
    }

    private CodeStoreBootstrapper(IStore store, ICodeStore runtime) {
        this.store = store;
        URL url = Thread.currentThread().getContextClassLoader().getResource("libraries/CodeStore.pec");
        this.next = new ImmutableCodeStore(runtime, ModuleType.LIBRARY, url, PromptoVersion.parse((String)"1.0.0"));
    }

    private void bootstrap() throws PromptoError {
        Map<String, AttributeDeclaration> columns = this.getMinimalColumns(this.store);
        columns = this.fetchLatestDeclarations(columns);
        this.registerColumnAttributes(columns.values());
        if (this.store != null) {
            Function<Identifier, IDeclaration> locator = id -> {
                Iterator decls = this.next.fetchDeclarations(id.toString()).iterator();
                return decls.hasNext() ? (IDeclaration)decls.next() : null;
            };
            List infos = columns.values().stream().map(c -> c.getAttributeInfo(this.context, locator)).collect(Collectors.toList());
            this.store.createOrUpdateAttributes(infos);
        }
    }

    private void registerColumnAttributes(Collection<AttributeDeclaration> columns) throws PromptoError {
        for (AttributeDeclaration column : columns) {
            column.register(this.context);
        }
    }

    private Map<String, AttributeDeclaration> fetchLatestDeclarations(Map<String, AttributeDeclaration> decls) throws PromptoError {
        try {
            HashMap<String, AttributeDeclaration> latest = new HashMap<String, AttributeDeclaration>();
            for (Map.Entry<String, AttributeDeclaration> entry : decls.entrySet()) {
                latest.put(entry.getKey(), this.fetchAttributeDeclaration(entry.getValue()));
            }
            return latest;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof PromptoError) {
                throw (PromptoError)e.getCause();
            }
            throw e;
        }
    }

    private AttributeDeclaration fetchAttributeDeclaration(AttributeDeclaration column) {
        try {
            if (reserved.contains(column.getName())) {
                return column;
            }
            Iterable decls = this.next.fetchDeclarations(column.getName());
            if (decls == null || !decls.iterator().hasNext()) {
                throw new RuntimeException("Invalid column attribute: " + column.getName());
            }
            IDeclaration decl = (IDeclaration)decls.iterator().next();
            if (!(decl instanceof AttributeDeclaration)) {
                throw new RuntimeException("Invalid column attribute: " + column.getName());
            }
            return (AttributeDeclaration)decl;
        }
        catch (PromptoError e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, AttributeDeclaration> getMinimalColumns(IStore store) {
        IntegerType dbIdIType = store == null ? IntegerType.instance() : TypeUtils.typeToIType((Type)store.getNativeDbIdClass());
        return Stream.of(new AttributeDeclaration(new Identifier("dbId"), (IType)dbIdIType), new AttributeDeclaration(new Identifier("storable"), (IType)BooleanType.instance()), new AttributeDeclaration(new Identifier("category"), (IType)new ListType((IType)TextType.instance()), new IdentifierList(new Identifier("key"))), new AttributeDeclaration(new Identifier("module"), (IType)dbIdIType), new AttributeDeclaration(new Identifier("author"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("timeStamp"), (IType)DateTimeType.instance()), new AttributeDeclaration(new Identifier("name"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("description"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("version"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("prototype"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("dialect"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("body"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("data"), (IType)BlobType.instance()), new AttributeDeclaration(new Identifier("mimeType"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("moduleStatus"), (IType)TextType.instance()), new AttributeDeclaration(new Identifier("parked"), (IType)BooleanType.instance())).map(attr -> attr.withStorable(true)).collect(Collectors.toMap(attr -> attr.getName(), Function.identity()));
    }
}

