/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import prompto.code.BaseCodeStore;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.URLResource;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.error.InvalidResourceError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.Dialect;
import prompto.parser.ICodeSection;
import prompto.parser.ISection;
import prompto.utils.Logger;
import prompto.utils.SectionLocator;

public class ImmutableCodeStore
extends BaseCodeStore {
    static final Logger logger = new Logger();
    ModuleType type;
    URL resource;
    PromptoVersion version;
    Map<String, List<IDeclaration>> declarations = null;

    public static ICodeStore bootstrapRuntime(Supplier<Collection<URL>> runtimeSupplier) {
        logger.info(() -> "Connecting to prompto runtime libraries...");
        try {
            ImmutableCodeStore runtime = null;
            if (runtimeSupplier != null) {
                for (URL resource : runtimeSupplier.get()) {
                    logger.info(() -> "Connecting to library: " + resource.toExternalForm());
                    runtime = new ImmutableCodeStore(runtime, ModuleType.LIBRARY, resource, PromptoVersion.parse((String)"1.0.0"));
                }
            }
            return runtime;
        }
        catch (RuntimeException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    public ImmutableCodeStore(ICodeStore next, ModuleType type, URL resource, PromptoVersion version) {
        super(next);
        if (resource == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.resource = resource;
        this.version = version;
    }

    public String toString() {
        return this.resource.toString();
    }

    public ModuleType getModuleType() {
        return this.type;
    }

    public Dialect getModuleDialect() {
        String external = this.resource.toExternalForm();
        char c = external.charAt(external.length() - 2);
        return Dialect.valueOf((String)String.valueOf(c).toUpperCase());
    }

    public String getModuleName() {
        String moduleName = this.resource.toExternalForm();
        int idx = moduleName.lastIndexOf(47);
        if (idx >= 0) {
            moduleName = moduleName.substring(idx + 1);
        }
        if ((idx = moduleName.indexOf(46)) >= 0) {
            moduleName = moduleName.substring(0, idx);
        }
        return moduleName;
    }

    public PromptoVersion getModuleVersion() {
        return this.version;
    }

    public void storeModule(Module module) throws PromptoError {
        throw new UnsupportedOperationException();
    }

    public void dropModule(Module module) {
        throw new UnsupportedOperationException();
    }

    public void storeDependency(Dependency dependency) {
        throw new UnsupportedOperationException();
    }

    public <T extends Module> T fetchVersionedModule(ModuleType type, String name, PromptoVersion version) throws PromptoError {
        return null;
    }

    @Override
    protected Module fetchModule(String name, PromptoVersion version) {
        return null;
    }

    public Iterable<Module> fetchAllModules() throws PromptoError {
        return Collections.emptyList();
    }

    public Object fetchVersionedModuleDbId(String name, PromptoVersion version) throws PromptoError {
        return null;
    }

    @Override
    public Resource fetchResource(String path) {
        if (this.resource.toString().endsWith(path)) {
            return new URLResource(this.resource);
        }
        return super.fetchResource(path);
    }

    @Override
    protected void doFetchLatestResourcesWithMimeTypes(List<Resource> resources, Set<String> mimeTypes) {
        try {
            URLConnection cnx = this.resource.openConnection();
            if (mimeTypes.contains(cnx.getContentType())) {
                resources.add((Resource)new URLResource(this.resource));
            }
        }
        catch (IOException e) {
            logger.error(() -> "Failed to load resource " + this.resource.toString(), (Throwable)e);
        }
    }

    public void storeDeclarations(Iterable<IDeclaration> declarations, Dialect dialect, Object moduleId) throws PromptoError {
        throw new UnsupportedOperationException();
    }

    public void storeResource(Resource resource, Object moduleId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<IDeclaration> fetchDeclarations(String name) throws PromptoError {
        Iterable<IDeclaration> fetched = this.fetchInResource((Map<String, List<IDeclaration>> decls) -> (List)decls.get(name));
        if (fetched != null) {
            return fetched;
        }
        return super.fetchDeclarations(name);
    }

    @Override
    public NativeCategoryDeclaration fetchLatestNativeCategoryDeclarationWithJavaBinding(String typeName) {
        Iterable<IDeclaration> fetched = this.fetchInResource((Map<String, List<IDeclaration>> decls) -> this.filterNativeCategoryDeclarationWithJavaBinding((Map<String, List<IDeclaration>>)decls, typeName));
        Iterator<IDeclaration> iterator = fetched.iterator();
        if (iterator.hasNext()) {
            return (NativeCategoryDeclaration)iterator.next();
        }
        return super.fetchLatestNativeCategoryDeclarationWithJavaBinding(typeName);
    }

    private Iterable<IDeclaration> filterNativeCategoryDeclarationWithJavaBinding(Map<String, List<IDeclaration>> decls, String typeName) {
        return () -> decls.values().stream().flatMap(Collection::stream).filter(decl -> decl instanceof NativeCategoryDeclaration).map(decl -> (NativeCategoryDeclaration)decl).filter(decl -> typeName.equals(decl.getBoundClassName())).map(decl -> decl).iterator();
    }

    public Iterable<IDeclaration> fetchDeclarationsWithAnnotations(Set<String> annotations) {
        Iterable<IDeclaration> fetched = this.fetchInResource((Map<String, List<IDeclaration>> decls) -> decls.values().stream().flatMap(Collection::stream).filter(d -> d.hasAnyLocalAnnotation(annotations)).collect(Collectors.toList()));
        if (this.next == null) {
            return fetched;
        }
        Iterable decls2 = this.next.fetchDeclarationsWithAnnotations(annotations);
        return Stream.concat(StreamSupport.stream(decls2.spliterator(), false), StreamSupport.stream(fetched.spliterator(), false)).collect(Collectors.toList());
    }

    @Override
    public IDeclaration fetchLatestSymbol(String name) throws PromptoError {
        IDeclaration decl = this.fetchOneSymbol(name);
        if (decl != null) {
            return decl;
        }
        return super.fetchLatestSymbol(name);
    }

    private IDeclaration fetchOneSymbol(String name) {
        Iterator<IDeclaration> fetched = this.fetchInResource((Map<String, List<IDeclaration>> decls) -> decls.values().stream().flatMap(Collection::stream).filter(d -> d instanceof IEnumeratedDeclaration).map(d -> (IEnumeratedDeclaration)d).filter(d -> d.hasSymbol(name)).collect(Collectors.toList())).iterator();
        return fetched.hasNext() ? fetched.next() : null;
    }

    @Override
    public IDeclaration fetchVersionedSymbol(String name, PromptoVersion version) throws PromptoError {
        IDeclaration decl = this.fetchOneSymbol(name);
        if (decl != null) {
            return decl;
        }
        return super.fetchVersionedSymbol(name, version);
    }

    @Override
    public Collection<CategoryDeclaration> fetchDerivedCategoryDeclarations(Identifier id) {
        Stream<CategoryDeclaration> stream1 = super.fetchDerivedCategoryDeclarations(id).stream();
        this.loadResource();
        Stream<CategoryDeclaration> stream2 = this.declarations.values().stream().flatMap(Collection::stream).filter(d -> d instanceof CategoryDeclaration).map(d -> (CategoryDeclaration)d).filter(d -> d.getDerivedFrom() != null).filter(d -> d.getDerivedFrom().contains((Object)id));
        return Stream.concat(stream1, stream2).collect(Collectors.toList());
    }

    @Override
    public ICodeSection findCodeSection(ISection section) {
        ICodeSection result = this.fetchInResource(section);
        if (result != null) {
            return result;
        }
        return super.findCodeSection(section);
    }

    private ICodeSection fetchInResource(ISection section) {
        if (!this.resource.toExternalForm().equals(section.getPath())) {
            return null;
        }
        this.loadResource();
        return SectionLocator.findCodeSectionInLists(this.declarations.values(), (ISection)section);
    }

    private Iterable<IDeclaration> fetchInResource(Function<Map<String, List<IDeclaration>>, Iterable<IDeclaration>> filter) throws PromptoError {
        this.loadResource();
        return filter.apply(this.declarations);
    }

    private void loadResource() throws PromptoError {
        if (this.declarations == null) {
            this.tryLoadResource();
        }
        if (this.declarations == null) {
            throw new InvalidResourceError(this.resource.toExternalForm());
        }
    }

    private void tryLoadResource() {
        try (InputStream input = this.resource.openStream();){
            if (input != null) {
                this.parseResource(input);
            }
        }
        catch (PromptoError error) {
            throw error;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private void parseResource(InputStream input) throws Exception {
        String path = this.resource.toExternalForm();
        Dialect dialect = ICodeStore.dialectFromResourceName((String)path);
        if (dialect != null) {
            DeclarationList decls = ICodeStore.parse((String)this.resource.toExternalForm(), (InputStream)input);
            this.declarations = new HashMap<String, List<IDeclaration>>();
            for (IDeclaration decl : decls) {
                decl.setOrigin((ICodeStore)this);
                String name = decl.getId().toString();
                if (this.declarations.get(name) == null) {
                    this.declarations.put(name, new ArrayList());
                }
                this.declarations.get(name).add(decl);
            }
        } else {
            this.declarations = new HashMap<String, List<IDeclaration>>();
        }
    }

    public Iterable<IDeclaration> getDeclarations() {
        this.loadResource();
        return () -> new Iterator<IDeclaration>(){
            Iterator main;
            Iterator child;
            {
                this.main = ImmutableCodeStore.this.declarations.values().iterator();
                this.child = null;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.child != null) {
                        if (this.child.hasNext()) {
                            return true;
                        }
                        this.child = null;
                    }
                    if (this.child != null) continue;
                    if (!this.main.hasNext()) {
                        return false;
                    }
                    this.child = ((List)this.main.next()).iterator();
                }
            }

            @Override
            public IDeclaration next() {
                return (IDeclaration)this.child.next();
            }
        };
    }

    @Override
    public void collectStorableAttributes(Map<String, AttributeDeclaration> columns) throws PromptoError {
        super.collectStorableAttributes(columns);
        this.loadResource();
        this.declarations.values().forEach(decls -> decls.stream().filter(decl -> decl instanceof AttributeDeclaration).filter(decl -> ((AttributeDeclaration)decl).isStorable(null)).forEach(decl -> columns.put(decl.getName(), (AttributeDeclaration)decl)));
    }

    @Override
    public Collection<String> fetchDeclarationNames() {
        this.loadResource();
        if (this.next == null) {
            return this.declarations.keySet();
        }
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.declarations.keySet());
        names.addAll(this.next.fetchDeclarationNames());
        return names;
    }
}

