/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import prompto.code.AppStoreBootstrapper;
import prompto.code.BaseCodeStore;
import prompto.code.CodeStoreBootstrapper;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.Module;
import prompto.code.ModuleType;
import prompto.code.Resource;
import prompto.code.ResourceReader;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Annotation;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.grammar.OrderByClause;
import prompto.grammar.OrderByClauseList;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.type.CategoryType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.StringUtils;

public class MutableCodeStore
extends BaseCodeStore {
    static final Logger logger = new Logger();
    IStore store;
    String application;
    PromptoVersion version;
    Context context;
    boolean storeExternals = false;
    static ThreadLocal<Map<String, Iterable<IDeclaration>>> registering = new ThreadLocal<Map<String, Iterable<IDeclaration>>>(){

        @Override
        protected Map<String, Iterable<IDeclaration>> initialValue() {
            return new HashMap<String, Iterable<IDeclaration>>();
        }
    };
    private static Set<String> uniqueDecls = new HashSet<String>(Arrays.asList(IDeclaration.DeclarationType.ATTRIBUTE.name(), IDeclaration.DeclarationType.CATEGORY.name(), IDeclaration.DeclarationType.TEST.name()));

    public MutableCodeStore(IStore store, ICodeStore runtime, String application, PromptoVersion version, URL[] addOns, URL ... resourceNames) throws PromptoError {
        super(null);
        this.store = store;
        this.application = application;
        this.version = version;
        this.context = CodeStoreBootstrapper.bootstrap(store, runtime);
        this.next = AppStoreBootstrapper.bootstrap(store, runtime, application, version, addOns, resourceNames);
    }

    public IStore getStore() {
        return this.store;
    }

    public void setStore(IStore store) {
        this.store = store;
    }

    public void collectStorables(List<IStorable> list, IDeclaration declaration, Dialect dialect, Object moduleId) {
        if (declaration instanceof Context.MethodDeclarationMap) {
            for (IDeclaration method : ((Context.MethodDeclarationMap)declaration).values()) {
                this.collectStorables(list, method, dialect, moduleId);
            }
        } else {
            String typeName = StringUtils.capitalizeFirst((String)declaration.getDeclarationType().name()) + "Declaration";
            List<String> categories = Arrays.asList("Resource", "NamedResource", "Declaration", typeName);
            IStorable storable = this.populateDeclarationStorable(categories, declaration, dialect, moduleId);
            list.add(storable);
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.WEBSITE;
    }

    public Dialect getModuleDialect() {
        return null;
    }

    public String getModuleName() {
        return this.application;
    }

    public PromptoVersion getModuleVersion() {
        return this.version;
    }

    public void storeResource(Resource resource, Object moduleId) {
        IStorable storable = resource.toStorable(this.store);
        if (moduleId != null) {
            storable.setData("module", moduleId);
        }
        this.store.store(null, Collections.singletonList(storable));
    }

    public void storeModule(Module module) throws PromptoError {
        Context context = Context.newGlobalsContext();
        ArrayList storables = new ArrayList();
        module.collectStorables(context, this.store, storables);
        this.store.store(null, storables);
    }

    public void storeDependency(Dependency dependency) {
        Context context = Context.newGlobalsContext();
        ArrayList storables = new ArrayList();
        dependency.collectStorables(context, this.store, storables);
        this.store.store(null, storables);
    }

    public void dropModule(Module module) {
        IQueryBuilder builder = this.store.newQueryBuilder();
        builder.verify(AttributeInfo.MODULE, IQueryBuilder.MatchOp.HAS, (Object)module.getDbId());
        IStoredIterable stuff = this.store.fetchMany(builder.build());
        Stream<PromptoDbId> stuffDbIds = StreamSupport.stream(stuff.spliterator(), false).map(IStored::getDbId);
        List dbIds = Stream.concat(Stream.of(module.getDbId()), stuffDbIds).collect(Collectors.toList());
        this.store.delete(dbIds);
    }

    private Object storeDeclarationModule(IDeclaration decl) throws PromptoError {
        ICodeStore origin = decl.getOrigin();
        List<String> categories = Arrays.asList("Module", origin.getModuleType().getCategory().getTypeName());
        IStorable storable = this.store.newStorable(categories, null);
        storable.setData("name", (Object)origin.getModuleName());
        storable.setData("version", (Object)origin.getModuleVersion());
        this.store.store(storable);
        return storable.getOrCreateDbId();
    }

    public Iterable<Module> fetchAllModules() throws PromptoError {
        try {
            IQueryBuilder builder = this.store.newQueryBuilder();
            builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Module");
            final Iterator iterator = this.store.fetchMany(builder.build()).iterator();
            return () -> new Iterator<Module>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Module next() {
                    try {
                        return MutableCodeStore.this.moduleFromStored((IStored)iterator.next());
                    }
                    catch (Exception e) {
                        throw new InternalError(e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Module> T fetchVersionedModule(ModuleType type, String name, PromptoVersion version) throws PromptoError {
        try {
            IStored stored = this.fetchOneNamedInStore(type.getCategory(), version, name, false);
            if (stored == null) {
                return null;
            }
            Module module = (Module)type.getModuleClass().newInstance();
            module.fromStored(this.store, stored);
            return (T)module;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Module fetchModule(String name, PromptoVersion version) throws PromptoError {
        try {
            IStored stored = this.fetchOneNamedInStore(new CategoryType(new Identifier("Module")), version, name, false);
            return this.moduleFromStored(stored);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Module moduleFromStored(IStored stored) throws Exception {
        if (stored == null) {
            return null;
        }
        String[] categories = stored.getCategories();
        String category = categories[categories.length - 1];
        ModuleType type = ModuleType.valueOf((String)category.toUpperCase());
        Module module = (Module)type.getModuleClass().newInstance();
        module.fromStored(this.store, stored);
        return module;
    }

    public Object fetchVersionedModuleDbId(String name, PromptoVersion version) throws PromptoError {
        try {
            IStored stored = this.fetchOneNamedInStore(new CategoryType(new Identifier("Module")), version, name, false);
            return stored == null ? null : stored.getDbId();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Resource fetchResource(String name) {
        try {
            IStored stored = this.fetchOneInStore(new CategoryType(new Identifier("Resource")), null, "name", name, true);
            if (stored == null) {
                return super.fetchResource(name);
            }
            return ResourceReader.readResource(stored);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doFetchLatestResourcesWithMimeTypes(List<Resource> resources, Set<String> mimeTypes) {
        IStoredIterable found = this.fetchManyInStore(new CategoryType(new Identifier("Resource")), null, "mimeType", mimeTypes, true);
        found.forEach(stored -> resources.add(ResourceReader.readResource(stored)));
    }

    private IDeclaration getRegisteringSymbol(String name) {
        return registering.get().values().stream().map(i -> StreamSupport.stream(i.spliterator(), false)).flatMap(Function.identity()).filter(d -> d instanceof IEnumeratedDeclaration).map(d -> (IEnumeratedDeclaration)d).filter(e -> e.hasSymbol(name)).findFirst().orElse(null);
    }

    private Iterable<IDeclaration> getRegisteringDeclarations(String name) {
        return registering.get().get(name);
    }

    private void setRegisteringDeclarations(String name, Iterable<IDeclaration> decl) {
        registering.get().put(name, decl);
    }

    private void clearRegisteringDeclarations(String name) {
        registering.get().remove(name);
    }

    @Override
    public Collection<String> fetchDeclarationNames() {
        return super.fetchDeclarationNames();
    }

    @Override
    public Iterable<IDeclaration> fetchDeclarations(String name) throws PromptoError {
        Iterable<IDeclaration> decls = this.fetchDeclarationsInStore(name);
        if (decls != null) {
            return decls;
        }
        if (this.storeExternals) {
            return this.fetchAndStoreExternalDeclarations(name);
        }
        return super.fetchDeclarations(name);
    }

    public Iterable<IDeclaration> fetchDeclarationsWithAnnotations(Set<String> annotations) {
        final Iterator fetched = this.fetchDeclarationsWithAnnotationsInStore(annotations).iterator();
        Iterable<IDeclaration> parsed = () -> new Iterator<IDeclaration>(){

            @Override
            public boolean hasNext() {
                return fetched.hasNext();
            }

            @Override
            public IDeclaration next() {
                return MutableCodeStore.this.parseDeclaration((IStored)fetched.next());
            }
        };
        if (this.next == null) {
            return parsed;
        }
        Iterable decls = this.next.fetchDeclarationsWithAnnotations(annotations);
        return Stream.concat(StreamSupport.stream(decls.spliterator(), false), StreamSupport.stream(parsed.spliterator(), false)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Iterable<IDeclaration> fetchAndStoreExternalDeclarations(String name) {
        MutableCodeStore mutableCodeStore = this;
        synchronized (mutableCodeStore) {
            Iterable<IDeclaration> decls = this.fetchDeclarationsInStore(name);
            if (decls != null) {
                return decls;
            }
            decls = this.getRegisteringDeclarations(name);
            if (decls != null) {
                return decls;
            }
            decls = super.fetchDeclarations(name);
            if (this.store != null && decls != null && decls.iterator().hasNext()) {
                this.setRegisteringDeclarations(name, decls);
                decls = this.storeDeclarations(decls);
                this.clearRegisteringDeclarations(name);
                this.store.flush();
            }
            return decls;
        }
    }

    @Override
    public IDeclaration fetchVersionedSymbol(String name, PromptoVersion version) throws PromptoError {
        Iterable<IDeclaration> decls = this.fetchSymbolsInStore(name, version, true);
        if (decls != null && decls.iterator().hasNext()) {
            return decls.iterator().next();
        }
        if (this.storeExternals) {
            return this.fetchAndStoreExternalSpecificSymbol(name, version);
        }
        return super.fetchVersionedSymbol(name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IDeclaration fetchAndStoreExternalSpecificSymbol(String name, PromptoVersion version) {
        MutableCodeStore mutableCodeStore = this;
        synchronized (mutableCodeStore) {
            Iterable<IDeclaration> decls = this.fetchSymbolsInStore(name, version, true);
            if (decls != null && decls.iterator().hasNext()) {
                return decls.iterator().next();
            }
            IDeclaration decl = this.getRegisteringSymbol(name);
            if (decl == null) {
                decl = super.fetchVersionedSymbol(name, version);
                if (this.store != null && decl != null) {
                    this.setRegisteringDeclarations(decl.getName(), Collections.singletonList(decl));
                    decls = this.storeDeclarations(Collections.singletonList(decl));
                    this.clearRegisteringDeclarations(decl.getName());
                    this.store.flush();
                    decl = decls.iterator().next();
                }
            }
            return decl;
        }
    }

    private Iterable<IDeclaration> fetchSymbolsInStore(String name, PromptoVersion version, boolean filterOnModules) {
        IStoredIterable iterable = this.fetchStoredDeclarationsBySymbol(name, version, filterOnModules);
        if (iterable.iterator().hasNext()) {
            final Iterator iterator = iterable.iterator();
            return () -> new Iterator<IDeclaration>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public IDeclaration next() {
                    return MutableCodeStore.this.parseDeclaration((IStored)iterator.next());
                }
            };
        }
        return null;
    }

    private IStoredIterable fetchStoredDeclarationsBySymbol(String name, PromptoVersion version, boolean filterOnModules) {
        IQueryBuilder builder = this.store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"EnumeratedDeclaration").verify(AttributeInfo.SYMBOLS, IQueryBuilder.MatchOp.HAS, (Object)name).and();
        builder = this.filterOnModules(builder, filterOnModules);
        if (PromptoVersion.LATEST.equals((Object)version)) {
            IdentifierList names = IdentifierList.parse((String)"prototype,version");
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            return this.fetchDistinct(stored);
        }
        return this.store.fetchMany(builder.build());
    }

    private IQueryBuilder filterOnModules(IQueryBuilder builder, boolean filterOnModules) {
        if (!filterOnModules || ICodeStore.getModuleDbIds().isEmpty()) {
            return builder;
        }
        AttributeInfo info = new AttributeInfo("module", Family.CATEGORY, false, null);
        builder.verify(info, IQueryBuilder.MatchOp.IN, (Object)ICodeStore.getModuleDbIds());
        return builder.and();
    }

    @Override
    public Collection<CategoryDeclaration> fetchDerivedCategoryDeclarations(Identifier id) {
        IQueryBuilder builder = this.store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"CategoryDeclaration").verify(AttributeInfo.DERIVED_FROM, IQueryBuilder.MatchOp.HAS, (Object)id.toString()).and();
        builder = this.filterOnModules(builder, true);
        IdentifierList names = IdentifierList.parse((String)"version");
        OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
        orderBy.interpretQuery(this.context, builder);
        IStoredIterable stored = this.store.fetchMany(builder.build());
        IStoredIterable distinct = this.fetchDistinct(stored);
        return StreamSupport.stream(distinct.spliterator(), false).map(s -> this.parseDeclaration((IStored)s)).filter(d -> d instanceof CategoryDeclaration).map(d -> (CategoryDeclaration)d).collect(Collectors.toList());
    }

    private Iterable<IDeclaration> storeDeclarations(Iterable<IDeclaration> decls) throws PromptoError {
        Iterator<IDeclaration> iter = decls.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        IDeclaration decl = iter.next();
        ICodeStore origin = decl.getOrigin();
        if (origin == null) {
            throw new InternalError("Cannot store declaration with no origin!");
        }
        Object moduleId = this.fetchDeclarationModuleDbId(decl);
        if (moduleId == null) {
            moduleId = this.storeDeclarationModule(decl);
        }
        this.storeDeclarations(decls, origin.getModuleDialect(), moduleId);
        return decls;
    }

    public void storeDeclarations(Iterable<IDeclaration> declarations, Dialect dialect, Object moduleId) throws PromptoError {
        ArrayList list = new ArrayList();
        declarations.forEach(decl -> this.collectStorables(list, (IDeclaration)decl, dialect, moduleId));
        this.store.store(null, list);
    }

    private Object fetchDeclarationModuleDbId(IDeclaration decl) throws PromptoError {
        ICodeStore origin = decl.getOrigin();
        IStored stored = this.fetchOneNamedInStore(origin.getModuleType().getCategory(), origin.getModuleVersion(), origin.getModuleName(), false);
        if (stored == null) {
            return null;
        }
        return stored.getDbId();
    }

    private IStorable populateDeclarationStorable(List<String> categories, IDeclaration decl, Dialect dialect, Object moduleId) {
        IStorable storable = this.store.newStorable(categories, null);
        try {
            Collection annotations;
            storable.setData("name", (Object)decl.getId().toString());
            if (decl instanceof IMethodDeclaration) {
                String proto = ((IMethodDeclaration)decl).getProto();
                storable.setData("prototype", (Object)proto);
            }
            storable.setData("dialect", (Object)dialect.name());
            CodeWriter writer = new CodeWriter(dialect, this.context);
            decl.toDialect(writer);
            String content = writer.toString();
            storable.setData("body", (Object)content);
            storable.setData("module", moduleId);
            if (decl instanceof IEnumeratedDeclaration) {
                List symbols = ((IEnumeratedDeclaration)decl).getSymbolsList().stream().map(INamed::getName).collect(Collectors.toList());
                storable.setData("symbols", symbols);
            }
            if (decl.isStorable(null)) {
                storable.setData("storable", (Object)true);
            }
            if ((annotations = decl.getLocalAnnotations()) != null && !annotations.isEmpty()) {
                List data = annotations.stream().map(Annotation::toString).collect(Collectors.toList());
                storable.setData("annotations", data);
            }
            return storable;
        }
        catch (PromptoError e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<IDeclaration> fetchDeclarationsInStore(String name) {
        if (this.store == null) {
            return null;
        }
        try {
            CategoryType category = new CategoryType(new Identifier("Declaration"));
            IStoredIterable iterable = this.fetchManyInStore(category, null, "name", name, true);
            if (iterable.iterator().hasNext()) {
                final Iterator iterator = iterable.iterator();
                return () -> new Iterator<IDeclaration>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public IDeclaration next() {
                        return MutableCodeStore.this.parseDeclaration((IStored)iterator.next());
                    }
                };
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IStoredIterable fetchDeclarationsWithAnnotationsInStore(Set<String> annotations) {
        if (this.store == null) {
            return null;
        }
        try {
            IQueryBuilder builder = this.store.newQueryBuilder();
            builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Declaration");
            builder.verify(AttributeInfo.ANNOTATIONS, IQueryBuilder.MatchOp.HAS_ANY, annotations);
            builder.and();
            builder = this.filterOnModules(builder, true);
            IdentifierList names = new IdentifierList(new String[]{"prototype", "version"});
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            return this.fetchDistinct(stored);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NativeCategoryDeclaration fetchLatestNativeCategoryDeclarationWithJavaBinding(String typeName) {
        if (this.store == null) {
            return null;
        }
        try {
            IQueryBuilder builder = this.store.newQueryBuilder();
            builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"NativeCategoryDeclaration");
            builder = this.filterOnModules(builder, true);
            IdentifierList names = new IdentifierList("version");
            OrderByClauseList orderBy = new OrderByClauseList(new OrderByClause(names, true));
            orderBy.interpretQuery(this.context, builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            NativeCategoryDeclaration decl = this.filterNativeCategoryDeclarationWithJavaBinding(stored, typeName);
            if (decl != null) {
                return decl;
            }
            return super.fetchLatestNativeCategoryDeclarationWithJavaBinding(typeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private NativeCategoryDeclaration filterNativeCategoryDeclarationWithJavaBinding(IStoredIterable iterable, String typeName) {
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            NativeCategoryDeclaration decl = (NativeCategoryDeclaration)this.parseDeclaration((IStored)iterator.next());
            if (!typeName.equals(decl.getBoundClassName())) continue;
            return decl;
        }
        return null;
    }

    private IStoredIterable fetchManyInStore(CategoryType type, PromptoVersion version, String attribute, Object value, boolean filterOnModules) throws PromptoError {
        IQueryBuilder builder = this.store.newQueryBuilder();
        if (uniqueDecls.contains(type.toString().toUpperCase())) {
            builder.first(Long.valueOf(1L)).last(Long.valueOf(1L));
        }
        builder = this.verifyCategory(builder, type);
        builder = this.verifyVersion(builder, version);
        builder = this.verifyAttribute(builder, attribute, value);
        builder = this.filterOnModules(builder, filterOnModules);
        if (PromptoVersion.LATEST.equals((Object)version)) {
            builder = this.orderByVersion(builder);
            IStoredIterable stored = this.store.fetchMany(builder.build());
            return this.fetchDistinct(stored);
        }
        return this.store.fetchMany(builder.build());
    }

    private IQueryBuilder verifyCategory(IQueryBuilder builder, CategoryType type) {
        return builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)type.getTypeName());
    }

    private IQueryBuilder verifyVersion(IQueryBuilder builder, PromptoVersion version) {
        if (version == null || PromptoVersion.LATEST.equals((Object)version)) {
            return builder;
        }
        return builder.verify(AttributeInfo.VERSION, IQueryBuilder.MatchOp.EQUALS, (Object)version).and();
    }

    private IQueryBuilder orderByVersion(IQueryBuilder builder) {
        OrderByClauseList orderBy = new OrderByClauseList();
        orderBy.add((Object)new OrderByClause(new IdentifierList("prototype"), false));
        orderBy.add((Object)new OrderByClause(new IdentifierList("version"), true));
        return orderBy.interpretQuery(this.context, builder);
    }

    private IQueryBuilder verifyAttribute(IQueryBuilder builder, String attribute, Object value) {
        AttributeInfo info = this.fetchAttributeInfo(this.context, attribute);
        IQueryBuilder.MatchOp op = value instanceof Collection ? IQueryBuilder.MatchOp.IN : IQueryBuilder.MatchOp.EQUALS;
        return builder.verify(info, op, value).and();
    }

    private IStored fetchOneNamedInStore(CategoryType type, PromptoVersion version, String name, boolean filterOnModules) throws PromptoError {
        return this.fetchOneInStore(type, version, "name", name, filterOnModules);
    }

    private IStored fetchOneInStore(CategoryType type, PromptoVersion version, String attribute, String value, boolean filterOnModules) throws PromptoError {
        IQueryBuilder builder = this.store.newQueryBuilder();
        builder = this.verifyCategory(builder, type);
        builder = this.verifyVersion(builder, version);
        builder = this.verifyAttribute(builder, attribute, value);
        builder = this.filterOnModules(builder, filterOnModules);
        if (PromptoVersion.LATEST.equals((Object)version)) {
            builder = this.orderByVersion(builder);
            builder.first(Long.valueOf(1L)).last(Long.valueOf(1L));
            IStoredIterable iterable = this.store.fetchMany(builder.build());
            Iterator stored = iterable.iterator();
            return stored.hasNext() ? (IStored)stored.next() : null;
        }
        return this.store.fetchOne(builder.build());
    }

    @Override
    public void collectStorableAttributes(Map<String, AttributeDeclaration> map) throws PromptoError {
        super.collectStorableAttributes(map);
        if (this.store != null) {
            IQueryBuilder builder = this.store.newQueryBuilder();
            builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"AttributeDeclaration");
            builder.verify(AttributeInfo.STORABLE, IQueryBuilder.MatchOp.EQUALS, (Object)true);
            builder.and();
            builder = this.filterOnModules(builder, true);
            IStoredIterable iterable = this.store.fetchMany(builder.build());
            Iterator stored = iterable.iterator();
            while (stored.hasNext()) {
                AttributeDeclaration attr = (AttributeDeclaration)this.parseDeclaration((IStored)stored.next());
                map.put(attr.getName(), attr);
            }
        }
    }

    private IStoredIterable fetchDistinct(IStoredIterable iterable) {
        final ArrayList<IStored> distinct = new ArrayList<IStored>();
        Object lastName = null;
        Object lastProto = null;
        for (IStored stored : iterable) {
            Object thisName = stored.getData("name");
            Object thisProto = stored.getData("prototype");
            if (Objects.equals(thisName, lastName) && Objects.equals(thisProto, lastProto)) continue;
            distinct.add(stored);
            lastName = thisName;
            lastProto = thisProto;
        }
        return new IStoredIterable(){

            public Iterator<IStored> iterator() {
                return distinct.iterator();
            }

            public long count() {
                return distinct.size();
            }

            public long totalCount() {
                return distinct.size();
            }
        };
    }

    private <T extends IDeclaration> T parseDeclaration(IStored stored) {
        if (stored == null) {
            return null;
        }
        try {
            logger.debug(() -> "Found " + stored.getData("name") + " with dbId " + stored.getDbId());
            Dialect dialect = Dialect.valueOf((String)((String)stored.getData("dialect")));
            String body = (String)stored.getData("body");
            ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes());
            DeclarationList decls = ICodeStore.parse((Dialect)dialect, (String)"__store__", (InputStream)input);
            return (T)(decls.isEmpty() ? null : (IDeclaration)decls.get(0));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void upgradeIfRequired() {
        this.upgradeDerivedFrom();
        this.upgradeVersionQualifiers();
        this.dropResourceVersions();
        super.upgradeIfRequired();
    }

    private void dropResourceVersions() {
        HashMap<String, Boolean> config = this.store.fetchConfiguration("CodeStoreConfiguration");
        if (config == null) {
            config = new HashMap<String, Boolean>();
        }
        if (config.containsKey("resourceVersions")) {
            return;
        }
        logger.info(() -> "Upgrading code store for resourceVersions...");
        IQueryBuilder builder = this.store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"Resource").verify(AttributeInfo.VERSION, IQueryBuilder.MatchOp.EQUALS, null).not().and();
        IStoredIterable stored = this.store.fetchMany(builder.build());
        StreamSupport.stream(stored.spliterator(), false).forEach(this::dropResourceVersion);
        config.put("resourceVersions", true);
        this.store.storeConfiguration("CodeStoreConfiguration", config);
        logger.info(() -> "Code store upgraded for resourceVersions");
    }

    private void dropResourceVersion(IStored stored) {
        Object value = stored.getRawData("version");
        if (value != null) {
            IStorable storable = this.store.newStorable(stored.getCategories(), IStorable.IDbIdFactory.of(() -> stored.getDbId(), null, () -> true));
            storable.removeData("version");
            this.store.store(storable);
        }
    }

    private void upgradeVersionQualifiers() {
        HashMap<String, Boolean> config = this.store.fetchConfiguration("CodeStoreConfiguration");
        if (config == null) {
            config = new HashMap<String, Boolean>();
        }
        if (config.containsKey("versionQualifiers")) {
            return;
        }
        logger.info(() -> "Upgrading code store for versionQualifiers...");
        IQueryBuilder builder = this.store.newQueryBuilder().verify(AttributeInfo.VERSION, IQueryBuilder.MatchOp.EQUALS, null).not();
        IStoredIterable stored = this.store.fetchMany(builder.build());
        StreamSupport.stream(stored.spliterator(), false).forEach(this::upgradeVersionQualifiers);
        config.put("versionQualifiers", true);
        this.store.storeConfiguration("CodeStoreConfiguration", config);
        logger.info(() -> "Code store upgraded for versionQualifiers");
    }

    private void upgradeVersionQualifiers(IStored stored) {
        Object value = stored.getRawData("version");
        if (value instanceof Integer) {
            PromptoVersion version = PromptoVersion.parseInt((int)((Integer)value));
            IStorable storable = this.store.newStorable(stored.getCategories(), IStorable.IDbIdFactory.of(() -> stored.getDbId(), null, () -> true));
            storable.setData("version", (Object)version.asInt());
            this.store.store(storable);
        }
    }

    private void upgradeDerivedFrom() {
        HashMap<String, Boolean> config = this.store.fetchConfiguration("CodeStoreConfiguration");
        if (config == null) {
            config = new HashMap<String, Boolean>();
        }
        if (config.containsKey("derivedFrom")) {
            return;
        }
        logger.info(() -> "Upgrading code store for derivedFrom attribute...");
        IQueryBuilder builder = this.store.newQueryBuilder().verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, (Object)"CategoryDeclaration");
        IStoredIterable stored = this.store.fetchMany(builder.build());
        StreamSupport.stream(stored.spliterator(), false).forEach(this::upgradeDerivedFrom);
        config.put("derivedFrom", true);
        this.store.storeConfiguration("CodeStoreConfiguration", config);
        logger.info(() -> "Code store upgraded or derivedFrom attribute");
    }

    private void upgradeDerivedFrom(final IStored stored) {
        IdentifierList derivedFrom;
        Object decl = this.parseDeclaration(stored);
        if (decl instanceof CategoryDeclaration && (derivedFrom = ((CategoryDeclaration)decl).getDerivedFrom()) != null && !derivedFrom.isEmpty()) {
            List names = derivedFrom.stream().map(Object::toString).collect(Collectors.toList());
            IStorable storable = this.store.newStorable(stored.getCategories(), new IStorable.IDbIdFactory(){

                public void accept(PromptoDbId t) {
                }

                public PromptoDbId get() {
                    return stored.getDbId();
                }

                public boolean isUpdate() {
                    return true;
                }
            });
            storable.setData("derivedFrom", names);
            stored.getNames().forEach(name -> storable.setData(name, stored.getData(name)));
            this.store.store(storable);
        }
    }
}

