/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import prompto.code.BinaryResource;
import prompto.code.Resource;
import prompto.code.TextResource;
import prompto.intrinsic.PromptoBinary;
import prompto.store.IStored;

public abstract class ResourceReader {
    public static Resource readResource(IStored stored) {
        TextResource resource = null;
        if (stored.hasData("body")) {
            resource = new TextResource();
            resource.setBody((String)stored.getData("body"));
        } else if (stored.hasData("data")) {
            resource = new BinaryResource();
            ((BinaryResource)resource).setData((PromptoBinary)stored.getData("data"));
        }
        if (resource != null) {
            resource.setMimeType((String)stored.getData("mimeType"));
            resource.setName((String)stored.getData("name"));
            Long value = (Long)stored.getData("timeStamp");
            if (value != null) {
                resource.setLastModified(OffsetDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC));
            }
        }
        return resource;
    }
}

