/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.store.IStore;
import prompto.type.BlobType;
import prompto.type.BooleanType;
import prompto.type.DateTimeType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.TextType;
import prompto.utils.IdentifierList;
import prompto.utils.Logger;
import prompto.utils.TypeUtils;

public class CodeStoreBootstrapper {
    static final Logger logger = new Logger();
    Context context = Context.newGlobalContext();
    ICodeStore next;
    IStore store;
    static final Set<String> reserved = new HashSet<String>(Arrays.asList("dbId", "category", "storable", "module"));

    public static Context bootstrap(IStore store, ICodeStore runtime) throws PromptoError {
        logger.info(() -> "Initializing code store...");
        CodeStoreBootstrapper bs = new CodeStoreBootstrapper(store, runtime);
        bs.bootstrap();
        return bs.context;
    }

    private CodeStoreBootstrapper(IStore store, ICodeStore runtime) {
        this.store = store;
        URL url = Thread.currentThread().getContextClassLoader().getResource("libraries/CodeStore.pec");
        this.next = new ImmutableCodeStore(runtime, ModuleType.LIBRARY, url, PromptoVersion.parse((String)"1.0.0"));
    }

    private void bootstrap() throws PromptoError {
        Map<String, AttributeDeclaration> columns = this.getMinimalColumns(this.store);
        columns = this.fetchLatestDeclarations(columns);
        this.registerColumnAttributes(columns.values());
        if (this.store != null) {
            List infos = columns.values().stream().map(c -> c.getAttributeInfo(this.context)).collect(Collectors.toList());
            this.store.createOrUpdateAttributes(infos);
        }
    }

    private void registerColumnAttributes(Collection<AttributeDeclaration> columns) throws PromptoError {
        for (AttributeDeclaration column : columns) {
            column.register(this.context);
        }
    }

    private Map<String, AttributeDeclaration> fetchLatestDeclarations(Map<String, AttributeDeclaration> decls) throws PromptoError {
        try {
            HashMap<String, AttributeDeclaration> latest = new HashMap<String, AttributeDeclaration>();
            for (Map.Entry<String, AttributeDeclaration> entry : decls.entrySet()) {
                latest.put(entry.getKey(), this.fetchLatestDeclaration(entry.getValue()));
            }
            return latest;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof PromptoError) {
                throw (PromptoError)e.getCause();
            }
            throw e;
        }
    }

    private AttributeDeclaration fetchLatestDeclaration(AttributeDeclaration column) {
        try {
            if (reserved.contains(column.getName())) {
                return column;
            }
            Iterable decls = this.next.fetchLatestDeclarations(column.getName());
            if (decls == null || !decls.iterator().hasNext()) {
                throw new RuntimeException("Invalid column attribute: " + column.getName());
            }
            IDeclaration decl = (IDeclaration)decls.iterator().next();
            if (!(decl instanceof AttributeDeclaration)) {
                throw new RuntimeException("Invalid column attribute: " + column.getName());
            }
            return (AttributeDeclaration)decl;
        }
        catch (PromptoError e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, AttributeDeclaration> getMinimalColumns(IStore store) {
        IntegerType dbIdIType = store == null ? IntegerType.instance() : TypeUtils.typeToIType((Type)store.getDbIdClass());
        HashMap<String, AttributeDeclaration> columns = new HashMap<String, AttributeDeclaration>();
        columns.put("dbId", new AttributeDeclaration(new Identifier("dbId"), (IType)dbIdIType));
        columns.put("storable", new AttributeDeclaration(new Identifier("storable"), (IType)BooleanType.instance()));
        columns.put("category", new AttributeDeclaration(new Identifier("category"), (IType)new ListType((IType)TextType.instance()), new IdentifierList(new Identifier("key"))));
        columns.put("module", new AttributeDeclaration(new Identifier("module"), (IType)dbIdIType));
        columns.put("author", new AttributeDeclaration(new Identifier("author"), (IType)TextType.instance()));
        columns.put("timeStamp", new AttributeDeclaration(new Identifier("timeStamp"), (IType)DateTimeType.instance()));
        columns.put("name", new AttributeDeclaration(new Identifier("name"), (IType)TextType.instance()));
        columns.put("description", new AttributeDeclaration(new Identifier("description"), (IType)TextType.instance()));
        columns.put("version", new AttributeDeclaration(new Identifier("version"), (IType)TextType.instance()));
        columns.put("prototype", new AttributeDeclaration(new Identifier("prototype"), (IType)TextType.instance()));
        columns.put("dialect", new AttributeDeclaration(new Identifier("dialect"), (IType)TextType.instance()));
        columns.put("body", new AttributeDeclaration(new Identifier("body"), (IType)TextType.instance()));
        columns.put("data", new AttributeDeclaration(new Identifier("data"), (IType)BlobType.instance()));
        columns.put("mimeType", new AttributeDeclaration(new Identifier("mimeType"), (IType)TextType.instance()));
        return columns;
    }
}

