/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.mongodb.client.MongoIterable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import prompto.config.IConfigurationReader;
import prompto.config.IHostConfiguration;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.YamlConfigurationReader;
import prompto.config.mongo.IMongoReplicaSetConfiguration;
import prompto.config.mongo.IMongoStoreConfiguration;
import prompto.config.mongo.MongoStoreConfiguration;
import prompto.store.mongo.MongoStore;
import prompto.utils.ManualTests;

@Category(value={ManualTests.class})
public class TestConfig {
    @Test
    public void testCanConnectUsingReplicaSetURI() throws Exception {
        IMongoStoreConfiguration config = new IMongoStoreConfiguration(){

            public String getFactory() {
                return null;
            }

            public String getHost() {
                return null;
            }

            public Integer getPort() {
                return null;
            }

            public String getDbName() {
                return "admin";
            }

            public String getUser() {
                return "ping";
            }

            public IStoreConfiguration withDbName(String dbName) {
                return null;
            }

            public ISecretKeyConfiguration getSecretKeyConfiguration() {
                return new ISecretKeyConfiguration(){

                    public String getFactory() {
                        return "prompto.security.PlainSecretKeyFactory";
                    }

                    public char[] getSecret() {
                        return "ping".toCharArray();
                    }
                };
            }

            public String getReplicaSetURI() {
                return "mongodb://seed-shard-00-00-cp8j5.mongodb.net:27017,seed-shard-00-01-cp8j5.mongodb.net:27017,seed-shard-00-02-cp8j5.mongodb.net:27017/test?ssl=true&replicaSet=Seed-shard-0&authSource=admin";
            }

            public IMongoStoreConfiguration withReplicaSetURI(String uri) {
                return null;
            }

            public IMongoReplicaSetConfiguration getReplicaSetConfiguration() {
                return null;
            }

            public IMongoStoreConfiguration withReplicaSetConfiguration(IMongoReplicaSetConfiguration config) {
                return null;
            }
        };
        MongoStore store = new MongoStore(config);
        MongoIterable names = store.client.getDatabase("admin").listCollectionNames();
        store.close();
        Assert.assertNotNull((Object)names);
    }

    @Test
    public void testCanConnectUsingReplicaSet() throws Exception {
        IMongoStoreConfiguration config = new IMongoStoreConfiguration(){
            String replicaSetURI;

            public String getFactory() {
                return null;
            }

            public String getHost() {
                return null;
            }

            public Integer getPort() {
                return null;
            }

            public String getDbName() {
                return "admin";
            }

            public String getUser() {
                return "ping";
            }

            public IStoreConfiguration withDbName(String dbName) {
                return null;
            }

            public ISecretKeyConfiguration getSecretKeyConfiguration() {
                return new ISecretKeyConfiguration(){

                    public String getFactory() {
                        return "prompto.security.PlainSecretKeyFactory";
                    }

                    public char[] getSecret() {
                        return "ping".toCharArray();
                    }
                };
            }

            public String getReplicaSetURI() {
                return this.replicaSetURI;
            }

            public IMongoStoreConfiguration withReplicaSetURI(String uri) {
                this.replicaSetURI = uri;
                return this;
            }

            public IMongoReplicaSetConfiguration getReplicaSetConfiguration() {
                return new IMongoReplicaSetConfiguration(){

                    public Iterable<IHostConfiguration> getNodes() {
                        return Arrays.asList(new IHostConfiguration(){

                            public String getHost() {
                                return "seed-shard-00-00-cp8j5.mongodb.net";
                            }

                            public Integer getPort() {
                                return 27017;
                            }

                            public YamlElement toYaml() throws YamlException {
                                return null;
                            }
                        }, new IHostConfiguration(){

                            public String getHost() {
                                return "seed-shard-00-01-cp8j5.mongodb.net";
                            }

                            public Integer getPort() {
                                return 27017;
                            }

                            public YamlElement toYaml() throws YamlException {
                                return null;
                            }
                        }, new IHostConfiguration(){

                            public String getHost() {
                                return "seed-shard-00-02-cp8j5.mongodb.net";
                            }

                            public Integer getPort() {
                                return 27017;
                            }

                            public YamlElement toYaml() throws YamlException {
                                return null;
                            }
                        });
                    }

                    public boolean isSSL() {
                        return true;
                    }

                    public String getName() {
                        return "Seed-shard-0";
                    }

                    public YamlMapping toYaml() throws YamlException {
                        return null;
                    }
                };
            }

            public IMongoStoreConfiguration withReplicaSetConfiguration(IMongoReplicaSetConfiguration config) {
                return null;
            }
        };
        MongoStore store = new MongoStore(config);
        MongoIterable names = store.client.getDatabase("admin").listCollectionNames();
        store.close();
        Assert.assertNotNull((Object)names);
    }

    @Ignore
    @Test
    public void testCanReadYamlReplicaSetConfig() throws Exception {
        try (FileInputStream input = new FileInputStream("/Users/ericvergnaud/Development/prompto/prompto-deploy/aws/deploy-prompto-seed.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader((InputStream)input);
            reader = reader.getObject("codeStore");
            MongoStoreConfiguration config = new MongoStoreConfiguration((IConfigurationReader)reader);
            IMongoReplicaSetConfiguration rs = config.getReplicaSetConfiguration();
            Assert.assertNotNull((Object)rs);
            Assert.assertEquals((Object)"Seed-shard-0", (Object)rs.getName());
            Iterable nodes = rs.getNodes();
            Assert.assertNotNull((Object)nodes);
            AtomicInteger count = new AtomicInteger();
            nodes.forEach(n -> {
                Assert.assertEquals((long)27017L, (long)n.getPort().intValue());
                Assert.assertTrue((boolean)n.getHost().startsWith("Seed-shard-"));
                Assert.assertTrue((boolean)n.getHost().endsWith("-cp8j5.mongodb.net"));
                count.incrementAndGet();
            });
            Assert.assertEquals((long)3L, (long)count.get());
        }
    }
}

