/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.mongo;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.esotericsoftware.yamlbeans.document.YamlSequence;
import java.util.Collection;
import java.util.Iterator;
import prompto.config.HostConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IHostConfiguration;
import prompto.config.mongo.IMongoReplicaSetConfiguration;

public class MongoReplicaSetConfiguration
implements IMongoReplicaSetConfiguration {
    IConfigurationReader reader;

    public MongoReplicaSetConfiguration(IConfigurationReader reader) {
        this.reader = reader;
    }

    @Override
    public String getName() {
        return this.reader.getString("name");
    }

    @Override
    public boolean isSSL() {
        return this.reader.getBooleanOrDefault("ssl", true);
    }

    @Override
    public Iterable<IHostConfiguration> getNodes() {
        final Collection nodes = this.reader.getObjectsArray("nodes");
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        return new Iterable<IHostConfiguration>(){

            @Override
            public Iterator<IHostConfiguration> iterator() {
                final Iterator readers = nodes.iterator();
                return new Iterator<IHostConfiguration>(){

                    @Override
                    public boolean hasNext() {
                        return readers.hasNext();
                    }

                    @Override
                    public IHostConfiguration next() {
                        return new HostConfiguration((IConfigurationReader)readers.next());
                    }
                };
            }
        };
    }

    @Override
    public YamlMapping toYaml() throws YamlException {
        YamlMapping yaml = new YamlMapping();
        yaml.setEntry("name", this.getName());
        yaml.setEntry("ssl", this.isSSL());
        Iterable<IHostConfiguration> nodes = this.getNodes();
        YamlSequence sequence = new YamlSequence();
        for (IHostConfiguration host : nodes) {
            sequence.addElement(host.toYaml());
        }
        yaml.setEntry("nodes", (YamlElement)sequence);
        return yaml;
    }
}

