/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.mongo;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.function.Supplier;
import prompto.config.IConfigurationReader;
import prompto.config.StoreConfiguration;
import prompto.config.mongo.IMongoReplicaSetConfiguration;
import prompto.config.mongo.IMongoStoreConfiguration;
import prompto.config.mongo.MongoReplicaSetConfiguration;

public class MongoStoreConfiguration
extends StoreConfiguration
implements IMongoStoreConfiguration {
    Supplier<String> replicaSetURI;
    Supplier<IMongoReplicaSetConfiguration> replicaSetConfig;

    public MongoStoreConfiguration(IConfigurationReader reader) {
        super(reader);
        this.port = () -> reader.getIntegerOrDefault("port", 27017);
        this.replicaSetURI = () -> reader.getString("replicaSetURI");
        this.replicaSetConfig = () -> {
            IConfigurationReader child = reader.getObject("replicaSet");
            return child == null ? null : new MongoReplicaSetConfiguration(child);
        };
    }

    @Override
    public String getReplicaSetURI() {
        return this.replicaSetURI.get();
    }

    @Override
    public IMongoReplicaSetConfiguration getReplicaSetConfiguration() {
        return this.replicaSetConfig.get();
    }

    @Override
    public IMongoStoreConfiguration withReplicaSetURI(String uri) {
        this.replicaSetURI = () -> uri;
        return this;
    }

    @Override
    public IMongoStoreConfiguration withReplicaSetConfiguration(IMongoReplicaSetConfiguration config) {
        this.replicaSetConfig = () -> config;
        return this;
    }

    public YamlMapping toYaml() throws YamlException {
        YamlMapping mapping = super.toYaml();
        IMongoReplicaSetConfiguration config = this.replicaSetConfig.get();
        if (config != null) {
            mapping.deleteEntry("host");
            mapping.deleteEntry("port");
            mapping.setEntry("replicaSet", (YamlElement)config.toYaml());
        } else if (this.replicaSetURI.get() != null) {
            mapping.deleteEntry("host");
            mapping.deleteEntry("port");
            mapping.setEntry("replicaSetURI", this.replicaSetURI.get());
        }
        return mapping;
    }
}

