/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.mongo.MongoQuery;

public class MongoQueryBuilder
implements IQueryBuilder {
    static Map<IQueryBuilder.MatchOp, BiFunction<AttributeInfo, Object, Bson>> verifiers = new HashMap<IQueryBuilder.MatchOp, BiFunction<AttributeInfo, Object, Bson>>();
    Stack<Bson> predicates = new Stack();
    List<Bson> orderBys = null;
    Long first;
    Long last;

    static Bson verifyEQUALS(AttributeInfo info, Object value) {
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyROUGHLY(AttributeInfo info, Object value) {
        if (info.getFamily() == Family.TEXT) {
            return Filters.regex((String)info.getName(), (String)value.toString(), (String)"i");
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyCONTAINS(AttributeInfo info, Object value) {
        if (info.getFamily() == Family.TEXT) {
            return Filters.regex((String)MongoQueryBuilder.getAttributeName(info), (String)(".*" + value + ".*"), (String)"i");
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyHAS(AttributeInfo info, Object value) {
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyIN(AttributeInfo info, Object value) {
        if (value instanceof Collection) {
            return Filters.or((Iterable)((Collection)value).stream().map(v -> Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)v)).collect(Collectors.toList()));
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyGREATER(AttributeInfo info, Object value) {
        return Filters.gt((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verifyLESSER(AttributeInfo info, Object value) {
        return Filters.lt((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    private static String getAttributeName(AttributeInfo info) {
        String name = info.getName();
        return "dbId".equals(name) ? "_id" : name;
    }

    public <T> MongoQueryBuilder verify(AttributeInfo info, IQueryBuilder.MatchOp match, T fieldValue) {
        Bson predicate = verifiers.get(match).apply(info, fieldValue);
        this.predicates.push(predicate);
        return this;
    }

    public MongoQueryBuilder and() {
        Bson right = this.predicates.pop();
        Bson left = this.predicates.pop();
        this.predicates.push(Filters.and((Bson[])new Bson[]{left, right}));
        return this;
    }

    public MongoQueryBuilder or() {
        Bson right = this.predicates.pop();
        Bson left = this.predicates.pop();
        this.predicates.push(Filters.or((Bson[])new Bson[]{left, right}));
        return this;
    }

    public MongoQueryBuilder not() {
        Bson top = this.predicates.pop();
        this.predicates.push(Filters.not((Bson)top));
        return this;
    }

    public MongoQueryBuilder first(Long first) {
        this.first = first;
        return this;
    }

    public MongoQueryBuilder last(Long last) {
        this.last = last;
        return this;
    }

    public MongoQueryBuilder orderBy(AttributeInfo attribute, boolean descending) {
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<Bson>();
        }
        Bson orderBy = descending ? Sorts.descending((String[])new String[]{attribute.getName()}) : Sorts.ascending((String[])new String[]{attribute.getName()});
        this.orderBys.add(orderBy);
        return this;
    }

    public IQuery build() {
        Bson predicate;
        Bson bson = predicate = this.predicates.empty() ? null : this.predicates.pop();
        if (!this.predicates.empty()) {
            throw new IllegalStateException("Unused query predicates!");
        }
        return new MongoQuery(predicate, this.first, this.last, this.orderBys);
    }

    static {
        verifiers.put(IQueryBuilder.MatchOp.EQUALS, MongoQueryBuilder::verifyEQUALS);
        verifiers.put(IQueryBuilder.MatchOp.ROUGHLY, MongoQueryBuilder::verifyROUGHLY);
        verifiers.put(IQueryBuilder.MatchOp.CONTAINS, MongoQueryBuilder::verifyCONTAINS);
        verifiers.put(IQueryBuilder.MatchOp.HAS, MongoQueryBuilder::verifyHAS);
        verifiers.put(IQueryBuilder.MatchOp.IN, MongoQueryBuilder::verifyIN);
        verifiers.put(IQueryBuilder.MatchOp.GREATER, MongoQueryBuilder::verifyGREATER);
        verifiers.put(IQueryBuilder.MatchOp.LESSER, MongoQueryBuilder::verifyLESSER);
    }
}

