/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.WriteModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.mongo.IMongoReplicaSetConfiguration;
import prompto.config.mongo.IMongoStoreConfiguration;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.security.ISecretKeyFactory;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.mongo.BinaryData;
import prompto.store.mongo.MongoQuery;
import prompto.store.mongo.MongoQueryBuilder;
import prompto.store.mongo.PromptoDateCodec;
import prompto.store.mongo.PromptoDateTimeCodec;
import prompto.store.mongo.PromptoTimeCodec;
import prompto.store.mongo.PromptoVersionCodec;
import prompto.store.mongo.StorableDocument;
import prompto.store.mongo.StoredDocument;
import prompto.store.mongo.StringArrayCodec;
import prompto.utils.Logger;

public class MongoStore
implements IStore {
    static final Logger logger = new Logger();
    static final String AUTH_DB_NAME = "admin";
    static final CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new PromptoDateCodec(), new PromptoTimeCodec(), new PromptoDateTimeCodec(), new PromptoVersionCodec(), new UuidCodec(UuidRepresentation.STANDARD), new StringArrayCodec()}), MongoClient.getDefaultCodecRegistry()});
    MongoClient client;
    MongoDatabase db;
    Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
    static final Map<Family, Function<Object, Object>> readers = new HashMap<Family, Function<Object, Object>>();

    public MongoStore(IMongoStoreConfiguration config) throws Exception {
        char[] password = this.passwordFromConfig(config);
        IMongoReplicaSetConfiguration replicaConfig = config.getReplicaSetConfiguration();
        String replicaUri = config.getReplicaSetURI();
        if (replicaConfig != null) {
            this.connectWithReplicaSetConfig(config, password);
        } else if (replicaUri != null) {
            this.connectWithURI(config, password);
        } else {
            this.connectWithParams(config, password);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    private char[] passwordFromConfig(IMongoStoreConfiguration config) throws Exception {
        ISecretKeyConfiguration secret = config.getSecretKeyConfiguration();
        return secret == null ? null : ISecretKeyFactory.plainPasswordFromConfig((ISecretKeyConfiguration)secret).toCharArray();
    }

    private void connectWithReplicaSetConfig(IMongoStoreConfiguration config, char[] password) {
        IMongoReplicaSetConfiguration replicaConfig = config.getReplicaSetConfiguration();
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://");
        replicaConfig.getNodes().forEach(h -> sb.append(h.getHost()).append(':').append(h.getPort()).append(','));
        sb.setLength(sb.length() - 1);
        sb.append('/').append(config.getDbName()).append("?ssl=").append(replicaConfig.isSSL()).append("&authSource=admin&replicaSet=").append(replicaConfig.getName());
        String uri = sb.toString();
        this.connectWithURI(config.withReplicaSetURI(uri), password);
    }

    private void connectWithURI(final IMongoStoreConfiguration config, final char[] password) {
        String dbName = config.getDbName() == null ? AUTH_DB_NAME : config.getDbName();
        MongoClientURI mcu = new MongoClientURI(config.getReplicaSetURI()){

            public MongoCredential getCredentials() {
                if (password == null) {
                    return null;
                }
                return MongoCredential.createCredential((String)config.getUser(), (String)MongoStore.AUTH_DB_NAME, (char[])password);
            }

            public MongoClientOptions getOptions() {
                return MongoClientOptions.builder((MongoClientOptions)super.getOptions()).codecRegistry(codecRegistry).socketTimeout(360000).connectTimeout(360000).build();
            }
        };
        logger.info(() -> "Connecting " + (config.getUser() == null ? "anonymously " : "user '" + config.getUser() + "'") + " to '" + dbName + "' database @" + mcu.getOptions().getRequiredReplicaSetName());
        this.client = new MongoClient(mcu);
        this.db = this.client.getDatabase(dbName);
        if (!AUTH_DB_NAME.equals(dbName)) {
            this.loadAttributes();
        }
        logger.info(() -> "Connected to database @" + mcu.getOptions().getRequiredReplicaSetName());
    }

    public MongoStore(String host, int port, String database) {
        this.connectWithParams(host, port, database, null, null);
    }

    public MongoStore(String host, int port, String database, String user, char[] password) {
        this.connectWithParams(host, port, database, user, password);
    }

    private void connectWithParams(IMongoStoreConfiguration config, char[] password) {
        this.connectWithParams(config.getHost(), config.getPort(), config.getDbName(), config.getUser(), password);
    }

    private void connectWithParams(String host, int port, String database, String user, char[] password) {
        String dbName = database == null ? AUTH_DB_NAME : database;
        ServerAddress address = new ServerAddress(host, port);
        MongoClientOptions options = MongoClientOptions.builder().codecRegistry(codecRegistry).socketTimeout(360000).connectTimeout(360000).build();
        if (user != null && password != null) {
            logger.info(() -> "Connecting user '" + user + "' to '" + dbName + "' database");
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)AUTH_DB_NAME, (char[])password);
            this.client = new MongoClient(address, credential, options);
        } else {
            logger.info(() -> "Connecting anonymously to '" + dbName + "' database");
            this.client = new MongoClient(address, options);
        }
        this.db = this.client.getDatabase(dbName);
        if (!AUTH_DB_NAME.equals(dbName)) {
            this.loadAttributes();
        }
        logger.info(() -> "Connected to '" + dbName + "' database");
    }

    public boolean checkConnection() {
        try {
            return this.client.getDatabase(AUTH_DB_NAME) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class<?> getDbIdClass() {
        return UUID.class;
    }

    public Object newDbId() {
        return UUID.randomUUID();
    }

    public Object convertToDbId(Object dbId) {
        if (dbId instanceof UUID) {
            return dbId;
        }
        if (dbId instanceof ObjectId) {
            return ((ObjectId)dbId).toHexString();
        }
        if (dbId instanceof String) {
            return UUID.fromString((String)dbId);
        }
        return UUID.fromString(String.valueOf(dbId));
    }

    public AttributeInfo getAttributeInfo(String name) throws PromptoError {
        return this.attributes.get(name);
    }

    void loadAttributes() {
        for (Document doc : this.db.getCollection("attributes").find()) {
            this.loadAttribute(doc);
        }
    }

    void loadAttribute(Document doc) {
        String name = doc.getString((Object)"name");
        Family family = Family.valueOf((String)doc.getString((Object)"family"));
        boolean collection = doc.getBoolean((Object)"collection", false);
        boolean key = doc.getBoolean((Object)"key", false);
        boolean value = doc.getBoolean((Object)"value", false);
        boolean words = doc.getBoolean((Object)"words", false);
        this.attributes.put(name, new AttributeInfo(name, family, collection, key, value, words));
    }

    void loadAttribute(String name) {
        Document doc = (Document)this.db.getCollection("attributes").find().filter(Filters.eq((String)"name", (Object)name)).first();
        if (doc != null) {
            this.loadAttribute(doc);
        }
    }

    public void createOrUpdateAttributes(Collection<AttributeInfo> infos) throws PromptoError {
        this.storeAttributes(infos);
        this.loadAttributes();
        this.createIndicesIfRequired();
    }

    private void createIndicesIfRequired() {
        this.attributes.values().stream().filter(AttributeInfo::isIndexed).forEach(this::createIndexIfRequired);
    }

    private void createIndexIfRequired(AttributeInfo info) {
        if (info.isKey()) {
            this.createKeyIndexIfRequired(info.getName());
        }
        if (info.isValue()) {
            this.createValueIndexIfRequired(info.getName());
        }
    }

    private boolean indexExists(String indexName) {
        ListIndexesIterable indices = this.getInstancesCollection().listIndexes();
        return StreamSupport.stream(indices.spliterator(), false).map(doc -> doc.get((Object)"key")).map(o -> (Document)o).map(Document::keySet).anyMatch(s -> s.contains(indexName));
    }

    private void createValueIndexIfRequired(String name) {
        String indexName = name + "_value";
        if (!this.indexExists(indexName)) {
            Collation collation = Collation.builder().locale("en").collationStrength(CollationStrength.PRIMARY).build();
            IndexOptions options = new IndexOptions().unique(false).collation(collation).name(indexName);
            Bson keys = Indexes.ascending((String[])new String[]{name});
            this.getInstancesCollection().createIndex(keys, options);
        }
    }

    private void createKeyIndexIfRequired(String name) {
        String indexName = name + "_key";
        if (!this.indexExists(indexName)) {
            IndexOptions options = new IndexOptions().unique(false).name(indexName);
            Bson keys = Indexes.ascending((String[])new String[]{name});
            this.getInstancesCollection().createIndex(keys, options);
        }
    }

    private void storeAttributes(Collection<AttributeInfo> infos) {
        List operations = infos.stream().map(this::buildWriteModel).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            MongoCollection coll = this.db.getCollection("attributes");
            coll.bulkWrite(operations);
        }
    }

    private UpdateOneModel<Document> buildWriteModel(AttributeInfo attribute) {
        Document data = new Document();
        data.put("name", (Object)attribute.getName());
        data.put("family", (Object)attribute.getFamily().name());
        data.put("collection", (Object)attribute.isCollection());
        data.put("key", (Object)attribute.isKey());
        data.put("value", (Object)attribute.isValue());
        data.put("words", (Object)attribute.isWords());
        Bson filter = Filters.eq((String)"name", (Object)attribute.getName());
        UpdateOneModel model = new UpdateOneModel(filter, (Bson)new Document("$set", (Object)data));
        model.getOptions().upsert(true);
        return model;
    }

    public IStorable newStorable(String[] categories, IStorable.IDbIdFactory dbIdFactory) {
        return new StorableDocument(categories, dbIdFactory);
    }

    public void store(Collection<?> deletables, Collection<IStorable> storables) throws PromptoError {
        List<WriteModel<Document>> operations = this.buildWriteModels(deletables, storables);
        if (!operations.isEmpty()) {
            this.getInstancesCollection().bulkWrite(operations);
        }
    }

    private List<WriteModel<Document>> buildWriteModels(Collection<?> deletables, Collection<IStorable> storables) {
        Stream<WriteModel> deletes = null;
        Stream<WriteModel> upserts = null;
        if (deletables != null) {
            deletes = deletables.stream().map(d -> new DeleteOneModel(Filters.eq((String)"_id", (Object)d)));
        }
        if (storables != null) {
            upserts = storables.stream().map(s -> ((StorableDocument)s).toWriteModel());
        }
        if (deletes == null && upserts == null) {
            return Collections.emptyList();
        }
        Stream<Object> all = deletes == null ? upserts : (upserts == null ? deletes : Stream.of(deletes, upserts).flatMap(Function.identity()));
        return all.collect(Collectors.toList());
    }

    public void deleteAll() throws PromptoError {
        throw new UnsupportedOperationException();
    }

    public PromptoBinary fetchBinary(Object dbId, String attr) throws PromptoError {
        Bson filter = Filters.eq((String)"_id", (Object)dbId);
        MongoCursor found = this.getInstancesCollection().find(filter).limit(1).projection(Projections.include((String[])new String[]{attr})).iterator();
        if (!found.hasNext()) {
            return null;
        }
        Object data = ((Document)found.next()).get((Object)attr);
        if (data == null) {
            return null;
        }
        if ((data = this.readFieldData(attr, data)) instanceof PromptoBinary) {
            return (PromptoBinary)data;
        }
        return null;
    }

    public IStored fetchUnique(Object dbId) throws PromptoError {
        Bson filter = Filters.eq((String)"_id", (Object)dbId);
        return this.fetchOne(filter);
    }

    public IQueryBuilder newQueryBuilder() {
        return new MongoQueryBuilder();
    }

    public IStored fetchOne(IQuery query) throws PromptoError {
        return this.fetchOne(((MongoQuery)query).predicate);
    }

    private IStored fetchOne(Bson filter) throws PromptoError {
        MongoCursor found = this.getInstancesCollection().find(filter).limit(1).iterator();
        if (found.hasNext()) {
            return new StoredDocument(this, (Document)found.next());
        }
        return null;
    }

    public IStoredIterable fetchMany(IQuery query) throws PromptoError {
        MongoCollection<Document> coll = this.getInstancesCollection();
        return new StoredIterable(coll, (MongoQuery)query);
    }

    private MongoCollection<Document> getInstancesCollection() {
        return this.db.getCollection("instances");
    }

    public long nextSequenceValue(String name) {
        MongoCollection sequences = this.db.getCollection("sequences");
        Bson filter = Filters.eq((String)"_id", (Object)name);
        Bson update = Updates.inc((String)"sequence", (Number)1);
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        Document result = (Document)sequences.findOneAndUpdate(filter, update, options);
        return ((Number)result.get((Object)"sequence")).longValue();
    }

    public void flush() throws PromptoError {
    }

    static Object binaryToPromptoBinary(Object o) {
        try {
            BinaryData bin = new BinaryData(((Binary)o).getData());
            return new PromptoBinary(bin.getMimeType(), bin.getData());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object readFieldData(String fieldName, Object data) {
        AttributeInfo info = this.attributes.get(fieldName);
        if (info == null) {
            this.loadAttribute(fieldName);
            info = this.attributes.get(fieldName);
        }
        if (info == null) {
            logger.error(() -> "Missing AttributeInfo for " + fieldName);
            return null;
        }
        if (info.isCollection() && data instanceof Collection) {
            return this.readCollectionData(info, (Collection)data);
        }
        return readers.getOrDefault(info.getFamily(), o -> o).apply(data);
    }

    private Object readCollectionData(AttributeInfo info, Collection<Object> data) {
        Function<Object, Object> reader = readers.getOrDefault(info.getFamily(), o -> o);
        List list = data.stream().map(reader::apply).collect(Collectors.toList());
        return new PromptoList(list, false);
    }

    public void insertDocuments(Document ... docs) {
        this.getInstancesCollection().insertMany(Arrays.asList(docs));
    }

    public Map<String, Object> fetchConfiguration(String name) {
        MongoCollection configs = this.db.getCollection("configurations");
        FindIterable find = configs.find().filter(Filters.eq((String)"_id", (Object)name)).limit(1);
        MongoCursor iter = find.iterator();
        if (iter.hasNext()) {
            return (Map)iter.next();
        }
        return null;
    }

    public void storeConfiguration(String name, Map<String, Object> data) {
        Document config = new Document();
        config.putAll(data);
        Bson filter = Filters.eq((String)"_id", (Object)name);
        MongoCollection configs = this.db.getCollection("configurations");
        ReplaceOptions options = new ReplaceOptions().upsert(true);
        configs.replaceOne(filter, (Object)config, options);
    }

    static {
        readers.put(Family.DATE, o -> o instanceof Long ? PromptoDate.fromJavaTime((long)((Long)o)) : null);
        readers.put(Family.TIME, o -> o instanceof Long ? PromptoTime.fromMillisOfDay((long)((Long)o)) : null);
        readers.put(Family.DATETIME, o -> o instanceof Document ? PromptoDateTime.parse((String)((Document)o).getString((Object)"text")) : null);
        readers.put(Family.BLOB, MongoStore::binaryToPromptoBinary);
        readers.put(Family.IMAGE, MongoStore::binaryToPromptoBinary);
        readers.put(Family.VERSION, o -> PromptoVersion.parse((int)((Integer)o)));
    }

    class StoredIterable
    implements IStoredIterable {
        MongoCollection<Document> collection;
        MongoQuery query;
        Long totalCount = null;
        Long count = null;

        StoredIterable(MongoCollection<Document> collection, MongoQuery query) {
            this.collection = collection;
            this.query = query;
        }

        public Iterator<IStored> iterator() {
            FindIterable find = this.collection.find();
            if (this.query != null) {
                if (this.query.predicate != null) {
                    find = find.filter(this.query.predicate);
                }
                if (this.query.first != null && this.query.last != null) {
                    if (this.query.first > 1L) {
                        find = find.skip(this.query.first.intValue() - 1);
                    }
                    find = find.limit((int)(1L + this.query.last - this.query.first));
                }
                if (this.query.orderBys != null) {
                    find = find.sort(Sorts.orderBy(this.query.orderBys));
                }
            }
            MongoCursor iter = find.iterator();
            return new Iterator<IStored>((Iterator)iter){
                final /* synthetic */ Iterator val$iter;
                {
                    this.val$iter = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$iter.hasNext();
                }

                @Override
                public IStored next() {
                    return new StoredDocument(MongoStore.this, (Document)this.val$iter.next());
                }
            };
        }

        public long totalCount() {
            if (this.totalCount == null) {
                this.totalCount = this.query == null || this.query.predicate == null ? Long.valueOf(this.collection.estimatedDocumentCount()) : Long.valueOf(this.collection.countDocuments(this.query.predicate));
            }
            return this.totalCount;
        }

        public long count() {
            if (this.count == null) {
                if (this.query != null && this.query.first != null && this.query.last != null) {
                    this.count = 1L + this.query.last - this.query.first;
                    if (this.query.first + this.count - 1L > this.totalCount()) {
                        this.count = this.totalCount() + 1L - this.query.first;
                    }
                } else {
                    this.count = this.totalCount();
                }
            }
            return this.count;
        }
    }
}

