/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.MongoClient;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import prompto.intrinsic.PromptoDateTime;

public class PromptoDateTimeCodec
implements CollectibleCodec<PromptoDateTime> {
    static Codec<Document> documentCodec = MongoClient.getDefaultCodecRegistry().get(Document.class);

    public void encode(BsonWriter writer, PromptoDateTime value, EncoderContext encoderContext) {
        long utc = value.toJavaTime();
        String text = value.toString();
        Document document = new Document();
        document.put("utc", (Object)utc);
        document.put("text", (Object)text);
        documentCodec.encode(writer, (Object)document, encoderContext);
    }

    public Class<PromptoDateTime> getEncoderClass() {
        return PromptoDateTime.class;
    }

    public PromptoDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        Document document = (Document)documentCodec.decode(reader, decoderContext);
        String text = document.getString((Object)"text");
        return PromptoDateTime.parse((String)text);
    }

    public PromptoDateTime generateIdIfAbsentFromDocument(PromptoDateTime document) {
        return null;
    }

    public boolean documentHasId(PromptoDateTime document) {
        return false;
    }

    public BsonValue getDocumentId(PromptoDateTime document) {
        return null;
    }
}

