/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.ArrayList;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class StringArrayCodec
implements CollectibleCodec<String[]> {
    public void encode(BsonWriter writer, String[] value, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (String s : value) {
            writer.writeString(s);
        }
        writer.writeEndArray();
    }

    public Class<String[]> getEncoderClass() {
        return String[].class;
    }

    public String[] decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<String> value = new ArrayList<String>();
        reader.readStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            value.add(reader.readString());
        }
        reader.readEndArray();
        return value.toArray(new String[0]);
    }

    public String[] generateIdIfAbsentFromDocument(String[] document) {
        return null;
    }

    public boolean documentHasId(String[] document) {
        return false;
    }

    public BsonValue getDocumentId(String[] document) {
        return null;
    }
}

