/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.slf4j.LoggerFactory;
import prompto.config.TempDirectories;
import prompto.runtime.Mode;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.mongo.MongoStore;

public abstract class BaseMongoTest {
    protected int mongoPort;
    MongodExecutable mongo;
    protected MongoStore store;
    protected MongoDatabase db;

    @Before
    public void __before__() throws IOException {
        if (this.mongoPort == 0) {
            this.mongoPort = Network.getFreeServerPort();
        }
        this.mongo = BaseMongoTest.startMongo(this.mongoPort);
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
    }

    public static MongodExecutable startMongo(int mongoPort) throws IOException {
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, LoggerFactory.getLogger((String)BaseMongoTest.class.getName())).processOutput(ProcessOutput.getDefaultInstanceSilent()).build();
        MongodStarter starter = MongodStarter.getInstance((IRuntimeConfig)runtimeConfig);
        IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.PRODUCTION).net(new Net(mongoPort, Network.localhostIsIPv6())).build();
        MongodExecutable mongo = (MongodExecutable)starter.prepare((IExecutableProcessConfig)mongodConfig);
        mongo.start();
        return mongo;
    }

    @After
    public void __after__() throws IOException {
        if (this.mongo != null) {
            BaseMongoTest.stopMongo(this.mongo);
        }
    }

    public static void stopMongo(MongodExecutable mongo) {
        mongo.stop();
    }

    protected MongoStore createStore(String name) {
        this.store = new MongoStore("localhost", this.mongoPort, name);
        this.db = this.store.db;
        return this.store;
    }

    protected void createField(String name, Family family, boolean collection) {
        AttributeInfo info = new AttributeInfo(name, family, collection, false, false, false, false);
        this.store.createOrUpdateAttributes(Collections.singletonList(info));
    }
}

