/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.MongoCollection;
import java.util.HashMap;
import java.util.UUID;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.expression.EqualsExpression;
import prompto.expression.FetchOneExpression;
import prompto.expression.IExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.expression.ValueExpression;
import prompto.grammar.EqOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.literal.BooleanLiteral;
import prompto.literal.DateLiteral;
import prompto.literal.DateTimeLiteral;
import prompto.literal.DecimalLiteral;
import prompto.literal.IntegerLiteral;
import prompto.literal.TextLiteral;
import prompto.literal.TimeLiteral;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IQuery;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.mongo.BaseMongoTest;
import prompto.store.mongo.StorableDocument;
import prompto.type.AnyType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.utils.IdentifierList;
import prompto.value.BooleanValue;
import prompto.value.ConcreteInstance;
import prompto.value.DateTimeValue;
import prompto.value.DateValue;
import prompto.value.DecimalValue;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.TextValue;
import prompto.value.TimeValue;
import prompto.value.UuidValue;

public class TestInstance
extends BaseMongoTest {
    Context context;

    @Before
    public void before() throws Exception {
        this.createStore("TestInstance");
        this.createField("category", Family.TEXT, true);
        DataStore.setInstance((IStore)this.store);
        this.context = Context.newGlobalsContext();
        AttributeDeclaration a = new AttributeDeclaration(new Identifier("dbId"), (IType)AnyType.instance());
        this.context.registerDeclaration((IDeclaration)a);
    }

    @Test
    public void readsNativeObjectId() throws Exception {
        Document storable = new Document();
        storable.put("field", (Object)"value");
        MongoCollection coll = this.db.getCollection("instances");
        coll.insertOne((Object)storable);
        ObjectId dbId = storable.getObjectId((Object)"_id");
        this.store.convertToDbId((Object)dbId);
    }

    @Test
    public void testStoreTextField() throws Exception {
        String fieldName = "msg";
        String fieldValue = "hello";
        this.createField(fieldName, Family.TEXT, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)TextType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new TextValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new TextLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testUpdateTextField() throws Exception {
        String fieldName = "msg";
        String fieldValue = "hello";
        this.createField(fieldName, Family.TEXT, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)TextType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new TextValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new TextLiteral(fieldValue));
        CategoryType type = new CategoryType(new Identifier("Test"));
        type.setMutable(true);
        instance = type.newInstance(this.context, stored);
        fieldValue = "after";
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new TextValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        stored = this.fetchOne(fieldName, (IExpression)new TextLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreIntegerField() throws Exception {
        String fieldName = "int";
        long fieldValue = 123L;
        this.createField(fieldName, Family.INTEGER, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)IntegerType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new IntegerValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new IntegerLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreDecimalField() throws Exception {
        String fieldName = "decimal";
        double fieldValue = 123.0;
        this.createField(fieldName, Family.DECIMAL, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)IntegerType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new DecimalValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new DecimalLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreBooleanField() throws Exception {
        String fieldName = "bool";
        boolean fieldValue = true;
        this.createField(fieldName, Family.BOOLEAN, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)BooleanType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)BooleanValue.valueOf((boolean)fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new BooleanLiteral("true"));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreDateField() throws Exception {
        String fieldName = "date";
        PromptoDate fieldValue = PromptoDate.parse((String)"2015-03-12");
        this.createField(fieldName, Family.DATE, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)DateType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new DateValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new DateLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreTimeField() throws Exception {
        String fieldName = "time";
        PromptoTime fieldValue = PromptoTime.parse((String)"13:15:16.012");
        this.createField(fieldName, Family.TIME, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)TimeType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new TimeValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new TimeLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreDateTimeField() throws Exception {
        String fieldName = "datetime";
        PromptoDateTime fieldValue = PromptoDateTime.parse((String)"2015-03-12T13:15:16.012Z");
        this.createField(fieldName, Family.DATETIME, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)DateTimeType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new DateTimeValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new DateTimeLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    @Test
    public void testStoreUUIDField() throws Exception {
        String fieldName = "uuid";
        UUID fieldValue = UUID.randomUUID();
        this.createField(fieldName, Family.UUID, false);
        IInstance instance = this.createInstanceWith1Attribute(fieldName, (IType)UuidType.instance());
        instance.setMember(this.context, new Identifier(fieldName), (IValue)new UuidValue(fieldValue));
        this.store.store(instance.getStorable());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new ValueExpression((IType)UuidType.instance(), (IValue)new UuidValue(fieldValue)));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
    }

    private static boolean isDump() {
        return false;
    }

    private static void dumpDbIds(String which, IInstance instance) {
        if (TestInstance.isDump()) {
            IValue value = instance.getMember(null, new Identifier("dbId"), false);
            Object dbId = value == null ? null : value.getStorableData();
            System.err.print(which + ": ivalue: " + String.valueOf(dbId));
            IStorable storable = instance.getStorable();
            Document document = storable == null ? null : ((StorableDocument)storable).getDocument();
            dbId = document == null ? null : document.get((Object)"dbId");
            System.err.println(", dbvalue: " + String.valueOf(dbId));
        }
    }

    @Test
    public void testStoreChildField() throws Exception {
        CategoryType type = new CategoryType(new Identifier("Test"));
        String fieldName = "textField";
        String fieldValue = "textValue";
        String childValue = "childValue";
        String childName = "childField";
        this.createField(fieldName, Family.TEXT, false);
        this.createField(childName, Family.CATEGORY, false);
        IInstance parent = this.createInstanceWith2Attributes(fieldName, (IType)TextType.instance(), childName, (IType)type);
        TestInstance.dumpDbIds("parent", parent);
        ConcreteCategoryDeclaration cd = (ConcreteCategoryDeclaration)this.context.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, new Identifier("Test"), false);
        ConcreteInstance child = new ConcreteInstance(this.context, (CategoryDeclaration)cd);
        TestInstance.dumpDbIds("child", (IInstance)child);
        child.setMutable(true);
        child.setMember(this.context, new Identifier(fieldName), (IValue)new TextValue(childValue));
        TestInstance.dumpDbIds("child", (IInstance)child);
        parent.setMember(this.context, new Identifier(fieldName), (IValue)new TextValue(fieldValue));
        TestInstance.dumpDbIds("parent", parent);
        parent.setMember(this.context, new Identifier(childName), (IValue)child);
        TestInstance.dumpDbIds("parent", parent);
        TestInstance.dumpDbIds("child", (IInstance)child);
        HashMap storables = new HashMap();
        parent.collectStorables(s -> storables.put(s.getOrCreateDbId(), s));
        TestInstance.dumpDbIds("parent", parent);
        TestInstance.dumpDbIds("child", (IInstance)child);
        this.store.store(null, storables.values());
        this.store.flush();
        IStored stored = this.fetchOne(fieldName, (IExpression)new TextLiteral(fieldValue));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)fieldValue, (Object)stored.getData(fieldName));
        parent = (ConcreteInstance)type.newInstance(this.context, stored);
        IValue v = parent.getMember(this.context, new Identifier(childName), false);
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((boolean)(v instanceof IInstance));
        Assert.assertEquals((Object)new TextValue(childValue), (Object)v.getMember(this.context, new Identifier(fieldName), false));
    }

    private IStored fetchOne(String field, IExpression value) throws Exception {
        FetchOneExpression expression = new FetchOneExpression(new CategoryType(new Identifier("Test")), (IExpression)new EqualsExpression((IExpression)new UnresolvedIdentifier(new Identifier(field)), EqOp.EQUALS, value));
        IQuery query = expression.buildFetchOneQuery(this.context, (IStore)this.store);
        return this.store.fetchOne(query);
    }

    private IStoredIterable fetchAll() throws Exception {
        IQuery query = this.store.newQueryBuilder().build();
        return this.store.fetchMany(query);
    }

    private IInstance createInstanceWith1Attribute(String name, IType type) throws Exception {
        AttributeDeclaration a = new AttributeDeclaration(new Identifier(name), type);
        a.setStorable(true);
        this.context.registerDeclaration((IDeclaration)a);
        IdentifierList as = new IdentifierList(new Identifier(name));
        ConcreteCategoryDeclaration d = new ConcreteCategoryDeclaration(new Identifier("Test"), as, null, null);
        d.setStorable(true);
        this.context.registerDeclaration((IDeclaration)d);
        ConcreteInstance i = new ConcreteInstance(this.context, (CategoryDeclaration)d);
        i.setMutable(true);
        return i;
    }

    private IInstance createInstanceWith2Attributes(String name1, IType type1, String name2, IType type2) throws Exception {
        AttributeDeclaration a = new AttributeDeclaration(new Identifier(name1), type1);
        a.setStorable(true);
        this.context.registerDeclaration((IDeclaration)a);
        a = new AttributeDeclaration(new Identifier(name2), type2);
        a.setStorable(true);
        this.context.registerDeclaration((IDeclaration)a);
        IdentifierList as = new IdentifierList(new Identifier(name1));
        as.add((Object)new Identifier(name2));
        ConcreteCategoryDeclaration d = new ConcreteCategoryDeclaration(new Identifier("Test"), as, null, null);
        d.setStorable(true);
        this.context.registerDeclaration((IDeclaration)d);
        ConcreteInstance i = new ConcreteInstance(this.context, (CategoryDeclaration)d);
        i.setMutable(true);
        return i;
    }
}

