/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.store.mongo.BaseMongoTest;

public class TestStore
extends BaseMongoTest {
    @Before
    public void before() throws Exception {
        this.createStore("TestStore");
    }

    @Test
    public void nextSequenceIncrements() {
        long counter = this.store.nextSequenceValue("test");
        Assert.assertEquals((long)1L, (long)counter);
        counter = this.store.nextSequenceValue("test");
        Assert.assertEquals((long)2L, (long)counter);
        counter = this.store.nextSequenceValue("test2");
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    public void initialConfigIsNull() {
        Map config = this.store.fetchConfiguration("config");
        Assert.assertNull((Object)config);
    }

    @Test
    public void configIsStored() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("derivedFrom", true);
        this.store.storeConfiguration("config", config);
        config.put("_id", "config");
        Map stored = this.store.fetchConfiguration("config");
        Assert.assertEquals(config, (Object)stored);
    }
}

