/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.LoggerFactory;
import prompto.config.TempDirectories;
import prompto.runtime.Mode;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IStore;
import prompto.store.mongo.MongoStore;

public abstract class BaseMongoTest {
    protected static MongodExecutable mongo = null;
    protected static int mongoPort = 0;
    protected static Timer mongoStopper = null;
    protected static Object lock = new Object();
    protected MongoStore store;
    protected MongoDatabase db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void __before_class__() throws IOException {
        Object object = lock;
        synchronized (object) {
            if (mongoPort == 0) {
                mongoPort = Network.getFreeServerPort();
            }
            if (mongo == null) {
                mongo = BaseMongoTest.startMongo(mongoPort);
            }
        }
    }

    @AfterClass
    public static void __after_class__() throws IOException {
    }

    public static MongodExecutable startMongo(int mongoPort) throws IOException {
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, LoggerFactory.getLogger((String)BaseMongoTest.class.getName())).processOutput(ProcessOutput.getDefaultInstanceSilent()).build();
        MongodStarter starter = MongodStarter.getInstance((IRuntimeConfig)runtimeConfig);
        IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.PRODUCTION).net(new Net(mongoPort, Network.localhostIsIPv6())).build();
        MongodExecutable mongo = (MongodExecutable)starter.prepare((IExecutableProcessConfig)mongodConfig);
        mongo.start();
        return mongo;
    }

    public static void stopMongo(MongodExecutable mongo) {
        if (mongo != null) {
            System.out.println("Stopping shared Mongo instance");
            mongo.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void __before__() throws IOException {
        Object object = lock;
        synchronized (object) {
            if (mongoStopper != null) {
                mongoStopper.cancel();
                mongoStopper = null;
            }
            TempDirectories.create();
            Mode.set((Mode)Mode.UNITTEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void __after__() throws IOException {
        Object object = lock;
        synchronized (object) {
            if (mongoStopper == null) {
                mongoStopper = new Timer("Stop Mongo");
                mongoStopper.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BaseMongoTest.stopMongo(mongo);
                        mongo = null;
                        mongoPort = 0;
                        mongoStopper.cancel();
                        mongoStopper = null;
                    }
                }, 5000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MongoStore createStore(String name) {
        Object object = lock;
        synchronized (object) {
            System.out.println("Creating new store from shared Mongo instance");
            this.store = new MongoStore("localhost", mongoPort, name, false);
            DataStore.setGlobal((IStore)this.store);
            DataStore.useGlobal();
            this.db = this.store.db;
            return this.store;
        }
    }

    protected void createField(String name, Family family, boolean collection) {
        AttributeInfo info = new AttributeInfo(name, family, collection, false, false, false, false);
        this.store.createOrUpdateAttributes(Collections.singletonList(info));
    }
}

