/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.MongoCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoList;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IAuditMetadata;
import prompto.store.IAuditRecord;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.mongo.MongoAuditor;
import prompto.store.mongo.MongoStore;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.TextType;
import prompto.utils.IdentifierList;
import prompto.utils.ManualTests;
import prompto.value.ConcreteInstance;
import prompto.value.IValue;
import prompto.value.TextValue;

@Category(value={ManualTests.class})
public class TestAudit {
    static final String DOCKER_MONGO_RS_URI = "mongodb://localhost:27001,localhost:27002,localhost:27003/{TEST}?replicaSet=mongo-rs";
    MongoStore store;
    Context context;

    @Before
    public void before() {
        String rs_uri = DOCKER_MONGO_RS_URI.replace("{TEST}", "TEST_" + System.currentTimeMillis());
        this.store = new MongoStore(rs_uri, true, null, null);
        this.createField("category", Family.TEXT, true);
        this.createField("name", Family.TEXT, false);
        DataStore.setInstance((IStore)this.store);
        this.store.db.getCollection("instances").drop();
        this.store.db.getCollection("auditMetadatas").drop();
        this.store.db.getCollection("auditRecords").drop();
        this.context = Context.newGlobalsContext();
        AttributeDeclaration a = new AttributeDeclaration(new Identifier("dbId"), (IType)AnyType.instance());
        this.context.registerDeclaration((IDeclaration)a);
    }

    @After
    public void after() {
        this.store.close();
    }

    @Test
    public void audits3Inserts() throws InterruptedException {
        this.createAttribute("name", (IType)TextType.instance());
        ConcreteCategoryDeclaration cat = this.createCategory("Test", "name");
        List instances = IntStream.of(1, 2, 3).mapToObj(i -> {
            ConcreteInstance instance = new ConcreteInstance(this.context, (CategoryDeclaration)cat);
            instance.setMutable(true);
            instance.setMember(this.context, new Identifier("name"), (IValue)new TextValue("hello " + i));
            return instance.getStorable();
        }).collect(Collectors.toList());
        this.store.store(instances);
        Thread.sleep(3000L);
        MongoCollection coll = this.store.db.getCollection("auditMetadatas");
        Assert.assertEquals((long)1L, (long)coll.estimatedDocumentCount());
        coll = this.store.db.getCollection("auditRecords");
        Assert.assertEquals((long)3L, (long)coll.estimatedDocumentCount());
        PromptoDbId metaId = this.store.fetchLatestAuditMetadataId(((IStorable)instances.get(0)).getOrCreateDbId());
        Assert.assertNotNull((Object)metaId);
        IAuditMetadata meta = this.store.fetchAuditMetadata(metaId);
        Assert.assertNotNull((Object)meta);
        MongoAuditor.AuditRecord audit = this.store.fetchLatestAuditRecord(((IStorable)instances.get(0)).getOrCreateDbId());
        Assert.assertNotNull((Object)audit);
        Assert.assertEquals((Object)"hello 1", (Object)audit.getInstance().getData("name"));
    }

    @Test
    public void audits1Update() throws InterruptedException {
        this.createAttribute("name", (IType)TextType.instance());
        ConcreteCategoryDeclaration cat = this.createCategory("Test", "name");
        ConcreteInstance instance = new ConcreteInstance(this.context, (CategoryDeclaration)cat);
        instance.setMutable(true);
        instance.setMember(this.context, new Identifier("name"), (IValue)new TextValue("hello"));
        this.store.store(instance.getStorable());
        Thread.sleep(3000L);
        IStored stored = this.store.fetchUnique(instance.getStorable().getOrCreateDbId());
        instance = cat.newInstance(this.context, stored);
        instance.setMutable(true);
        instance.setMember(this.context, new Identifier("name"), (IValue)new TextValue("bye"));
        this.store.store(instance.getStorable());
        Thread.sleep(3000L);
        MongoCollection coll = this.store.db.getCollection("auditMetadatas");
        Assert.assertEquals((long)2L, (long)coll.estimatedDocumentCount());
        coll = this.store.db.getCollection("auditRecords");
        Assert.assertEquals((long)2L, (long)coll.estimatedDocumentCount());
        PromptoList audits = this.store.fetchAllAuditRecords(stored.getDbId());
        Assert.assertEquals((long)2L, (long)audits.size());
        Iterator iter = audits.iterator();
        IAuditRecord audit = (IAuditRecord)iter.next();
        Assert.assertEquals((Object)"bye", (Object)audit.getInstance().getData("name"));
        audit = (IAuditRecord)iter.next();
        Assert.assertEquals((Object)"hello", (Object)audit.getInstance().getData("name"));
        PromptoList metaIds = this.store.fetchAllAuditMetadataIds(stored.getDbId());
        Assert.assertEquals((long)2L, (long)metaIds.size());
        metaIds.forEach(metaId -> Assert.assertNotNull((Object)this.store.fetchAuditMetadata(metaId)));
    }

    @Test
    public void audits1Delete() throws InterruptedException {
        this.createAttribute("name", (IType)TextType.instance());
        ConcreteCategoryDeclaration cat = this.createCategory("Test", "name");
        ConcreteInstance instance = new ConcreteInstance(this.context, (CategoryDeclaration)cat);
        instance.setMutable(true);
        instance.setMember(this.context, new Identifier("name"), (IValue)new TextValue("hello"));
        this.store.store(instance.getStorable());
        Thread.sleep(3000L);
        this.store.delete(instance.getStorable().getOrCreateDbId());
        Thread.sleep(3000L);
        MongoCollection coll = this.store.db.getCollection("auditMetadatas");
        Assert.assertEquals((long)2L, (long)coll.estimatedDocumentCount());
        coll = this.store.db.getCollection("auditRecords");
        Assert.assertEquals((long)2L, (long)coll.estimatedDocumentCount());
        PromptoList audits = this.store.fetchAllAuditRecords(instance.getStorable().getOrCreateDbId());
        Assert.assertEquals((long)2L, (long)audits.size());
        Iterator iter = audits.iterator();
        IAuditRecord audit = (IAuditRecord)iter.next();
        Assert.assertNull((Object)audit.getInstance());
        audit = (IAuditRecord)iter.next();
        Assert.assertEquals((Object)"hello", (Object)audit.getInstance().getData("name"));
        audits = this.store.fetchAuditRecordsMatching(null, Collections.singletonMap("name", "hello"));
        Assert.assertEquals((long)1L, (long)audits.size());
        audit = (IAuditRecord)audits.iterator().next();
        Assert.assertEquals((Object)"hello", (Object)audit.getInstance().getData("name"));
        audits = this.store.fetchAuditRecordsMatching(Collections.singletonMap("operation", IAuditRecord.Operation.DELETE), null);
        Assert.assertEquals((long)1L, (long)audits.size());
        audit = (IAuditRecord)audits.iterator().next();
        Assert.assertNull((Object)audit.getInstance());
    }

    private ConcreteCategoryDeclaration createCategory(String name, String ... attrs) {
        IdentifierList list = IdentifierList.parse((String)String.join((CharSequence)",", attrs));
        ConcreteCategoryDeclaration decl = new ConcreteCategoryDeclaration(new Identifier(name), list, null, null);
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
        return decl;
    }

    private AttributeDeclaration createAttribute(String name, IType type) {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier(name), type);
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
        return decl;
    }

    protected void createField(String name, Family family, boolean collection) {
        AttributeInfo info = new AttributeInfo(name, family, collection, false, false, false, false);
        this.store.createOrUpdateAttributes(Collections.singletonList(info));
    }

    @Test
    public void recoversIfInterrupted() throws Exception {
        this.store.stopAuditor();
        this.createAttribute("name", (IType)TextType.instance());
        ConcreteCategoryDeclaration cat = this.createCategory("Test", "name");
        ConcreteInstance instance = new ConcreteInstance(this.context, (CategoryDeclaration)cat);
        instance.setMutable(true);
        instance.setMember(this.context, new Identifier("name"), (IValue)new TextValue("hello"));
        this.store.store(instance.getStorable());
        Thread.sleep(3000L);
        MongoAuditor auditor = new MongoAuditor(this.store);
        PromptoList audits = auditor.fetchAllAuditRecords(instance.getStorable().getOrCreateDbId());
        Assert.assertEquals((long)0L, (long)audits.size());
        this.store.startAuditor(() -> true);
        Thread.sleep(3000L);
        audits = this.store.fetchAllAuditRecords(instance.getStorable().getOrCreateDbId());
        Assert.assertEquals((long)1L, (long)audits.size());
    }
}

