/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.FetchOneExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.parser.ECleverParser;
import prompto.parser.EParser;
import prompto.parser.EPromptoBuilder;
import prompto.runtime.Context;
import prompto.store.Family;
import prompto.store.IQuery;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.mongo.BaseMongoTest;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.TextType;

public class TestQuery
extends BaseMongoTest {
    Context context;

    @Before
    public void before() throws Exception {
        this.createStore("TestQuery_" + System.currentTimeMillis());
        this.context = Context.newGlobalsContext();
        this.registerDbIdAttribute();
        this.registerNameAttribute();
        this.registerAliasesAttribute();
        this.registerQuantityAttribute();
        this.registerQuantitiesAttribute();
        this.createField("name", Family.TEXT, false);
        this.createField("aliases", Family.TEXT, true);
        this.createField("quantity", Family.INTEGER, false);
        this.createField("quantities", Family.INTEGER, true);
        this.createField("startFrom", Family.DATE, false);
        this.createField("timeStamp", Family.DATETIME, false);
    }

    private void registerDbIdAttribute() throws SyntaxError {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier("dbId"), (IType)AnyType.instance());
        this.context.registerDeclaration((IDeclaration)decl);
    }

    private void registerNameAttribute() throws SyntaxError {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier("name"), (IType)TextType.instance());
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
    }

    private void registerAliasesAttribute() throws SyntaxError {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier("aliases"), (IType)new ListType((IType)TextType.instance()));
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
    }

    private void registerQuantityAttribute() throws SyntaxError {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier("quantity"), (IType)IntegerType.instance());
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
    }

    private void registerQuantitiesAttribute() throws SyntaxError {
        AttributeDeclaration decl = new AttributeDeclaration(new Identifier("quantities"), (IType)new ListType((IType)IntegerType.instance()));
        decl.setStorable(true);
        this.context.registerDeclaration((IDeclaration)decl);
    }

    private IStored fetchOne(String query) throws Exception {
        ECleverParser parser = new ECleverParser(query);
        parser.getLexer().setAddLF(false);
        EParser.Fetch_expressionContext tree = parser.fetch_expression();
        EPromptoBuilder builder = new EPromptoBuilder(parser);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)builder, (ParseTree)tree);
        FetchOneExpression fetch = (FetchOneExpression)builder.getNodeValue((ParseTree)tree);
        IQuery q = fetch.buildFetchOneQuery(this.context, (IStore)this.store);
        return this.store.fetchOne(q);
    }

    @Test
    public void testStore() throws Exception {
        IStorable storable = this.store.newStorable(new String[0], null);
        storable.setData("name", (Object)"John");
        this.store.store(storable);
        this.store.flush();
        IStoredIterable many = this.store.fetchMany(null);
        Assert.assertNotNull((Object)many);
        Assert.assertEquals((long)1L, (long)many.count());
    }

    @Test
    public void testDeleteOne() throws Exception {
        Document doc = new Document();
        UUID uuid = UUID.randomUUID();
        doc.put("_id", (Object)uuid);
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        this.store.delete(this.store.convertToDbId((Object)uuid));
        this.store.flush();
        String query = "fetch one where name = \"John\"";
        IStored result = this.fetchOne(query);
        Assert.assertNull((Object)result);
    }

    @Test
    public void fetchesTextEquals() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name = \"John\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextNotEquals() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name <> \"Johnny\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextEqualsWithSpace() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John Smith");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name = \"John Smith\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John Smith", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextRoughly() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name ~ \"joHn\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextRoughlyWithParenthesis() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John (Doe)");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name ~ \"joHn (doe)\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John (Doe)", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextContains() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name contains \"oh\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextNotContains() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lucy");
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where name not contains \"oh\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lucy", (Object)result.getData("name"));
    }

    @Test
    public void fetchesListHas() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("aliases", Arrays.asList("John", "Janet"));
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lucy");
        doc2.put("aliases", Arrays.asList("Sky", "Diamond"));
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where aliases has \"John\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesListNotHas() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("aliases", Arrays.asList("John", "Janet"));
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lucy");
        doc2.put("aliases", Arrays.asList("Sky", "Diamond"));
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where aliases not has \"John\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lucy", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextLesser() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where name < \"King\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextLesserEqual() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where name <= \"King\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextGreater() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where name > \"King\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lionel", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextGreaterEqual() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where name >= \"King\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lionel", (Object)result.getData("name"));
    }

    @Test
    public void fetchesContains() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name contains \"oh\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesNotContains() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name not contains \"ah\"";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextInCollection() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name in [\"John\", \"Jim\"]";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesTextNotInCollection() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where name not in [\"Lucy\", \"Jim\"]";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerEquals() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("quantity", (Object)3L);
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where quantity = 3";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerLesser() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("quantity", (Object)3L);
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        doc2.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where quantity < 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerLesserEqual() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("quantity", (Object)3L);
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        doc2.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where quantity <= 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerGreater() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("quantity", (Object)3L);
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        doc2.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where quantity > 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lionel", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerGreaterEqual() throws Exception {
        Document doc1 = new Document();
        doc1.put("dbId", (Object)UUID.randomUUID());
        doc1.put("name", (Object)"John");
        doc1.put("quantity", (Object)3L);
        Document doc2 = new Document();
        doc2.put("dbId", (Object)UUID.randomUUID());
        doc2.put("name", (Object)"Lionel");
        doc2.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc1, doc2});
        this.store.flush();
        String query = "fetch one where quantity >= 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Lionel", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerInCollection() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where quantity in [10, 13]";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerNotInCollection() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("quantity", (Object)13L);
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where quantity not in [10, 14]";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerListHas() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("quantities", Arrays.asList(10L, 13L));
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where quantities has 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesIntegerListNotHas() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("quantities", Arrays.asList(20L, 13L));
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where quantities not has 10";
        IStored result = this.fetchOne(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void filtersDateLesserGreater() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("startFrom", (Object)PromptoDate.parse((String)"2020-10-10"));
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where startFrom > '2020-10-09'";
        IStored result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where startFrom > '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where startFrom >= '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where startFrom < '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where startFrom <= '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where startFrom < '2020-10-11'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void filtersDateTimeLesserGreater() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("timeStamp", (Object)PromptoDateTime.parse((String)"2020-10-10T12:00:00"));
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where timeStamp > '2020-10-09T00:00:00'";
        IStored result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp > '2020-10-10T12:00:00'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where timeStamp >= '2020-10-10T12:00:00'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp < '2020-10-10T12:00:00'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where timeStamp <= '2020-10-10T12:00:00'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp < '2020-10-11T12:00:00'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void filtersDateTimeLesserGreaterThanDate() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("name", (Object)"John");
        doc.put("timeStamp", (Object)PromptoDateTime.parse((String)"2020-10-10T00:00:00"));
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one where timeStamp > '2020-10-09'";
        IStored result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp > '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where timeStamp >= '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp < '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertNull((Object)result);
        query = "fetch one where timeStamp <= '2020-10-10'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        query = "fetch one where timeStamp < '2020-10-11'";
        result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
    }

    @Test
    public void fetchesOnlyIncludedFields() throws Exception {
        Document doc = new Document();
        doc.put("dbId", (Object)UUID.randomUUID());
        doc.put("category", Collections.singletonList("Person"));
        doc.put("name", (Object)"John");
        doc.put("value", (Object)"Other");
        this.store.insertDocuments(new Document[]{doc});
        this.store.flush();
        String query = "fetch one Person where name = \"John\" include name";
        IStored result = this.fetchOne(query);
        Assert.assertEquals((Object)"John", (Object)result.getData("name"));
        Assert.assertNull((Object)result.getData("value"));
    }
}

