/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BinaryData {
    private String mimeType;
    private byte[] data;

    public BinaryData(String mimeType, byte[] data) {
        this.mimeType = mimeType;
        this.data = data;
    }

    public BinaryData(byte[] bytes) throws IOException {
        this(bytes, 0, true);
    }

    public BinaryData(byte[] bytes, int offset) throws IOException {
        this(bytes, offset, true);
    }

    BinaryData(byte[] bytes, int offset, boolean readData) throws IOException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, offset, bytes.length - offset));
        int len = input.readInt();
        byte[] mimeTypeBytes = new byte[len];
        input.read(mimeTypeBytes);
        this.mimeType = new String(mimeTypeBytes);
        if (readData) {
            len = input.readInt();
            this.data = new byte[len];
            input.read(this.data);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        byte[] mimeTypeBytes = this.mimeType.getBytes();
        output.writeInt(mimeTypeBytes.length);
        output.write(mimeTypeBytes);
        output.writeInt(this.data.length);
        output.write(this.data);
        output.flush();
        return buffer.toByteArray();
    }
}

