/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.types.ObjectId;

public abstract class MongoDbIdConverter {
    public static Object toNative(Object dbId) {
        if (dbId == null) {
            return null;
        }
        if (dbId instanceof UUID) {
            return dbId;
        }
        if (dbId instanceof ObjectId) {
            return ((ObjectId)dbId).toHexString();
        }
        if (dbId instanceof String) {
            return UUID.fromString((String)dbId);
        }
        if (dbId instanceof BsonBinary) {
            return ((BsonBinary)dbId).asUuid();
        }
        return UUID.fromString(String.valueOf(dbId));
    }
}

