/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.mongo.MongoQuery;

public class MongoQueryBuilder
implements IQueryBuilder {
    static Map<IQueryBuilder.MatchOp, BiFunction<AttributeInfo, Object, Bson>> verifiers = new HashMap<IQueryBuilder.MatchOp, BiFunction<AttributeInfo, Object, Bson>>();
    Stack<Bson> predicates = new Stack();
    Bson projection = null;
    List<Bson> orderBys = null;
    Long first;
    Long last;

    static Bson verify_EQUALS(AttributeInfo info, Object value) {
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_ROUGHLY(AttributeInfo info, Object value) {
        if (info.getFamily() == Family.TEXT) {
            String regex = value.toString();
            for (char c : "[]()*?^.|&".toCharArray()) {
                String s = "\\" + c;
                regex = regex.replaceAll(s, Matcher.quoteReplacement(s));
            }
            return Filters.regex((String)MongoQueryBuilder.getAttributeName(info), (String)("^" + regex + "$"), (String)"i");
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_CONTAINS(AttributeInfo info, Object value) {
        if (info.getFamily() == Family.TEXT) {
            return Filters.regex((String)MongoQueryBuilder.getAttributeName(info), (String)(".*" + value + ".*"), (String)"i");
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_HAS(AttributeInfo info, Object value) {
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_HAS_ANY(AttributeInfo info, Object value) {
        if (value instanceof Collection) {
            return Filters.or((Iterable)((Collection)value).stream().map(v -> Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)v)).collect(Collectors.toList()));
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_HAS_ALL(AttributeInfo info, Object value) {
        if (value instanceof Collection) {
            return Filters.and((Iterable)((Collection)value).stream().map(v -> Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)v)).collect(Collectors.toList()));
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_IN(AttributeInfo info, Object value) {
        if (value instanceof Collection) {
            return Filters.or((Iterable)((Collection)value).stream().map(v -> Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)v)).collect(Collectors.toList()));
        }
        return Filters.eq((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_GREATER(AttributeInfo info, Object value) {
        return Filters.gt((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    static Bson verify_LESSER(AttributeInfo info, Object value) {
        return Filters.lt((String)MongoQueryBuilder.getAttributeName(info), (Object)value);
    }

    private static String getAttributeName(AttributeInfo info) {
        String name = info.getName();
        return "dbId".equals(name) ? "_id" : name;
    }

    public <T> MongoQueryBuilder verify(AttributeInfo info, IQueryBuilder.MatchOp match, T fieldValue) {
        Bson predicate = verifiers.get(match).apply(info, fieldValue);
        this.predicates.push(predicate);
        return this;
    }

    public MongoQueryBuilder and() {
        Bson right = this.predicates.pop();
        Bson left = this.predicates.pop();
        this.predicates.push(Filters.and((Bson[])new Bson[]{left, right}));
        return this;
    }

    public MongoQueryBuilder or() {
        Bson right = this.predicates.pop();
        Bson left = this.predicates.pop();
        this.predicates.push(Filters.or((Bson[])new Bson[]{left, right}));
        return this;
    }

    public MongoQueryBuilder not() {
        Bson top = this.predicates.pop();
        if (top.getClass().getSimpleName().endsWith("OrNorFilter")) {
            this.predicates.push(this.norify(top));
        } else {
            this.predicates.push(Filters.not((Bson)top));
        }
        return this;
    }

    private Bson norify(Bson predicate) {
        try {
            Class<?> klass = predicate.getClass();
            Field field = klass.getDeclaredField("operator");
            field.setAccessible(true);
            Enum value = (Enum)field.get(predicate);
            Enum[] values = (Enum[])value.getDeclaringClass().getEnumConstants();
            value = value.ordinal() == 0 ? values[1] : values[0];
            field.set(predicate, value);
            return predicate;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public MongoQueryBuilder first(Long first) {
        this.first = first;
        return this;
    }

    public MongoQueryBuilder last(Long last) {
        this.last = last;
        return this;
    }

    public IQueryBuilder project(List<String> projection) {
        HashSet<String> unique = new HashSet<String>(projection);
        unique.remove("dbId");
        unique.add("_id");
        unique.add("category");
        this.projection = Projections.include(new ArrayList<String>(unique));
        return this;
    }

    public MongoQueryBuilder orderBy(AttributeInfo attribute, boolean descending) {
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<Bson>();
        }
        Bson orderBy = descending ? Sorts.descending((String[])new String[]{attribute.getName()}) : Sorts.ascending((String[])new String[]{attribute.getName()});
        this.orderBys.add(orderBy);
        return this;
    }

    public IQuery build() {
        Bson predicate;
        Bson bson = predicate = this.predicates.empty() ? null : this.predicates.pop();
        if (!this.predicates.empty()) {
            throw new IllegalStateException("Unused query predicates!");
        }
        return new MongoQuery(predicate, this.first, this.last, this.projection, this.orderBys);
    }

    static {
        verifiers.put(IQueryBuilder.MatchOp.EQUALS, MongoQueryBuilder::verify_EQUALS);
        verifiers.put(IQueryBuilder.MatchOp.ROUGHLY, MongoQueryBuilder::verify_ROUGHLY);
        verifiers.put(IQueryBuilder.MatchOp.CONTAINS, MongoQueryBuilder::verify_CONTAINS);
        verifiers.put(IQueryBuilder.MatchOp.HAS, MongoQueryBuilder::verify_HAS);
        verifiers.put(IQueryBuilder.MatchOp.HAS_ANY, MongoQueryBuilder::verify_HAS_ANY);
        verifiers.put(IQueryBuilder.MatchOp.HAS_ALL, MongoQueryBuilder::verify_HAS_ALL);
        verifiers.put(IQueryBuilder.MatchOp.IN, MongoQueryBuilder::verify_IN);
        verifiers.put(IQueryBuilder.MatchOp.GREATER, MongoQueryBuilder::verify_GREATER);
        verifiers.put(IQueryBuilder.MatchOp.LESSER, MongoQueryBuilder::verify_LESSER);
    }
}

