/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.WriteModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.mongo.IMongoReplicaSetConfiguration;
import prompto.config.mongo.IMongoStoreConfiguration;
import prompto.error.AuditDisabledError;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoDbId;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.security.ISecretKeyFactory;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IAuditMetadata;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.store.mongo.BinaryData;
import prompto.store.mongo.MongoAuditor;
import prompto.store.mongo.MongoDbIdConverter;
import prompto.store.mongo.MongoQuery;
import prompto.store.mongo.MongoQueryBuilder;
import prompto.store.mongo.PromptoDateCodec;
import prompto.store.mongo.PromptoDateTimeCodec;
import prompto.store.mongo.PromptoDbIdCodec;
import prompto.store.mongo.PromptoTimeCodec;
import prompto.store.mongo.PromptoVersionCodec;
import prompto.store.mongo.StorableDocument;
import prompto.store.mongo.StoredDocument;
import prompto.store.mongo.StringArrayCodec;
import prompto.utils.Logger;

public class MongoStore
implements IStore {
    static final Logger logger = new Logger();
    static final String AUTH_DB_NAME = "admin";
    static final char[] EMPTY_PASSWORD = "<empty>".toCharArray();
    static final CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new PromptoDbIdCodec(), new PromptoDateCodec(), new PromptoTimeCodec(), new PromptoDateTimeCodec(), new PromptoVersionCodec(), new UuidCodec(UuidRepresentation.STANDARD), new StringArrayCodec()}), MongoClientSettings.getDefaultCodecRegistry()});
    MongoClient client;
    ClientSession session;
    MongoDatabase db;
    Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
    MongoAuditor auditor = null;
    static final Map<Family, Function<Object, Object>> readers = new HashMap<Family, Function<Object, Object>>();

    public static String uriFromConfig(IMongoStoreConfiguration config) {
        try {
            char[] password = MongoStore.passwordFromConfig(config);
            String replicaUri = config.getReplicaSetURI();
            IMongoReplicaSetConfiguration replicaConfig = config.getReplicaSetConfiguration();
            if (replicaUri != null) {
                return MongoStore.uriFromURIConfig(config, password);
            }
            if (replicaConfig != null) {
                return MongoStore.uriFromReplicaSetConfig(config, password);
            }
            return MongoStore.uriFromParams(config, password);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static String uriFromParams(IMongoStoreConfiguration config, char[] password) {
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://");
        if (password != null) {
            sb.append(config.getUser()).append(":").append(password).append("@");
        }
        sb.append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDbName());
        if (password != null) {
            sb.append("?authSource=admin");
        }
        return sb.toString();
    }

    private static String uriFromReplicaSetConfig(IMongoStoreConfiguration config, char[] password) {
        IMongoReplicaSetConfiguration replicaConfig = config.getReplicaSetConfiguration();
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://");
        if (password != null && password != EMPTY_PASSWORD) {
            sb.append(config.getUser()).append(":").append(password).append("@");
        }
        replicaConfig.getNodes().forEach(h -> sb.append(h.getHost()).append(':').append(h.getPort()).append(','));
        sb.setLength(sb.length() - 1);
        sb.append('/').append(config.getDbName()).append("?replicaSet=").append(replicaConfig.getName());
        if (password != null) {
            sb.append("&ssl=").append(replicaConfig.isSSL()).append("&authSource=admin");
        }
        return sb.toString();
    }

    private static String uriFromURIConfig(IMongoStoreConfiguration config, char[] password) {
        String uri = config.getReplicaSetURI();
        if (password != null) {
            uri = uri.replace("mongodb://", "mongodb://" + config.getUser() + ":" + new String(password) + "@");
        }
        return uri;
    }

    private static char[] passwordFromConfig(IMongoStoreConfiguration config) throws Exception {
        ISecretKeyConfiguration secret = config.getSecretKeyConfiguration();
        return secret == null ? null : ISecretKeyFactory.plainPasswordFromConfig((ISecretKeyConfiguration)secret).toCharArray();
    }

    public MongoStore(IMongoStoreConfiguration config) throws Exception {
        char[] password = MongoStore.passwordFromConfig(config);
        String replicaUri = config.getReplicaSetURI();
        IMongoReplicaSetConfiguration replicaConfig = config.getReplicaSetConfiguration();
        if (replicaUri != null) {
            this.connectWithURI(config, password);
        } else if (replicaConfig != null) {
            this.connectWithReplicaSetConfig(config, password);
        } else {
            this.connectWithParams(config, password);
        }
        this.startAuditor(() -> ((IMongoStoreConfiguration)config).getAudit());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    public MongoStore(String host, int port, String database, boolean audit) {
        this(host, port, database, audit, null, null);
    }

    public MongoStore(String host, int port, String database, boolean audit, String user, char[] password) {
        this.connectWithParams(host, port, database, user, password);
        this.startAuditor(() -> audit);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    public MongoStore(String uri, boolean audit, String user, char[] password) {
        this.connectWithURI(uri, user, password);
        this.startAuditor(() -> audit);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public synchronized void close() {
        this.stopAuditorIfStarted();
        this.closeSessionIfOpened();
        this.closeClientIfOpened();
    }

    private void closeClientIfOpened() {
        if (this.client != null) {
            logger.warn(() -> "Closing Mongo client: " + this.client.getClusterDescription().getShortDescription() + " for database: " + this.db.getName(), new Throwable());
            this.client.close();
            this.client = null;
        }
    }

    private void closeSessionIfOpened() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    private void connectWithReplicaSetConfig(IMongoStoreConfiguration config, char[] password) {
        String uri = MongoStore.uriFromReplicaSetConfig(config, password == null ? null : EMPTY_PASSWORD);
        this.connectWithURI(config.withReplicaSetURI(uri), password);
    }

    private void connectWithURI(IMongoStoreConfiguration config, char[] password) {
        MongoClientSettings.Builder builder = this.defaultBuilder();
        ConnectionString conn = new ConnectionString(config.getReplicaSetURI());
        builder = builder.applyConnectionString(conn);
        String dbName = config.getDbName() != null ? config.getDbName() : (conn.getDatabase() != null ? conn.getDatabase() : AUTH_DB_NAME);
        this.connect(builder, dbName, config.getUser(), password);
    }

    private void connectWithURI(String uri, String user, char[] password) {
        MongoClientSettings.Builder builder = this.defaultBuilder();
        ConnectionString conn = new ConnectionString(uri);
        builder = builder.applyConnectionString(conn);
        String dbName = conn.getDatabase() != null ? conn.getDatabase() : AUTH_DB_NAME;
        this.connect(builder, dbName, user, password);
    }

    private void connectWithParams(IMongoStoreConfiguration config, char[] password) {
        this.connectWithParams(config.getHost(), config.getPort(), config.getDbName(), config.getUser(), password);
    }

    private void connectWithParams(String host, int port, String database, String user, char[] password) {
        MongoClientSettings.Builder builder = this.defaultBuilder();
        builder = builder.applyToClusterSettings(clusterBuilder -> clusterBuilder.hosts(Collections.singletonList(new ServerAddress(host, port))));
        String dbName = database == null ? AUTH_DB_NAME : database;
        this.connect(builder, dbName, user, password);
    }

    private MongoClientSettings.Builder defaultBuilder() {
        return MongoClientSettings.builder().codecRegistry(codecRegistry).uuidRepresentation(UuidRepresentation.STANDARD).applyToSocketSettings(socketBuilder -> socketBuilder.readTimeout(6, TimeUnit.MINUTES).connectTimeout(6, TimeUnit.MINUTES));
    }

    private void connect(MongoClientSettings.Builder builder, String dbName, String user, char[] password) {
        MongoClientSettings settings;
        String replicaSet;
        if (user != null && password != null) {
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)AUTH_DB_NAME, (char[])password);
            builder = builder.credential(credential);
        }
        String dbServer = (replicaSet = (settings = builder.build()).getClusterSettings().getRequiredReplicaSetName()) != null ? replicaSet : ((ServerAddress)settings.getClusterSettings().getHosts().get(0)).getHost();
        logger.info(() -> "Connecting " + (String)(user == null ? "anonymously" : "user '" + user + "'") + " to '" + dbName + "' database @" + dbServer);
        this.client = MongoClients.create((MongoClientSettings)settings);
        this.session = replicaSet == null ? null : this.client.startSession();
        this.db = this.client.getDatabase(dbName);
        if (!AUTH_DB_NAME.equals(dbName)) {
            this.loadAttributes();
        }
        logger.info(() -> "Connected to '" + dbName + "' database @" + dbServer);
    }

    public boolean checkConnection() {
        try {
            return this.client.getDatabase(AUTH_DB_NAME) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class<?> getNativeDbIdClass() {
        return UUID.class;
    }

    public Object newNativeDbId() {
        return UUID.randomUUID();
    }

    public Object convertToNativeDbId(Object dbId) {
        return MongoDbIdConverter.toNative(dbId);
    }

    public AttributeInfo getAttributeInfo(String name) throws PromptoError {
        return this.attributes.get(name);
    }

    void loadAttributes() {
        for (Document doc : this.db.getCollection("attributes").find()) {
            this.loadAttribute(doc);
        }
    }

    void loadAttribute(Document doc) {
        String name = doc.getString((Object)"name");
        Family family = Family.valueOf((String)doc.getString((Object)"family"));
        boolean collection = doc.getBoolean((Object)"collection", false);
        boolean general = doc.getBoolean((Object)"general", false);
        boolean key = doc.getBoolean((Object)"key", false);
        boolean value = doc.getBoolean((Object)"value", false);
        boolean words = doc.getBoolean((Object)"words", false);
        this.attributes.put(name, new AttributeInfo(name, family, collection, general, key, value, words));
    }

    void loadAttribute(String name) {
        Document doc = (Document)this.db.getCollection("attributes").find().filter(Filters.eq((String)"name", (Object)name)).first();
        if (doc != null) {
            this.loadAttribute(doc);
        }
    }

    public void createOrUpdateAttributes(Collection<AttributeInfo> infos) throws PromptoError {
        this.storeAttributes(infos);
        this.loadAttributes();
        this.createIndicesIfRequired();
    }

    private void createIndicesIfRequired() {
        this.attributes.values().stream().filter(AttributeInfo::isIndexed).forEach(this::createIndexIfRequired);
    }

    private void createIndexIfRequired(AttributeInfo info) {
        if (info.isGeneral()) {
            this.createGeneralIndexIfRequired(info.getName());
        }
        if (info.isKey()) {
            this.createKeyIndexIfRequired(info.getName());
        }
        if (info.isValue()) {
            this.createValueIndexIfRequired(info.getName());
        }
    }

    private void createGeneralIndexIfRequired(String name) {
        this.createKeyIndexIfRequired(name);
    }

    private boolean indexExists(String indexName) {
        return MongoStore.indexExists(this.getInstancesCollection(), indexName);
    }

    static boolean indexExists(MongoCollection<Document> collection, String indexName) {
        ListIndexesIterable indices = collection.listIndexes();
        return StreamSupport.stream(indices.spliterator(), false).map(doc -> doc.get((Object)"key")).map(o -> (Document)o).map(Document::keySet).anyMatch(s -> s.contains(indexName));
    }

    private void createValueIndexIfRequired(String name) {
        String indexName = name + "_value";
        if (!this.indexExists(indexName)) {
            Collation collation = Collation.builder().locale("en").collationStrength(CollationStrength.PRIMARY).build();
            IndexOptions options = new IndexOptions().unique(false).collation(collation).name(indexName);
            Bson keys = Indexes.ascending((String[])new String[]{name});
            this.getInstancesCollection().createIndex(keys, options);
        }
    }

    private void createKeyIndexIfRequired(String name) {
        String indexName = name + "_key";
        if (!this.indexExists(indexName)) {
            IndexOptions options = new IndexOptions().unique(false).name(indexName);
            Bson keys = Indexes.ascending((String[])new String[]{name});
            this.getInstancesCollection().createIndex(keys, options);
        }
    }

    private void storeAttributes(Collection<AttributeInfo> infos) {
        List operations = infos.stream().map(this::buildWriteModel).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            MongoCollection coll = this.db.getCollection("attributes");
            coll.bulkWrite(operations);
        }
    }

    private UpdateOneModel<Document> buildWriteModel(AttributeInfo attribute) {
        Document data = new Document();
        data.put("name", (Object)attribute.getName());
        data.put("family", (Object)attribute.getFamily().name());
        data.put("collection", (Object)attribute.isCollection());
        data.put("key", (Object)attribute.isKey());
        data.put("value", (Object)attribute.isValue());
        data.put("words", (Object)attribute.isWords());
        Bson filter = Filters.eq((String)"name", (Object)attribute.getName());
        UpdateOneModel model = new UpdateOneModel(filter, (Bson)new Document("$set", (Object)data));
        model.getOptions().upsert(true);
        return model;
    }

    void startAuditor(Supplier<Boolean> config) {
        Boolean enabled = config.get();
        if (enabled != null && enabled.booleanValue()) {
            this.startAuditorIfSupported();
        } else {
            logger.info(() -> "Not starting Auditor because it is disabled");
        }
    }

    private void startAuditorIfSupported() {
        if (this.supportsAudit()) {
            this.auditor = new MongoAuditor(this);
            this.auditor.start();
            logger.info(() -> "Starting Auditor");
        } else {
            logger.info(() -> "Not starting Auditor because it is not supported");
        }
    }

    void stopAuditorIfStarted() {
        if (this.auditor != null) {
            this.auditor.stop();
            this.auditor = null;
        }
    }

    public IStorable newStorable(String[] categories, IStorable.IDbIdFactory dbIdFactory) {
        return new StorableDocument(categories, dbIdFactory);
    }

    public void deleteAndStore(Collection<PromptoDbId> deletables, Collection<IStorable> storables, IAuditMetadata auditMetadata) throws PromptoError {
        List<WriteModel<Document>> operations = this.buildWriteModels(deletables, storables);
        if (!operations.isEmpty()) {
            this.writeOperations((MongoAuditor.AuditMetadata)auditMetadata, operations);
        }
    }

    private void writeOperations(MongoAuditor.AuditMetadata auditMetadata, List<WriteModel<Document>> operations) {
        if (this.session != null) {
            this.writeTransaction(auditMetadata, operations);
        } else {
            this.writeBulk(operations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransaction(MongoAuditor.AuditMetadata auditMetadata, List<WriteModel<Document>> operations) {
        ClientSession clientSession = this.session;
        synchronized (clientSession) {
            TransactionOptions txnOptions = TransactionOptions.builder().readPreference(ReadPreference.primary()).readConcern(ReadConcern.LOCAL).writeConcern(WriteConcern.MAJORITY).build();
            this.session.startTransaction(txnOptions);
            try {
                if (this.auditor != null) {
                    auditMetadata = this.auditor.populateAuditMetadata(this.session, auditMetadata);
                    this.db.getCollection("auditMetadatas").insertOne((Object)auditMetadata);
                }
                this.getInstancesCollection().bulkWrite(this.session, operations);
                this.session.commitTransaction();
            }
            catch (Throwable t) {
                this.session.abortTransaction();
                logger.error(() -> "While writing transaction...", t);
            }
        }
    }

    private void writeBulk(List<WriteModel<Document>> operations) {
        this.getInstancesCollection().bulkWrite(operations);
    }

    private List<WriteModel<Document>> buildWriteModels(Collection<PromptoDbId> deletables, Collection<IStorable> storables) {
        Stream<WriteModel> deletes = null;
        Stream<WriteModel> upserts = null;
        if (deletables != null) {
            deletes = deletables.stream().map(d -> new DeleteOneModel(Filters.eq((String)"_id", (Object)d.getValue())));
        }
        if (storables != null) {
            upserts = storables.stream().map(s -> ((StorableDocument)s).toWriteModel());
        }
        if (deletes == null && upserts == null) {
            return Collections.emptyList();
        }
        Stream<Object> all = null;
        all = deletes == null ? upserts : (upserts == null ? deletes : Stream.of(deletes, upserts).flatMap(Function.identity()));
        return all.collect(Collectors.toList());
    }

    public void deleteAll() throws PromptoError {
        throw new UnsupportedOperationException();
    }

    public PromptoBinary fetchBinary(String table, PromptoDbId dbId, String attr) throws PromptoError {
        Bson filter = Filters.eq((String)"_id", (Object)dbId);
        MongoCollection collection = table == null ? this.getInstancesCollection() : this.db.getCollection(table);
        try (MongoCursor found = collection.find(filter).limit(1).projection(Projections.include((String[])new String[]{attr})).iterator();){
            if (!found.hasNext()) {
                PromptoBinary promptoBinary = null;
                return promptoBinary;
            }
            Document doc = (Document)found.next();
            String[] attrs = attr.split("\\.");
            Object data = null;
            for (int i = 0; i < attrs.length; ++i) {
                data = doc.get((Object)attrs[i]);
                if (data == null) {
                    PromptoBinary promptoBinary = null;
                    return promptoBinary;
                }
                if (!(data instanceof Document)) continue;
                doc = (Document)data;
            }
            data = table == null ? this.readFieldData(attr, data) : this.readFieldData(new AttributeInfo(attrs[attrs.length - 1], Family.BLOB, false, null), data);
            if (data instanceof PromptoBinary) {
                PromptoBinary promptoBinary = (PromptoBinary)data;
                return promptoBinary;
            }
            PromptoBinary promptoBinary = null;
            return promptoBinary;
        }
    }

    public IStored fetchUnique(PromptoDbId dbId) throws PromptoError {
        Bson filter = Filters.eq((String)"_id", (Object)dbId);
        return this.fetchOne(filter, null);
    }

    public IQueryBuilder newQueryBuilder() {
        return new MongoQueryBuilder();
    }

    public IStored fetchOne(IQuery query) throws PromptoError {
        MongoQuery q = (MongoQuery)query;
        return this.fetchOne(q.predicate, q.projection);
    }

    private IStored fetchOne(Bson filter, Bson projection) throws PromptoError {
        FindIterable iterable = this.getInstancesCollection().find(filter).limit(1);
        if (projection != null) {
            iterable = iterable.projection(projection);
        }
        try (MongoCursor found = iterable.iterator();){
            if (found.hasNext()) {
                StoredDocument storedDocument = new StoredDocument(this, (Document)found.next());
                return storedDocument;
            }
            IStored iStored = null;
            return iStored;
        }
    }

    public IStoredIterable fetchMany(IQuery query) throws PromptoError {
        MongoCollection<Document> coll = this.getInstancesCollection();
        return new StoredIterable(coll, (MongoQuery)query);
    }

    MongoCollection<Document> getInstancesCollection() {
        return this.db.getCollection("instances");
    }

    public long nextSequenceValue(String name) {
        MongoCollection sequences = this.db.getCollection("sequences");
        Bson filter = Filters.eq((String)"_id", (Object)name);
        Bson update = Updates.inc((String)"sequence", (Number)1);
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        Document result = (Document)sequences.findOneAndUpdate(filter, update, options);
        return ((Number)result.get((Object)"sequence")).longValue();
    }

    public void flush() throws PromptoError {
    }

    static PromptoBinary binaryToPromptoBinary(Object o) {
        try {
            BinaryData bin = new BinaryData(((Binary)o).getData());
            return new PromptoBinary(bin.getMimeType(), bin.getData());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object readFieldData(String fieldName, Object data) {
        AttributeInfo info = this.attributes.get(fieldName);
        if (info == null) {
            this.loadAttribute(fieldName);
            info = this.attributes.get(fieldName);
        }
        if (info == null) {
            logger.error(() -> "Missing AttributeInfo for: " + fieldName);
            return null;
        }
        return this.readFieldData(info, data);
    }

    public Object readFieldData(AttributeInfo info, Object data) {
        if (info.isCollection() && data instanceof Collection) {
            return this.readCollectionData(info, (Collection)data);
        }
        return readers.getOrDefault(info.getFamily(), o -> o).apply(data);
    }

    private Object readCollectionData(AttributeInfo info, Collection<Object> data) {
        Function<Object, Object> reader = readers.getOrDefault(info.getFamily(), o -> o);
        List list = data.stream().map(reader::apply).collect(Collectors.toList());
        return new PromptoList(list, false);
    }

    public void insertDocuments(Document ... docs) {
        this.getInstancesCollection().insertMany(Arrays.asList(docs));
    }

    public Map<String, Object> fetchConfiguration(String name) {
        MongoCollection configs = this.db.getCollection("configurations");
        FindIterable find = configs.find().filter(Filters.eq((String)"_id", (Object)name)).limit(1);
        try (MongoCursor iter = find.iterator();){
            if (iter.hasNext()) {
                Map map = (Map)iter.next();
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    public void storeConfiguration(String name, Map<String, Object> data) {
        Document config = new Document();
        config.putAll(data);
        Bson filter = Filters.eq((String)"_id", (Object)name);
        MongoCollection configs = this.db.getCollection("configurations");
        ReplaceOptions options = new ReplaceOptions().upsert(true);
        configs.replaceOne(filter, (Object)config, options);
    }

    public boolean isAuditEnabled() {
        return this.auditor != null;
    }

    boolean supportsAudit() {
        String rsName = this.client.getClusterDescription().getClusterSettings().getRequiredReplicaSetName();
        return rsName != null;
    }

    private void checkAuditEnabled() {
        if (this.auditor == null) {
            throw new AuditDisabledError();
        }
    }

    public MongoAuditor.AuditMetadata newAuditMetadata() {
        this.checkAuditEnabled();
        return this.auditor.newAuditMetadata();
    }

    public PromptoDbId fetchLatestAuditMetadataId(PromptoDbId dbId) {
        this.checkAuditEnabled();
        return this.auditor.fetchLatestAuditMetadataId(dbId);
    }

    public PromptoList<PromptoDbId> fetchAllAuditMetadataIds(PromptoDbId dbId) {
        this.checkAuditEnabled();
        return this.auditor.fetchAllAuditMetadataIds(dbId);
    }

    public IAuditMetadata fetchAuditMetadata(PromptoDbId metaId) {
        this.checkAuditEnabled();
        return this.auditor.newAuditMetadata();
    }

    public PromptoList<PromptoDbId> fetchDbIdsAffectedByAuditMetadataId(PromptoDbId auditId) {
        this.checkAuditEnabled();
        return this.auditor.fetchDbIdsAffectedByAuditMetadataId(auditId);
    }

    public MongoAuditor.AuditRecord fetchLatestAuditRecord(PromptoDbId dbId) {
        this.checkAuditEnabled();
        return this.auditor.fetchLatestAuditRecord(dbId);
    }

    public PromptoList<MongoAuditor.AuditRecord> fetchAllAuditRecords(PromptoDbId dbId) {
        this.checkAuditEnabled();
        return this.auditor.fetchAllAuditRecords(dbId);
    }

    public PromptoList<MongoAuditor.AuditRecord> fetchAuditRecordsMatching(Map<String, Object> auditPredicates, Map<String, Object> instancePredicates) {
        this.checkAuditEnabled();
        return this.auditor.fetchAuditRecordsMatching(auditPredicates, instancePredicates);
    }

    static {
        readers.put(Family.DATE, o -> o instanceof Long ? PromptoDate.fromJavaTime((long)((Long)o)) : null);
        readers.put(Family.TIME, o -> o instanceof Long ? PromptoTime.fromMillisOfDay((long)((Long)o)) : null);
        readers.put(Family.DATETIME, o -> o instanceof Document ? PromptoDateTime.parse((String)((Document)o).getString((Object)"text")) : null);
        readers.put(Family.BLOB, MongoStore::binaryToPromptoBinary);
        readers.put(Family.IMAGE, MongoStore::binaryToPromptoBinary);
        readers.put(Family.VERSION, o -> PromptoVersion.parseInt((int)((Integer)o)));
    }

    class StoredIterable
    implements IStoredIterable {
        MongoCollection<Document> collection;
        MongoQuery query;
        Long totalCount = null;
        Long count = null;

        StoredIterable(MongoCollection<Document> collection, MongoQuery query) {
            this.collection = collection;
            this.query = query;
        }

        public Iterator<IStored> iterator() {
            FindIterable find = this.collection.find();
            if (this.query != null) {
                if (this.query.predicate != null) {
                    find = find.filter(this.query.predicate);
                }
                if (this.query.first != null && this.query.last != null) {
                    if (this.query.first > 1L) {
                        find = find.skip(this.query.first.intValue() - 1);
                    }
                    find = find.limit((int)(1L + this.query.last - this.query.first));
                }
                if (this.query.projection != null) {
                    find = find.projection(this.query.projection);
                }
                if (this.query.orderBys != null) {
                    find = find.sort(Sorts.orderBy(this.query.orderBys));
                }
            }
            final MongoCursor iter = find.iterator();
            return new Iterator<IStored>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public IStored next() {
                    return new StoredDocument(MongoStore.this, (Document)iter.next());
                }

                public void finalize() {
                    iter.close();
                }
            };
        }

        public long totalCount() {
            if (this.totalCount == null) {
                this.totalCount = this.query == null || this.query.predicate == null ? Long.valueOf(this.collection.estimatedDocumentCount()) : Long.valueOf(this.collection.countDocuments(this.query.predicate));
            }
            return this.totalCount;
        }

        public long count() {
            if (this.count == null) {
                if (this.query != null && this.query.first != null && this.query.last != null) {
                    this.count = 1L + this.query.last - this.query.first;
                    if (this.query.first + this.count - 1L > this.totalCount()) {
                        this.count = this.totalCount() + 1L - this.query.first;
                    }
                } else {
                    this.count = this.totalCount();
                }
            }
            return this.count;
        }
    }
}

