/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.util.UUID;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.internal.UuidHelper;
import prompto.intrinsic.PromptoDbId;

public class PromptoDbIdCodec
implements Codec<PromptoDbId> {
    public void encode(BsonWriter writer, PromptoDbId value, EncoderContext encoderContext) {
        Object dbId = value.getValue();
        BsonBinary binaryData = null;
        if (dbId instanceof BsonBinary) {
            binaryData = (BsonBinary)dbId;
        } else if (dbId instanceof UUID) {
            binaryData = new BsonBinary(BsonBinarySubType.UUID_STANDARD, UuidHelper.encodeUuidToBinary((UUID)((UUID)dbId), (UuidRepresentation)UuidRepresentation.STANDARD));
        } else {
            throw new IllegalArgumentException(dbId.getClass().getName());
        }
        writer.writeBinaryData(binaryData);
    }

    public PromptoDbId decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.UUID_LEGACY.getValue() && subType != BsonBinarySubType.UUID_STANDARD.getValue()) {
            throw new BSONException("Unexpected BsonBinarySubType");
        }
        byte[] bytes = reader.readBinaryData().getData();
        return PromptoDbId.of((Object)UuidHelper.decodeBinaryToUuid((byte[])bytes, (byte)subType, (UuidRepresentation)UuidRepresentation.STANDARD));
    }

    public Class<PromptoDbId> getEncoderClass() {
        return PromptoDbId.class;
    }

    public String toString() {
        return "PromptoDbIdCodec";
    }
}

